/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.StreamEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedInputStream
extends InputStream {
    private InputStream father = null;
    private StreamEncoder encryptor = null;
    private ByteArrayInputStream memoryStream = null;

    public EncryptedInputStream(InputStream inputStream) {
        this.father = inputStream;
    }

    public void SetMemoryStream(InputStream inputStream) {
        this.memoryStream = (ByteArrayInputStream)inputStream;
    }

    public void SetEncryptor(StreamEncoder streamEncoder) {
        this.encryptor = streamEncoder;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        this.read(byArray, 0, 1);
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (null != this.memoryStream && 0 < this.memoryStream.available()) {
            return this.memoryStream.read(byArray, n, n2);
        }
        int n3 = 0;
        int n4 = 0;
        do {
            if ((n4 = this.father.read(byArray, n + n3, n2 - n3)) >= 0) continue;
            n3 = n4;
            break;
        } while ((n3 += n4) < n2 && n4 != 0);
        if (null == this.encryptor) {
            return n3;
        }
        if (n3 > 0) {
            this.encryptor.DecryptBytes(byArray, n, n3);
        }
        return n3;
    }

    public int available() throws IOException {
        if (null != this.memoryStream && 0 < this.memoryStream.available()) {
            return this.memoryStream.available();
        }
        return this.father.available();
    }

    public void close() throws IOException {
        this.father.close();
        if (null != this.memoryStream) {
            this.memoryStream.close();
        }
    }
}

