/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PRectangle
extends Rectangle2D.Float {
    private float p1x;
    private float p1y;
    private float p2x;
    private float p2y;

    public PRectangle(Point2D.Float p1, Point2D.Float p2) {
        this.normalizeCoordinates(p1.x, p1.y, p2.x, p2.y);
        this.p1x = p1.x;
        this.p1y = p1.y;
        this.p2x = p2.x;
        this.p2y = p2.y;
    }

    private PRectangle(float x, float y, float width, float height) {
        super(x, y, width, height);
    }

    public PRectangle(List coordinates) throws IllegalArgumentException {
        if (coordinates == null || coordinates.size() < 4) {
            throw new IllegalArgumentException();
        }
        float x1 = ((Number)coordinates.get(0)).floatValue();
        float y1 = ((Number)coordinates.get(1)).floatValue();
        float x2 = ((Number)coordinates.get(2)).floatValue();
        float y2 = ((Number)coordinates.get(3)).floatValue();
        this.p1x = x1;
        this.p1y = y1;
        this.p2x = x2;
        this.p2y = y2;
        this.normalizeCoordinates(x1, y1, x2, y2);
    }

    public PRectangle createCartesianIntersection(PRectangle src2) {
        PRectangle rec = new PRectangle(src2.x, src2.y, src2.width, src2.height);
        float xLeft = this.x > rec.x ? this.x : rec.x;
        float xRight = this.x + this.width > rec.x + rec.width ? rec.x + rec.width : this.x + this.width;
        float yBottom = this.y - this.height < rec.y - rec.height ? rec.y - rec.height : this.y - this.height;
        float yTop = this.y > rec.y ? rec.y : this.y;
        rec.x = xLeft;
        rec.y = yTop;
        rec.width = xRight - xLeft;
        rec.height = yTop - yBottom;
        if (rec.width < 0.0f || rec.height < 0.0f) {
            rec.height = 0.0f;
            rec.width = 0.0f;
            rec.y = 0.0f;
            rec.x = 0.0f;
        }
        return rec;
    }

    public Rectangle2D.Float getOriginalPoints() {
        return new Rectangle2D.Float(this.p1x, this.p1y, this.p2x, this.p2y);
    }

    public Rectangle2D.Float toJava2dCoordinates() {
        return new Rectangle2D.Float(this.x, this.y - this.height, this.width, this.height);
    }

    public static List getPRectangleVector(Rectangle2D rect) {
        rect = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        ArrayList<Double> coords = new ArrayList<Double>(4);
        coords.add(rect.getMinX());
        coords.add(rect.getMinY());
        coords.add(rect.getMaxX());
        coords.add(rect.getMaxY());
        return coords;
    }

    private void normalizeCoordinates(float x1, float y1, float x2, float y2) {
        float x = x1;
        float y = y1;
        float w = Math.abs(x2 - x1);
        float h = Math.abs(y2 - y1);
        if (x1 > x2) {
            x = x2;
        }
        if (y1 < y2) {
            y = y2;
        }
        this.setRect(x, y, w, h);
    }
}

