/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.AbstractExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.BooleanLiteral;
import com.jidesoft.thirdparty.prefuse.data.expression.NumericLiteral;
import com.jidesoft.thirdparty.prefuse.data.expression.ObjectLiteral;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;

public abstract class Literal
extends AbstractExpression {
    public static Literal getLiteral(Tuple tuple, String string) {
        Class clazz = tuple.getColumnType(string);
        if (clazz == Integer.TYPE) {
            return new NumericLiteral(tuple.getInt(string));
        }
        if (clazz == Long.TYPE) {
            return new NumericLiteral(tuple.getLong(string));
        }
        if (clazz == Float.TYPE) {
            return new NumericLiteral(tuple.getFloat(string));
        }
        if (clazz == Double.TYPE) {
            return new NumericLiteral(tuple.getDouble(string));
        }
        if (clazz == Boolean.TYPE) {
            return new BooleanLiteral(tuple.getBoolean(string));
        }
        return new ObjectLiteral(tuple.get(string));
    }

    public static Literal getLiteral(Object object) {
        return Literal.getLiteral(object, object.getClass());
    }

    public static Literal getLiteral(Object object, Class clazz) {
        if (TypeLib.isNumericType(clazz)) {
            return new NumericLiteral(object);
        }
        if (clazz == Boolean.TYPE) {
            return new BooleanLiteral((Boolean)object);
        }
        if (clazz.isInstance(object)) {
            return new ObjectLiteral(object);
        }
        throw new IllegalArgumentException("Object does not match the provided Class type.");
    }
}

