/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.Arrays;

public class IntColumn
extends AbstractColumn {
    private int[] \u0113;
    private int \u0112;

    public IntColumn() {
        this(0, 10, -1);
    }

    public IntColumn(int n2) {
        this(n2, n2, -1);
    }

    public IntColumn(int n2, int n3, int n4) {
        super(Integer.TYPE, new Integer(n4));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.\u0113 = new int[n3];
        Arrays.fill(this.\u0113, n4);
        this.\u0112 = n2;
    }

    @Override
    public int getRowCount() {
        return this.\u0112;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.\u0113.length) {
            int n3 = Math.max(3 * this.\u0113.length / 2 + 1, n2);
            int[] nArray = new int[n3];
            System.arraycopy(this.\u0113, 0, nArray, 0, this.\u0112);
            Arrays.fill(nArray, this.\u0112, n3, (Integer)this.m_defaultValue);
            this.\u0113 = nArray;
        }
        this.\u0112 = n2;
    }

    @Override
    public Object get(int n2) {
        return new Integer(this.getInt(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setInt(((Number)object).intValue(), n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.\u0112) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.\u0113[n2];
    }

    @Override
    public void setInt(int n2, int n3) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n3 < 0 || n3 >= this.\u0112) {
            throw new IllegalArgumentException("Row index out of bounds: " + n3);
        }
        int n4 = this.\u0113[n3];
        if (n4 == n2) {
            return;
        }
        this.\u0113[n3] = n2;
        this.fireColumnEvent(n3, n4);
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        return this.getInt(n2);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        return this.getInt(n2);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        return this.getInt(n2);
    }
}

