/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter \u0131;
    private static final Color \u0133 = new Color(204, 204, 255);
    private Color \u0135 = null;
    private int \u0130 = -1;
    private A \u0132 = new A();
    private String \u0134 = null;

    public TextComponentSearchable(JTextComponent jTextComponent) {
        super(jTextComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(\u0133);
    }

    public void uninstallHighlightsRemover() {
        DelegateAction.restoreAction(this._component, 0, KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        DelegateAction.replaceAction(this._component, 0, KeyStroke.getKeyStroke(27, 0), new DelegateAction(){
            private static final long \u0124 = 8572103995404313032L;

            @Override
            public boolean isDelegateEnabled() {
                Iterator iterator;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(iterator = TextComponentSearchable.this.\u0132.\u0102()).hasNext()) {
                    return false;
                }
                return super.isDelegateEnabled();
            }

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                Iterator iterator;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(iterator = TextComponentSearchable.this.\u0132.\u0102()).hasNext()) {
                    return false;
                }
                TextComponentSearchable.this.removeAllHighlights();
                return true;
            }
        });
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl) {
        if (this._component instanceof JTextComponent) {
            if (n2 == -1) {
                this.removeAllHighlights();
                this.\u0130 = -1;
                return;
            }
            if (!bl) {
                this.removeAllHighlights();
            }
            String string = this.getSearchingText();
            try {
                this.addHighlight(n2, string, bl);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void addHighlight(final int n2, final String string, boolean bl) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            final JTextComponent jTextComponent = (JTextComponent)this._component;
            Object object = jTextComponent.getHighlighter().addHighlight(n2, n2 + string.length(), this.\u0131);
            this.\u0132.\u0102(object);
            this.\u0130 = n2;
            if (!bl) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TextComponentSearchable.this.\u0101(jTextComponent, n2, string.length());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void \u0101(JTextComponent jTextComponent, int n2, int n3) {
        if (n2 != -1) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n2);
                if (rectangle == null) {
                    return;
                }
                Rectangle rectangle2 = jTextComponent.modelToView(n2 + n3);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle rectangle3 = this._component.getVisibleRect();
                if (rectangle.x <= rectangle3.width) {
                    rectangle.width = rectangle2.x;
                    rectangle.x = 0;
                } else {
                    rectangle.width = rectangle2.x - rectangle.x;
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator iterator = this.\u0132.\u0102();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(e2);
            }
            this.\u0132.\u0101();
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this.\u0130;
        }
        return 0;
    }

    @Override
    protected Object getElementAt(int n2) {
        String string = this.getSearchingText();
        if (string != null && this._component instanceof JTextComponent) {
            int n3;
            int n4 = n2 + string.length();
            if (n4 > (n3 = this.getElementCount())) {
                n4 = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(n2, n4 - n2 + 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return "";
    }

    @Override
    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this.\u0134 = null;
            if (propertyChangeEvent.getOldValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).removeDocumentListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this.\u0134 = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this.\u0134 = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this.\u0134 = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent keyEvent) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 70 && JideSwingUtilities.isMenuShortcutKeyDown(keyEvent);
        }
        return super.isActivateKey(keyEvent);
    }

    public Color getHighlightColor() {
        if (this.\u0135 != null) {
            return this.\u0135;
        }
        return \u0133;
    }

    public void setHighlightColor(Color color) {
        this.\u0135 = color;
        this.\u0131 = new DefaultHighlighter.DefaultHighlightPainter(this.\u0135);
    }

    @Override
    public int findLast(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.\u0109();
            if (this.isCaseSensitive()) {
                return string2.lastIndexOf(string);
            }
            return TextComponentSearchable.\u0101(string2, string, string2.length());
        }
        return super.findLast(string);
    }

    private String \u0109() {
        if (this.\u0134 == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String string;
                this.\u0134 = string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }
        return this.\u0134;
    }

    @Override
    public int findFirst(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.\u0109();
            if (this.isCaseSensitive()) {
                return string2.indexOf(string);
            }
            return TextComponentSearchable.\u0102(string2, string, 0);
        }
        return super.findFirst(string);
    }

    static int \u0101(String string, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = n3 - n4;
        if (n2 < 0) {
            return -1;
        }
        if (n2 > n5) {
            n2 = n5;
        }
        if (n4 == 0) {
            return n2;
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n6 = n4 - 1;
        int n7 = n4 - 1;
        int n8 = n7 + n2;
        while (n8 >= n7) {
            while (n8 >= n7 && string.charAt(n8) != cArray[n6] && string.charAt(n8) != cArray2[n6]) {
                --n8;
            }
            if (n8 < n7) break;
            int n9 = n8 - 1;
            int n10 = n9 - (n4 - 1);
            int n11 = n6 - 1;
            while (n9 > n10) {
                char c2 = string.charAt(n9);
                if (c2 != cArray[n11] && c2 != cArray2[n11]) {
                    --n8;
                    break;
                }
                --n9;
                --n11;
            }
            if (n9 > n10) continue;
            return n10 + 1;
        }
        return -1;
    }

    private static int \u0102(String string, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        if (n2 >= n3) {
            return n4 == 0 ? n3 : -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 == 0) {
            return n2;
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n5 = n3 - n4;
        for (int i2 = n2; i2 <= n5; ++i2) {
            char c2;
            int n6;
            char c3 = string.charAt(i2);
            if (c3 != cArray[0] && c3 != cArray2[0]) {
                ++i2;
                while (i2 <= n5 && string.charAt(i2) != cArray[0] && string.charAt(i2) != cArray2[0]) {
                    ++i2;
                }
            }
            if (i2 > n5) continue;
            int n7 = n6 + n4 - 1;
            int n8 = 1;
            for (n6 = i2 + 1; n6 < n7 && ((c2 = string.charAt(n6)) == cArray[n8] || c2 == cArray2[n8]); ++n6) {
                ++n8;
            }
            if (n6 != n7) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int findFromCursor(String string) {
        int n2;
        int n3;
        String string2;
        if (this.isCountMatch()) {
            string2 = this.\u0109();
            n3 = 0;
            this._matchCount = -1;
            do {
                n2 = n3;
                n3 = (this.isCaseSensitive() ? string2.indexOf(string, n2) : TextComponentSearchable.\u0102(string2, string, n2)) + 1;
                ++this._matchCount;
            } while (n3 > n2);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n4;
            string2 = this.\u0109();
            int n5 = n2 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n4 = this.isCaseSensitive() ? string2.indexOf(string, n2) : TextComponentSearchable.\u0102(string2, string, n2);
            if (n4 == -1) {
                int n7 = n4 = this.isCaseSensitive() ? string2.indexOf(string, 0) : TextComponentSearchable.\u0102(string2, string, 0);
                if (n4 >= n2) {
                    n4 = -1;
                }
            }
            return n4;
        }
        return super.findFromCursor(string);
    }

    @Override
    public int reverseFindFromCursor(String string) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n2;
            int n3;
            int n4;
            String string2 = this.\u0109();
            int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, n4) : TextComponentSearchable.\u0101(string2, string, n4);
            if (n2 == -1) {
                int n7 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, string2.length() - 1) : TextComponentSearchable.\u0101(string2, string, string2.length() - 1);
                if (n2 <= n4) {
                    n2 = -1;
                }
            }
            return n2;
        }
        return super.findFromCursor(string);
    }

    @Override
    public int findNext(String string) {
        if (this._component instanceof JTextComponent) {
            int n2;
            int n3;
            int n4;
            String string2 = this.\u0109();
            int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n2 = this.isCaseSensitive() ? string2.indexOf(string, n4 + 1) : TextComponentSearchable.\u0102(string2, string, n4 + 1);
            if (n2 == -1 && this.isRepeats()) {
                int n7 = n2 = this.isCaseSensitive() ? string2.indexOf(string, 0) : TextComponentSearchable.\u0102(string2, string, 0);
                if (n2 > n4) {
                    n2 = -1;
                }
            }
            return n2;
        }
        return super.findNext(string);
    }

    @Override
    public int findPrevious(String string) {
        if (this._component instanceof JTextComponent) {
            int n2;
            int n3;
            int n4;
            String string2 = this.\u0109();
            int n5 = n4 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n6 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, n4 - 1) : TextComponentSearchable.\u0101(string2, string, n4 - 1);
            if (n2 == -1 && this.isRepeats()) {
                int n7 = n2 = this.isCaseSensitive() ? string2.lastIndexOf(string, n3 - 1) : TextComponentSearchable.\u0101(string2, string, n3 - 1);
                if (n2 < n4) {
                    n2 = -1;
                }
            }
            return n2;
        }
        return super.findPrevious(string);
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        this.\u0130 = -1;
    }

    @Override
    protected void searchingTextEmpty() {
        this.setSelectedIndex(-1, false);
    }

    private class A
    extends HashMap {
        private A() {
        }

        public void \u0102(Object object) {
            this.put(object, null);
        }

        public void \u0101(Object object) {
            this.remove(object);
        }

        public Iterator \u0102() {
            return this.keySet().iterator();
        }

        public void \u0101() {
            this.clear();
        }
    }
}

