/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.converter.DateConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.status.A;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullButton;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressStatusBarItem
extends StatusBarItem {
    public JidePopup _popup;
    private JLabel \u0111;
    private JLabel \u0115;
    private JProgressBar \u0117;
    private AbstractButton \u0112;
    private CancelCallback \u0118;
    private String \u0110 = null;
    private String \u0116 = null;
    private final String \u0113 = "Status";
    private final String \u010f = "Progress";
    private Vector<String> \u0114;
    private int \u010e = 10;

    public ProgressStatusBarItem() {
        this.setLayout(new CardLayout());
        this.add(this.createStatusPanel(), "Status");
        this.add(this.\u0103(), "Progress");
        this.showStatus();
        this.\u0114 = new Vector();
    }

    public void showStatus() {
        ((CardLayout)this.getLayout()).show(this, "Status");
    }

    public void showProgress() {
        ((CardLayout)this.getLayout()).show(this, "Progress");
    }

    private Component \u0103() {
        NullPanel nullPanel = new NullPanel();
        this.\u0118 = null;
        nullPanel.setLayout(new BorderLayout(3, 0));
        this.\u0115 = this.createProgressLabel();
        this.\u0115.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.\u0117 = this.createProgressBar();
        this.\u0112 = this.createCancelButton();
        NullPanel nullPanel2 = new NullPanel(new BorderLayout(0, 0));
        nullPanel2.setBorder(new EmptyBorder(3, 3, 3, 3));
        nullPanel2.add((Component)this.\u0117, "Center");
        NullPanel nullPanel3 = new NullPanel(new BorderLayout(3, 0));
        nullPanel3.add((Component)this.\u0115, "Before");
        nullPanel3.add((Component)nullPanel2, "Center");
        nullPanel.add((Component)nullPanel3, "Center");
        if (this.\u0112 != null) {
            nullPanel.add((Component)this.\u0112, "After");
        }
        this.setCancelCallback(null);
        return nullPanel;
    }

    protected JLabel createProgressLabel() {
        return new NullLabel();
    }

    protected JProgressBar createProgressBar() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setMaximum(100);
        return jProgressBar;
    }

    @Override
    @Deprecated
    public void setPreferredWidth(int n2) {
        super.setPreferredWidth(n2);
    }

    protected AbstractButton createCancelButton() {
        NullButton nullButton = new NullButton(this.getCancelText());
        nullButton.setOpaque(false);
        nullButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        nullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressStatusBarItem.this.getCancelCallback() != null) {
                    ProgressStatusBarItem.this.getCancelCallback().cancelPerformed();
                }
            }
        });
        PortingUtils.removeFocus(nullButton);
        return nullButton;
    }

    protected Component createStatusPanel() {
        this.\u0111 = new NullLabel();
        this.\u0111.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.\u0111.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ProgressStatusBarItem.this._popup != null && ProgressStatusBarItem.this._popup.isVisible()) {
                    ProgressStatusBarItem.this._popup.hidePopup();
                    ProgressStatusBarItem.this._popup = null;
                } else if (ProgressStatusBarItem.this.getMaxNumberOfHistoryItems() != 0 && ProgressStatusBarItem.this.\u0114.size() > 1) {
                    ProgressStatusBarItem.this._popup = JidePopupFactory.getSharedInstance().createPopup();
                    JList jList = new JList(ProgressStatusBarItem.this.\u0114){

                        @Override
                        public Dimension getPreferredScrollableViewportSize() {
                            Dimension dimension = super.getPreferredScrollableViewportSize();
                            dimension.width = ProgressStatusBarItem.this.\u0111.getWidth() - 2;
                            return dimension;
                        }
                    };
                    jList.setBackground(UIDefaultsLookup.getColor("control"));
                    jList.setVisibleRowCount(Math.min(10, ProgressStatusBarItem.this.\u0114.size()));
                    JideScrollPane jideScrollPane = new JideScrollPane(jList);
                    jideScrollPane.setBorder(BorderFactory.createEmptyBorder());
                    JPanel jPanel = new JPanel(new BorderLayout(2, 2));
                    jPanel.add(jideScrollPane);
                    JideButton jideButton = new JideButton(new AbstractAction(A.\u0101(ProgressStatusBarItem.this.getLocale()).getString("StatusBar.clearHistory")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ProgressStatusBarItem.this.clearHistory();
                            ProgressStatusBarItem.this._popup.hidePopupImmediately();
                        }
                    });
                    jideButton.setButtonStyle(3);
                    jPanel.add((Component)JideSwingUtilities.createRightPanel(jideButton), "Last");
                    ProgressStatusBarItem.this._popup.add(jPanel);
                    ProgressStatusBarItem.this._popup.showPopup(ProgressStatusBarItem.this.\u0111);
                }
            }
        });
        return this.\u0111;
    }

    public void setStatus(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusChanged(string);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.statusChanged(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void statusChanged(String string) {
        this.showStatus();
        this.\u0111.setText(string);
        this.\u0111.setToolTipText(string);
        if (string != null && string.trim().length() > 0) {
            this.\u0114.add(0, ObjectConverterManager.toString(Calendar.getInstance(), Calendar.class, DateConverter.DATETIME_CONTEXT) + " " + string);
            if (this.getMaxNumberOfHistoryItems() != -1 && this.\u0114.size() > this.getMaxNumberOfHistoryItems()) {
                this.\u0114.remove(this.\u0114.size() - 1);
            }
        }
    }

    public void clearHistory() {
        if (this.\u0114 != null) {
            this.\u0114.clear();
        }
    }

    public void setStatusIcon(final Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showStatus();
            this.\u0111.setIcon(icon);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showStatus();
                    ProgressStatusBarItem.this.\u0111.setIcon(icon);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setProgressStatus(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showProgress();
            this.\u0115.setText(string);
            this.\u0115.setToolTipText(string);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showProgress();
                    ProgressStatusBarItem.this.\u0115.setText(string);
                    ProgressStatusBarItem.this.\u0115.setToolTipText(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setProgressIcon(final Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showProgress();
            this.\u0115.setIcon(icon);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showProgress();
                    ProgressStatusBarItem.this.\u0115.setIcon(icon);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setProgress(final int n2) {
        if (n2 < 0 || n2 > 100) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.showProgress();
            this.\u0117.setValue(n2);
            this.\u0117.updateUI();
            if (n2 == 100) {
                this.showStatus();
                this.setStatus(this.getDefaultStatus());
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showProgress();
                    ProgressStatusBarItem.this.\u0117.setValue(n2);
                    ProgressStatusBarItem.this.\u0117.updateUI();
                    if (n2 == 100) {
                        ProgressStatusBarItem.this.showStatus();
                        ProgressStatusBarItem.this.setStatus(ProgressStatusBarItem.this.getDefaultStatus());
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setCancelCallback(CancelCallback cancelCallback) {
        if (cancelCallback == null) {
            this.\u0112.setVisible(false);
        } else {
            this.\u0112.setVisible(true);
        }
        this.\u0118 = cancelCallback;
    }

    public CancelCallback getCancelCallback() {
        return this.\u0118;
    }

    public String getDefaultStatus() {
        return this.\u0110 != null ? this.\u0110 : A.\u0101(this.getLocale()).getString("StatusBar.ready");
    }

    public void setDefaultStatus(String string) {
        this.\u0110 = string;
    }

    @Override
    public String getItemName() {
        return "Status";
    }

    public String getCancelText() {
        return this.\u0116 != null ? this.\u0116 : A.\u0101(this.getLocale()).getString("StatusBar.cancel");
    }

    public void setCancelText(String string) {
        this.\u0116 = string;
        if (this.\u0112 != null) {
            this.\u0112.setText(this.\u0116);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, super.getPreferredSize().height);
    }

    public void setIndeterminate(boolean bl) {
        this.\u0117.setIndeterminate(bl);
    }

    public void setProgressBarWidth(int n2) {
        this.\u0117.setMaximumSize(new Dimension(n2, this.\u0117.getPreferredSize().height));
    }

    public JProgressBar getProgressBar() {
        return this.\u0117;
    }

    public AbstractButton getCancelButton() {
        return this.\u0112;
    }

    public JLabel getProgressLabel() {
        return this.\u0115;
    }

    public JLabel getStatusLabel() {
        return this.\u0111;
    }

    public int getMaxNumberOfHistoryItems() {
        return this.\u010e;
    }

    public void setMaxNumberOfHistoryItems(int n2) {
        this.\u010e = n2;
    }

    public static interface CancelCallback {
        public void cancelPerformed();
    }
}

