/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.shortcut.Shortcut;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

public class MouseShortcut
extends Shortcut {
    private int \u0107 = -1;
    private int \u0106 = -1;
    private int \u0105 = -1;

    public MouseShortcut() {
    }

    public MouseShortcut(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public MouseShortcut(MouseEvent mouseEvent) {
        this(mouseEvent.getButton(), mouseEvent.getClickCount(), mouseEvent.getModifiersEx(), null);
    }

    public MouseShortcut(int n2, int n3, int n4, String string) {
        this.setButton(n2);
        this.setClickCount(n3);
        this.setModifiers(n4);
        this.setContext(string);
    }

    public int getClickCount() {
        return this.\u0107;
    }

    public void setClickCount(int n2) {
        this.\u0107 = n2;
    }

    public int getButton() {
        return this.\u0106;
    }

    public void setButton(int n2) {
        this.\u0106 = n2;
    }

    public int getModifiers() {
        return this.\u0105;
    }

    public void setModifiers(int n2) {
        this.\u0105 = n2;
    }

    public String toString() {
        if (this.\u0101()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MouseEvent.getModifiersExText(this.getModifiers()));
        if (stringBuffer.length() != 0) {
            stringBuffer.append("+");
        }
        stringBuffer.append("Button").append(this.getButton()).append(this.getClickCount() == 1 ? " Click" : " Double-Click");
        if (this.getContext() != null) {
            stringBuffer.append(" (").append(this.getContext()).append(")");
        }
        return stringBuffer.toString();
    }

    public static MouseShortcut parse(String string) {
        MouseShortcut mouseShortcut = new MouseShortcut();
        if (string.indexOf("button1") != -1) {
            mouseShortcut.setButton(1);
        } else if (string.indexOf("button2") != -1) {
            mouseShortcut.setButton(2);
        } else if (string.indexOf("button3") != -1) {
            mouseShortcut.setButton(3);
        }
        if (string.indexOf("click") != -1) {
            mouseShortcut.setClickCount(1);
        } else if (string.indexOf("doubleClick") != -1) {
            mouseShortcut.setClickCount(2);
        }
        int n2 = 0;
        if (string.indexOf("control") != -1) {
            n2 |= 0x80;
        }
        if (string.indexOf("alt graph") != -1) {
            n2 |= 0x2000;
        }
        if (string.indexOf("alt") != -1) {
            n2 |= 0x200;
        }
        if (string.indexOf("shift") != -1) {
            n2 |= 0x40;
        }
        if (string.indexOf("meta") != -1) {
            n2 |= 0x100;
        }
        mouseShortcut.setModifiers(n2);
        return mouseShortcut;
    }

    public static String getMouseShortcutString(MouseShortcut mouseShortcut) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MouseShortcut.getModifiersExText(mouseShortcut.getModifiers()).toLowerCase());
        if (stringBuffer.length() != 0) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("button").append(mouseShortcut.getButton()).append(mouseShortcut.getClickCount() == 1 ? " click" : " doubleClick");
        return new String(stringBuffer);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MouseShortcut)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MouseShortcut mouseShortcut = (MouseShortcut)object;
        return this.\u0106 == mouseShortcut.\u0106 && this.\u0107 == mouseShortcut.\u0107 && this.\u0105 == mouseShortcut.\u0105;
    }

    @Override
    public int hashCode() {
        int n2 = this.\u0107;
        n2 = 29 * n2 + this.\u0106;
        n2 = 29 * n2 + this.\u0105;
        return n2;
    }

    @Override
    boolean \u0101() {
        return this.\u0106 == -1 && this.\u0107 == 1 && this.\u0105 == -1;
    }

    public static String getModifiersExText(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 0x100) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.meta", "meta"));
            stringBuffer.append(" ");
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.control", "control"));
            stringBuffer.append(" ");
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.alt", "alt"));
            stringBuffer.append(" ");
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.shift", "shift"));
            stringBuffer.append(" ");
        }
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.altGraph", "alt graph"));
            stringBuffer.append(" ");
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.button1", "button1"));
            stringBuffer.append("+");
        }
        if ((n2 & 0x800) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.button2", "button2"));
            stringBuffer.append(" ");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.button3", "button3"));
            stringBuffer.append(" ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

