/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

public class LongRange
extends AbstractNumericRange<Long> {
    protected long _min;
    protected long _max;

    public LongRange() {
        this(0L, 1L);
    }

    public LongRange(long l2, long l3) {
        this._min = Math.min(l2, l3);
        this._max = Math.max(l2, l3);
    }

    public LongRange(LongRange longRange) {
        this((long)longRange.minimum(), (long)longRange.maximum());
    }

    @Override
    public Range<Long> copy() {
        return new LongRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public long getMin() {
        return this._min;
    }

    public void setMin(long l2) {
        long l3 = this._min;
        if (l3 == l2) {
            return;
        }
        assert (l2 <= this._max) : "minimum " + l2 + " not <= " + this._max;
        this._min = l2;
        this.firePropertyChange("min", l3, l2);
    }

    public long getMax() {
        return this._max;
    }

    public void setMax(long l2) {
        long l3 = this._max;
        if (l3 == l2) {
            return;
        }
        assert (l2 >= this._min) : "maximum " + l2 + " not >= " + this._min;
        this._max = l2;
        this.firePropertyChange("max", l3, l2);
    }

    @Override
    public void adjust(Long l2, Long l3) {
        double d2 = this.size();
        if (l2 != null) {
            this.setMin(l2);
        } else if (l3 != null) {
            this.setMin(l3 - (long)d2);
        }
        if (l3 != null) {
            this.setMax(l3);
        } else if (l2 != null) {
            this.setMin(l2 + (long)d2);
        }
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Long lower() {
        return (long)this.minimum();
    }

    @Override
    public Long upper() {
        return (long)this.maximum();
    }

    @Override
    public boolean contains(Long l2) {
        return l2 >= this._min && l2 <= this._max;
    }

    @Override
    public Range<Long> createIntermediate(Range<Long> range, double d2) {
        double d3 = this.minimum();
        double d4 = this.maximum();
        double d5 = range.minimum();
        double d6 = range.maximum();
        double d7 = d3 + d2 * (d5 - d3);
        double d8 = d4 + d2 * (d6 - d4);
        return new LongRange((int)Math.round(d7), (int)Math.round(d8));
    }

    public boolean equals(Object object) {
        if (object instanceof LongRange) {
            LongRange longRange = (LongRange)object;
            return this._min == longRange._min && this._max == longRange._max;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this._max * 29L + this._min);
    }

    public String toString() {
        return String.format("#<LongRange min=%d max=%d>", this._min, this._max);
    }
}

