/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.grid.JideTable;
import com.jidesoft.plaf.TableUIDelegate;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicJideTableUIDelegate
implements TableUIDelegate {
    protected JTable table;
    protected CellRendererPane rendererPane;

    public BasicJideTableUIDelegate(JTable jTable, CellRendererPane cellRendererPane) {
        this.table = jTable;
        this.rendererPane = cellRendererPane;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            this.\u0102(graphics);
            return;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        if (!bl) {
            ++point.x;
        }
        Point point2 = new Point(rectangle.x + rectangle.width - (bl ? 1 : 0), rectangle.y + rectangle.height);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.rowAtPoint(point2);
        boolean bl2 = false;
        if (n2 == -1) {
            n2 = 0;
            bl2 = true;
        }
        if (n3 == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        if (bl2 && !SystemInfo.isJdk6Above() && n3 == this.table.getRowCount() - 1) {
            Dimension dimension = PortingUtils.getLocalScreenSize(this.table);
            if (rectangle.y > dimension.height) {
                n2 = n3 - this.table.getVisibleRect().height / this.table.getRowHeight() - 1;
            }
        }
        int n4 = this.table.columnAtPoint(bl ? point : point2);
        int n5 = this.table.columnAtPoint(bl ? point2 : point);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n2, n3, n4, n5);
        if (!(this.table instanceof JideTable) || ((JideTable)this.table).isCellContentVisible()) {
            this.\u0101(graphics, n2, n3, n4, n5);
        }
        this.\u0102(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void \u0102(Graphics graphics) {
        Class clazz;
        if (SystemInfo.isJdk6Above() && (clazz = this.table.getDropLocation()) == null) {
            return;
        }
        for (clazz = this.table.getUI().getClass(); clazz != BasicTableUI.class && clazz != null; clazz = clazz.getSuperclass()) {
        }
        if (clazz != null) {
            Color color = null;
            if (this.table.getSelectedColumn() < 0) {
                color = UIManager.getColor("Table.dropLineShortColor");
            }
            try {
                if (this.table.getSelectedColumn() < 0) {
                    UIManager.getDefaults().put("Table.dropLineShortColor", UIManager.getColor("Table.dropLineColor"));
                }
                this.\u0101(graphics);
            }
            catch (Exception exception) {
            }
            finally {
                if (color != null) {
                    UIManager.getDefaults().put("Table.dropLineShortColor", color);
                }
            }
        }
    }

    private Rectangle \u0102(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n2 = dropLocation.getRow();
        int n3 = dropLocation.getColumn();
        if (n3 >= this.table.getColumnCount()) {
            --n3;
        }
        Rectangle rectangle = this.table.getCellRect(n2, n3, true);
        if (n2 >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n2, n3, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle \u0101(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n2 = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n2, true);
        if (n2 >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n2, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle \u0101(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    private void \u0101(Graphics graphics) {
        int n2;
        int n3;
        JTable.DropLocation dropLocation = this.table.getDropLocation();
        if (dropLocation == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color color2 = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.\u0102(dropLocation);
        if (rectangle != null) {
            n3 = rectangle.x;
            n2 = rectangle.width;
            if (color != null) {
                this.\u0101(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertColumn() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(n3, rectangle.y, n2, rectangle.height);
            }
        }
        if ((rectangle = this.\u0101(dropLocation)) != null) {
            n3 = rectangle.y;
            n2 = rectangle.height;
            if (color != null) {
                this.\u0101(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertRow() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, n3, rectangle.width, n2);
            }
        }
    }

    public void paintGrid(Graphics graphics, int n2, int n3, int n4, int n5) {
        block15: {
            int n6;
            int n7;
            Rectangle rectangle = this.table.getCellRect(n2, n4, true);
            Rectangle rectangle2 = this.table.getCellRect(n3, n5, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            int n8 = -1;
            int n9 = rectangle3.y;
            if (this.table.getShowHorizontalLines()) {
                n7 = rectangle3.x + rectangle3.width;
                for (n6 = n2; n6 <= n3; ++n6) {
                    Color color;
                    Color color2 = color = this.table instanceof JideTable ? ((JideTable)this.table).getGridColor(n6) : null;
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.table.getGridColor());
                    }
                    graphics.drawLine(rectangle3.x, (n9 += this.table.getRowHeight(n6)) - 1, n7 - 1, n9 - 1);
                    if (n6 != n3) continue;
                    n8 = n9 - 1 - rectangle3.y;
                }
            } else if (this.table instanceof JideTable && ((JideTable)this.table).isRowAutoResizes()) {
                for (n7 = n2; n7 <= n3; ++n7) {
                    n9 += this.table.getRowHeight(n7);
                    if (n7 != n3) continue;
                    n8 = n9 - 1 - rectangle3.y;
                }
            }
            graphics.setColor(this.table.getGridColor());
            if (!this.table.getShowVerticalLines()) break block15;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = Math.max(rectangle3.y + rectangle3.height, n8);
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int n10 = rectangle3.x;
                for (int i2 = n4; i2 <= n5; ++i2) {
                    Color color;
                    Color color3 = color = this.table instanceof JideTable ? ((JideTable)this.table).getVerticalGridColor(i2) : null;
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.table.getGridColor());
                    }
                    int n11 = tableColumnModel.getColumn(i2).getWidth();
                    graphics.drawLine((n10 += n11) - 1, 0, n10 - 1, n6 - 1);
                }
            } else {
                int n12 = rectangle3.x;
                graphics.drawLine(n12, 0, n12, n6 - 1);
                for (int i3 = n5; i3 >= n4; --i3) {
                    Color color;
                    Color color4 = color = this.table instanceof JideTable ? ((JideTable)this.table).getVerticalGridColor(i3) : null;
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.table.getGridColor());
                    }
                    int n13 = tableColumnModel.getColumn(i3).getWidth();
                    graphics.drawLine((n12 += n13) - 1, 0, n12 - 1, n6 - 1);
                }
            }
        }
    }

    protected int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private void \u0101(Graphics graphics, int n2, int n3, int n4, int n5) {
        boolean bl;
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnMargin();
        boolean bl2 = bl = this.table instanceof JideTable && ((JideTable)this.table).alwaysCalculateCellRect();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                Rectangle rectangle = this.table.getCellRect(i2, n4, false);
                for (int i3 = n4; i3 <= n5; ++i3) {
                    Rectangle rectangle2 = null;
                    if (this.table.isEditing() && this.table.getEditingRow() == i2 && this.table.getEditingColumn() == i3) {
                        rectangle2 = ((JideTable)this.table).getEditorCellRect(i2, i3);
                    }
                    TableColumn tableColumn2 = tableColumnModel.getColumn(i3);
                    int n7 = tableColumn2.getWidth();
                    rectangle.width = n7 - n6;
                    if (tableColumn2 != tableColumn && rectangle.width > 0) {
                        if (bl && rectangle2 != null) {
                            this.adjustCellEditor(graphics, rectangle2, i2, i3);
                        }
                        this.paintCell(graphics, rectangle, i2, i3);
                    }
                    rectangle.x += n7;
                }
            }
        } else {
            for (int i4 = n2; i4 <= n3; ++i4) {
                Rectangle rectangle = this.table.getCellRect(i4, n4, false);
                for (int i5 = n4; i5 <= n5; ++i5) {
                    Rectangle rectangle3 = null;
                    if (this.table.isEditing() && this.table.getEditingRow() == i4 && this.table.getEditingColumn() == i5) {
                        rectangle3 = ((JideTable)this.table).getEditorCellRect(i4, i5);
                    }
                    TableColumn tableColumn3 = tableColumnModel.getColumn(i5);
                    int n8 = tableColumn3.getWidth();
                    if (i5 != n4) {
                        rectangle.x -= n8;
                    }
                    rectangle.width = n8 - n6;
                    if (tableColumn3 == tableColumn || rectangle.width <= 0) continue;
                    if (bl && rectangle3 != null) {
                        this.adjustCellEditor(graphics, rectangle3, i4, i5);
                    }
                    this.paintCell(graphics, rectangle, i4, i5);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n2, n3, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    public void paintDraggedArea(Graphics graphics, int n2, int n3, TableColumn tableColumn, int n4) {
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        if (n6 < 0) {
            return;
        }
        Rectangle rectangle = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n4;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            int n9 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n9);
            graphics.drawLine(n8, n7, n8, n9);
        }
        for (n5 = n2; n5 <= n3; ++n5) {
            Color color;
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n4;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            Color color2 = color = this.table instanceof JideTable ? ((JideTable)this.table).getGridColor(n5) : null;
            if (color != null) {
                graphics.setColor(color);
            } else {
                graphics.setColor(this.table.getGridColor());
            }
            Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
            rectangle5.x += n4;
            int n10 = rectangle5.x;
            int n11 = rectangle5.y;
            int n12 = n10 + rectangle5.width - 1;
            int n13 = n11 + rectangle5.height - 1;
            graphics.drawLine(n10, n13, n12, n13);
        }
    }

    public void paintCell(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Graphics graphics2;
        Object object;
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            object = ((JideTable)this.table).getEditorCellRect(n2, n3);
            if (rectangle != null && rectangle.equals(object)) {
                return;
            }
        }
        if (rectangle == null) {
            return;
        }
        object = this.table.getCellRenderer(n2, n3);
        if (object == null) {
            return;
        }
        Component component = this.table.prepareRenderer((TableCellRenderer)object, n2, n3);
        if (component != null) {
            component.setComponentOrientation(this.table.getComponentOrientation());
        }
        if (this.table instanceof JideTable) {
            graphics2 = graphics.create();
            ((JideTable)this.table).paintCellUnderlay(graphics2, component, n2, n3, rectangle);
            graphics2.dispose();
        }
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (component != null) {
            this.rendererPane.remove(component);
        }
        if (this.table instanceof JideTable) {
            graphics2 = graphics.create();
            ((JideTable)this.table).paintCellOverlay(graphics2, component, n2, n3, rectangle);
            graphics2.dispose();
        }
        if (this.table instanceof JideTable) {
            ((JideTable)this.table).releaseRendererComponent((TableCellRenderer)object, n2, n3, component);
        }
    }

    protected void adjustCellEditor(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }
}

