/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.plaf.CollapsiblePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicCollapsiblePaneTitlePane;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicCollapsiblePaneUI
extends CollapsiblePaneUI {
    protected CollapsiblePane _pane;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _collapsiblePaneLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected JComponent _titlePane;
    private boolean \u0105 = false;
    private boolean \u0101 = false;
    private ThemePainter \u0103;
    private AnimatorListener \u0102;
    private AnimatorListener \u0104;
    protected Action _collapseAction;
    protected String _collapseText;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicCollapsiblePaneUI((CollapsiblePane)jComponent);
    }

    public BasicCollapsiblePaneUI() {
    }

    public BasicCollapsiblePaneUI(CollapsiblePane collapsiblePane) {
        this._pane = collapsiblePane;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._pane = (CollapsiblePane)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this._pane) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this._pane + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._pane = null;
    }

    protected void installDefaults() {
        this.\u0103 = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._collapsiblePaneLayout = this.createLayoutManager();
        this._pane.setLayout(this._collapsiblePaneLayout);
        LookAndFeel.installBorder(this._pane, "CollapsiblePane.border");
        if (this._pane.isEmphasized()) {
            LookAndFeel.installColors(this._pane, "CollapsiblePane.emphasizedBackground", "CollapsiblePane.emphasizedForeground");
        } else {
            LookAndFeel.installColors(this._pane, "CollapsiblePane.background", "CollapsiblePane.foreground");
        }
        this._collapseText = Resource.getResourceBundle(Locale.getDefault()).getString("CollapsiblePane.collapseText");
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this._pane.getStyle() != 2 && this._pane.getStyle() != 3 && this._pane.isContentAreaFilled()) {
            Rectangle rectangle = this._pane.getActualComponent().getBounds();
            graphics.setColor(this.getPainter().getCollapsiblePaneContentBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this._pane.getBackground());
            if (this._pane.getSlidingDirection() == 1 || this._pane.getSlidingDirection() == 5) {
                graphics.drawRect(rectangle.x - 1, rectangle.y, rectangle.width + 1, rectangle.height);
            } else {
                graphics.drawRect(rectangle.x, rectangle.y - 1, rectangle.width, rectangle.height + 1);
            }
        }
    }

    protected void uninstallDefaults() {
        Icon icon = this._pane.getIcon();
        if (icon instanceof UIResource) {
            this._pane.setIcon(null);
        }
        this._collapsiblePaneLayout = null;
        this._pane.setLayout(null);
        LookAndFeel.uninstallBorder(this._pane);
        LookAndFeel.uninstallBorder(this._pane.getContentPane());
        this.\u0103 = null;
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.\u0103();
        SwingUtilities.replaceUIActionMap(this._pane, actionMap);
    }

    ActionMap \u0103() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("CollapsiblePane.actionMap");
        if (actionMap == null && (actionMap = this.\u0101()) != null) {
            UIManager.getLookAndFeelDefaults().put("CollapsiblePane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap \u0101() {
        return new ActionMapUIResource();
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._pane));
        this.setSouthPane(this.createSouthPane(this._pane));
        this.setEastPane(this.createEastPane(this._pane));
        this.setWestPane(this.createWestPane(this._pane));
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._pane.addPropertyChangeListener(this._propertyChangeListener);
        this._collapseAction = new CollapseAction();
        this.\u0102();
    }

    protected void uninstallListeners() {
        this._pane.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
        if (this._collapseAction instanceof CollapseAction && ((CollapseAction)this._collapseAction).\u0102 != null) {
            ((CollapseAction)this._collapseAction).\u0102.removeAnimatorListener(this.\u0104);
        }
        this._collapseAction = null;
        this.\u0102 = null;
        this.\u0104 = null;
    }

    InputMap \u0102(int n2) {
        if (n2 == 2) {
            return this.\u0103(n2);
        }
        return null;
    }

    InputMap \u0103(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIDefaultsLookup.get("CollapsiblePane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._pane, objectArray);
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._pane, 2, null);
        SwingUtilities.replaceUIActionMap(this._pane, null);
    }

    @Override
    public Component getTitlePane() {
        switch (this._pane.getSlidingDirection()) {
            case 7: {
                return this._eastPane;
            }
            case 3: {
                return this._westPane;
            }
            case 1: {
                return this._southPane;
            }
        }
        return this._northPane;
    }

    protected LayoutManager createLayoutManager() {
        return new CollapsiblePaneLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new CollapsiblePanePropertyChangeListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._pane == jComponent) {
            return this._pane.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this._pane == jComponent) {
            return this._pane.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this._pane.remove(jComponent);
        }
        if (jComponent2 != null) {
            this._pane.add(jComponent2);
        }
    }

    protected JComponent createNorthPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 5) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createTitlePane(CollapsiblePane collapsiblePane) {
        BasicCollapsiblePaneTitlePane basicCollapsiblePaneTitlePane = new BasicCollapsiblePaneTitlePane(collapsiblePane);
        basicCollapsiblePaneTitlePane.setFont(collapsiblePane.getFont());
        return basicCollapsiblePaneTitlePane;
    }

    protected JComponent createSouthPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 1) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createWestPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 3) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createEastPane(CollapsiblePane collapsiblePane) {
        if (collapsiblePane.isShowTitleBar() && collapsiblePane.getSlidingDirection() == 7) {
            this._titlePane = this.createTitlePane(collapsiblePane);
            return this._titlePane;
        }
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.\u0105;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
        this.\u0105 = bl;
    }

    public final boolean isKeyBindingActive() {
        return this.\u0101;
    }

    protected final void setKeyBindingActive(boolean bl) {
        this.\u0101 = bl;
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.\u0102(2);
        SwingUtilities.replaceUIInputMap(this._pane, 2, inputMap);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent jComponent) {
        if (this._northPane != null && this._northPane instanceof BasicCollapsiblePaneTitlePane) {
            ((BasicCollapsiblePaneTitlePane)this._northPane).uninstallDefaults();
            ((BasicCollapsiblePaneTitlePane)this._northPane).uninstallListeners();
        }
        this.replacePane(this._northPane, jComponent);
        this._northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent jComponent) {
        if (this._southPane != null && this._southPane instanceof BasicCollapsiblePaneTitlePane) {
            ((BasicCollapsiblePaneTitlePane)this._southPane).uninstallDefaults();
            ((BasicCollapsiblePaneTitlePane)this._southPane).uninstallListeners();
        }
        this.replacePane(this._southPane, jComponent);
        this._southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent jComponent) {
        if (this._westPane != null && this._westPane instanceof BasicCollapsiblePaneTitlePane) {
            ((BasicCollapsiblePaneTitlePane)this._westPane).uninstallDefaults();
            ((BasicCollapsiblePaneTitlePane)this._westPane).uninstallListeners();
        }
        this.replacePane(this._westPane, jComponent);
        this._westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent jComponent) {
        if (this._eastPane != null && this._eastPane instanceof BasicCollapsiblePaneTitlePane) {
            ((BasicCollapsiblePaneTitlePane)this._eastPane).uninstallDefaults();
            ((BasicCollapsiblePaneTitlePane)this._eastPane).uninstallListeners();
        }
        this.replacePane(this._eastPane, jComponent);
        this._eastPane = jComponent;
    }

    private int \u0104() {
        Object object;
        if (this._pane != null && (object = this._pane.getClientProperty("percentageVisible")) != null && object instanceof Integer) {
            return (Integer)object;
        }
        return 100;
    }

    public ThemePainter getPainter() {
        return this.\u0103;
    }

    private void \u0102() {
        this.\u0104 = new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
                BasicCollapsiblePaneUI.this.\u0101(100);
                BasicCollapsiblePaneUI.this._pane.fireCollapsiblePaneEvent(6101);
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                BasicCollapsiblePaneUI.this.\u0101((int)(100.0 * (1.0 - BasicCollapsiblePaneUI.this._pane.getAnimationFunction().calculate(n3, n2))));
                BasicCollapsiblePaneUI.this._pane.invalidate();
                if (BasicCollapsiblePaneUI.this._pane.getParent() != null) {
                    BasicCollapsiblePaneUI.this._pane.getParent().validate();
                    BasicCollapsiblePaneUI.this._pane.getParent().repaint(BasicCollapsiblePaneUI.this._pane.getStepDelay() * BasicCollapsiblePaneUI.this._pane.getSteps());
                }
                if (BasicCollapsiblePaneUI.this._pane.getActualComponent() instanceof JScrollPane) {
                    ((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().setValue(((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().getMaximum());
                }
            }

            @Override
            public void animationEnds(Component component) {
                try {
                    BasicCollapsiblePaneUI.this.\u0101(BasicCollapsiblePaneUI.this._pane.getCollapsedPercentage());
                    BasicCollapsiblePaneUI.this._pane.setCollapsed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
        this.\u0102 = new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
                BasicCollapsiblePaneUI.this.\u0101(BasicCollapsiblePaneUI.this._pane.getCollapsedPercentage());
                BasicCollapsiblePaneUI.this._pane.fireCollapsiblePaneEvent(6099);
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                BasicCollapsiblePaneUI.this.\u0101(BasicCollapsiblePaneUI.this._pane.getCollapsedPercentage() + (int)(100.0 * BasicCollapsiblePaneUI.this._pane.getAnimationFunction().calculate(n3, n2)));
                BasicCollapsiblePaneUI.this._pane.invalidate();
                if (BasicCollapsiblePaneUI.this._pane.getParent() != null) {
                    BasicCollapsiblePaneUI.this._pane.getParent().validate();
                    BasicCollapsiblePaneUI.this._pane.getParent().repaint(BasicCollapsiblePaneUI.this._pane.getStepDelay() * BasicCollapsiblePaneUI.this._pane.getSteps());
                }
                if (BasicCollapsiblePaneUI.this._pane.getActualComponent() instanceof JScrollPane) {
                    ((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().setValue(((JScrollPane)BasicCollapsiblePaneUI.this._pane.getActualComponent()).getVerticalScrollBar().getMaximum());
                }
            }

            @Override
            public void animationEnds(Component component) {
                try {
                    BasicCollapsiblePaneUI.this.\u0101(100);
                    BasicCollapsiblePaneUI.this._pane.setCollapsed(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        };
    }

    private void \u0101(int n2) {
        this._pane.putClientProperty("percentageVisible", n2);
    }

    @Override
    public Action getToggleAction() {
        return this._collapseAction;
    }

    public class CollapseAction
    extends AbstractAction {
        Rectangle \u0103;
        Animator \u0102;

        public CollapseAction() {
            super(BasicCollapsiblePaneUI.this._collapseText);
            this.\u0103 = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicCollapsiblePaneUI.this._pane.isCollapsible()) {
                if (!BasicCollapsiblePaneUI.this._pane.isCollapsed()) {
                    if (this.\u0102 != null && this.\u0102.isRunning()) {
                        this.\u0102.interrupt();
                    }
                    this.\u0102 = new Animator(BasicCollapsiblePaneUI.this._pane, BasicCollapsiblePaneUI.this._pane.getInitDelay(), BasicCollapsiblePaneUI.this._pane.getStepDelay(), BasicCollapsiblePaneUI.this._pane.getSteps());
                    this.\u0102.addAnimatorListener(BasicCollapsiblePaneUI.this.\u0104);
                    this.\u0102.start();
                } else {
                    if (this.\u0102 != null && this.\u0102.isRunning()) {
                        this.\u0102.interrupt();
                    }
                    this.\u0102 = new Animator(BasicCollapsiblePaneUI.this._pane, BasicCollapsiblePaneUI.this._pane.getInitDelay(), BasicCollapsiblePaneUI.this._pane.getStepDelay(), BasicCollapsiblePaneUI.this._pane.getSteps());
                    this.\u0102.addAnimatorListener(BasicCollapsiblePaneUI.this.\u0102);
                    this.\u0102.start();
                }
            }
        }
    }

    public class CollapsiblePaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = new Dimension();
            int n2 = BasicCollapsiblePaneUI.this.\u0104();
            if (BasicCollapsiblePaneUI.this._pane.getSlidingDirection() == 1 || BasicCollapsiblePaneUI.this._pane.getSlidingDirection() == 5) {
                dimension.height = BasicCollapsiblePaneUI.this._pane.getContentPaneHeight() * n2 / 100 + (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 1 : 0);
                dimension.width = BasicCollapsiblePaneUI.this._pane.getContentPane().getPreferredSize().width + (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 2 : 0);
            } else {
                dimension.height = BasicCollapsiblePaneUI.this._pane.getContentPane().getPreferredSize().height + (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 2 : 0);
                dimension.width = BasicCollapsiblePaneUI.this._pane.getContentPaneWidth() * n2 / 100 + (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 1 : 0);
            }
            if ((!(BasicCollapsiblePaneUI.this.getNorthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getNorthPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getNorthPane().getPreferredSize();
                dimension.height += cloneable.height;
                dimension.width = Math.max(cloneable.width, dimension.width);
            }
            if ((!(BasicCollapsiblePaneUI.this.getSouthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getSouthPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getSouthPane().getPreferredSize();
                dimension.height += cloneable.height;
                dimension.width = Math.max(cloneable.width, dimension.width);
            }
            if ((!(BasicCollapsiblePaneUI.this.getEastPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getEastPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getEastPane().getPreferredSize();
                dimension.height = Math.max(cloneable.height, dimension.height);
                dimension.width += cloneable.width;
            }
            if ((!(BasicCollapsiblePaneUI.this.getWestPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getWestPane() != null) {
                cloneable = BasicCollapsiblePaneUI.this.getWestPane().getPreferredSize();
                dimension.height = Math.max(cloneable.height, dimension.height);
                dimension.width += cloneable.width;
            }
            cloneable = BasicCollapsiblePaneUI.this._pane.getInsets();
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if ((!(BasicCollapsiblePaneUI.this.getNorthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getNorthPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getNorthPane().getMinimumSize());
                dimension.width = Math.max(dimension.width, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().width);
            } else if ((!(BasicCollapsiblePaneUI.this.getSouthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getSouthPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getSouthPane().getMinimumSize());
                dimension.width = Math.max(dimension.width, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().width);
            } else if ((!(BasicCollapsiblePaneUI.this.getEastPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getEastPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getEastPane().getMinimumSize());
                dimension.height = Math.max(dimension.height, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().height);
            } else if ((!(BasicCollapsiblePaneUI.this.getWestPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) && BasicCollapsiblePaneUI.this.getWestPane() != null) {
                dimension = new Dimension(BasicCollapsiblePaneUI.this.getWestPane().getMinimumSize());
                dimension.height = Math.max(dimension.height, BasicCollapsiblePaneUI.this._pane.getContentPane().getMinimumSize().height);
            }
            Insets insets = BasicCollapsiblePaneUI.this._pane.getInsets();
            dimension.width = 0;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = BasicCollapsiblePaneUI.this._pane.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = BasicCollapsiblePaneUI.this._pane.getWidth() - insets.left - insets.right;
            int n5 = BasicCollapsiblePaneUI.this._pane.getHeight() - insets.top - insets.bottom;
            if (BasicCollapsiblePaneUI.this.getNorthPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getNorthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getNorthPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getNorthPane().setBounds(n2, n3, n4, dimension.height);
                    n3 += dimension.height;
                    n5 -= dimension.height;
                } else {
                    BasicCollapsiblePaneUI.this.getNorthPane().setBounds(0, 0, 0, 0);
                }
            } else if (BasicCollapsiblePaneUI.this.getWestPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getWestPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getWestPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getWestPane().setBounds(n2, n3, dimension.width, n5);
                    n4 -= dimension.width;
                    n2 += dimension.width;
                } else {
                    BasicCollapsiblePaneUI.this.getWestPane().setBounds(0, 0, 0, 0);
                }
            }
            if (BasicCollapsiblePaneUI.this.getSouthPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getSouthPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getSouthPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getSouthPane().setBounds(n2, BasicCollapsiblePaneUI.this._pane.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                    n5 -= dimension.height;
                } else {
                    BasicCollapsiblePaneUI.this.getSouthPane().setBounds(0, 0, 0, 0);
                }
            } else if (BasicCollapsiblePaneUI.this.getEastPane() != null) {
                if (!(BasicCollapsiblePaneUI.this.getEastPane() instanceof BasicCollapsiblePaneTitlePane) || BasicCollapsiblePaneUI.this._pane.isShowTitleBar()) {
                    dimension = BasicCollapsiblePaneUI.this.getEastPane().getPreferredSize();
                    BasicCollapsiblePaneUI.this.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                    n4 -= dimension.width;
                } else {
                    BasicCollapsiblePaneUI.this.getEastPane().setBounds(0, 0, 0, 0);
                }
            }
            if (BasicCollapsiblePaneUI.this._pane.getActualComponent() != null) {
                switch (BasicCollapsiblePaneUI.this._pane.getSlidingDirection()) {
                    case 3: 
                    case 7: {
                        int n6 = BasicCollapsiblePaneUI.this.\u0104() != 100 ? Math.min(n4, BasicCollapsiblePaneUI.this._pane.getContentPaneWidth() * BasicCollapsiblePaneUI.this.\u0104() / 100) : n4;
                        BasicCollapsiblePaneUI.this._pane.getActualComponent().setBounds(n2, n3 + (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 1 : 0), n6 - (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 1 : 0), n5 - (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 2 : 0));
                        n2 += n6;
                        break;
                    }
                    default: {
                        int n7 = BasicCollapsiblePaneUI.this.\u0104() != 100 ? Math.min(n5, BasicCollapsiblePaneUI.this._pane.getContentPaneHeight() * BasicCollapsiblePaneUI.this.\u0104() / 100) : n5;
                        BasicCollapsiblePaneUI.this._pane.getActualComponent().setBounds(n2 + (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 1 : 0), n3, n4 - (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 2 : 0), n7 - (BasicCollapsiblePaneUI.this._pane.isContentBorderVisible() ? 1 : 0));
                        n3 += n7;
                    }
                }
            }
        }
    }

    public class CollapsiblePanePropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("collapsed".equals(string)) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCollapsiblePaneUI.this.\u0101(BasicCollapsiblePaneUI.this._pane.getCollapsedPercentage());
                } else {
                    BasicCollapsiblePaneUI.this.\u0101(100);
                }
            } else if ("enabled".equals(string)) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCollapsiblePaneUI.this._collapseAction.setEnabled(true);
                } else {
                    BasicCollapsiblePaneUI.this._collapseAction.setEnabled(false);
                }
            } else if (!"contentPane".equals(string)) {
                if ("showTitleBar".equals(string)) {
                    BasicCollapsiblePaneUI.this._pane.invalidate();
                    BasicCollapsiblePaneUI.this._pane.updateUI();
                } else if ("emphasized".equals(string)) {
                    if (BasicCollapsiblePaneUI.this._pane.isEmphasized()) {
                        LookAndFeel.installColors(BasicCollapsiblePaneUI.this._pane, "CollapsiblePane.emphasizedBackground", "CollapsiblePane.emphasizedForeground");
                    } else {
                        LookAndFeel.installColors(BasicCollapsiblePaneUI.this._pane, "CollapsiblePane.background", "CollapsiblePane.foreground");
                    }
                } else if ("style".equals(string)) {
                    BasicCollapsiblePaneUI.this._pane.updateUI();
                } else if ("slidingDirection".equals(string)) {
                    BasicCollapsiblePaneUI.this._pane.updateUI();
                } else if ("title".equals(string)) {
                    Dimension dimension = BasicCollapsiblePaneUI.this._pane.getMinimumSize();
                    Dimension dimension2 = BasicCollapsiblePaneUI.this._pane.getSize();
                    if (dimension.width > dimension2.width) {
                        BasicCollapsiblePaneUI.this._pane.setSize(dimension.width, dimension2.height);
                    }
                }
            }
        }
    }
}

