/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.filter.Filter;
import com.jidesoft.filter.InFilter;
import com.jidesoft.filter.NotInFilter;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.pivot.PivotDataSource;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableModelPivotDataSource
implements PivotDataSource {
    private static final String \u0101 = "NULL_VALUE";
    protected TableModel _originalTableModel;
    protected IFilterableTableModel _filterTableModel;
    protected IFilterableTableModel _tableModel;

    public TableModelPivotDataSource(TableModel tableModel) {
        this.setTableModel(tableModel);
    }

    public void setTableModel(TableModel tableModel) {
        this._originalTableModel = tableModel;
        this._filterTableModel = this.createFilterableTableModel(this._originalTableModel);
        this._tableModel = this.createFilterableTableModel(this._filterTableModel);
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return new FilterableTableModel(tableModel);
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public int getFieldCount() {
        return this._originalTableModel.getColumnCount();
    }

    @Override
    public String getFieldName(int n2) {
        if (this._originalTableModel instanceof ColumnIdentifierTableModel) {
            return ((ColumnIdentifierTableModel)((Object)this._originalTableModel)).getColumnIdentifier(n2).toString();
        }
        return this._originalTableModel.getColumnName(n2);
    }

    @Override
    public String getFieldTitle(int n2) {
        return this._originalTableModel.getColumnName(n2);
    }

    @Override
    public Class<?> getFieldType(int n2) {
        return this._originalTableModel.getColumnClass(n2);
    }

    @Override
    public int getRowCount() {
        return this._tableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this._tableModel.getValueAt(n2, n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this._tableModel.setValueAt(object, n2, n3);
    }

    protected void updatePossibleValues(Set<Object> set, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (bl) {
            Object object = this._originalTableModel.getValueAt(n3, n2);
            if (object != null) {
                set.add(object);
            } else if (bl2) {
                set.add(\u0101);
            }
        } else if (n4 != -1) {
            Object object = this._filterTableModel.getValueAt(n4, n2);
            if (object != null) {
                set.add(object);
            } else if (bl2) {
                set.add(\u0101);
            }
        }
    }

    @Override
    public Set<Object> getPossibleValues(int n2, boolean bl, boolean bl2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        boolean bl3 = this._filterTableModel.hasFilter();
        int n3 = this._originalTableModel.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (bl3) {
                this.updatePossibleValues(hashSet, n2, i2, this._filterTableModel instanceof FilterableTableModel ? ((FilterableTableModel)this._filterTableModel).getVisualRowAt(i2) : -1, bl, bl2);
                continue;
            }
            this.updatePossibleValues(hashSet, n2, i2, i2, bl, bl2);
        }
        return hashSet;
    }

    @Override
    public boolean hasFilter() {
        return this._filterTableModel.getFilterItems().size() > 0 || this._tableModel.getFilterItems().size() > 0;
    }

    @Override
    public void clearFilters() {
        this._filterTableModel.clearFilters();
        this._tableModel.clearFilters();
        this._filterTableModel.setFiltersApplied(false);
        this._tableModel.setFiltersApplied(false);
    }

    @Override
    public void applyFilters() {
        this._filterTableModel.setFiltersApplied(true);
        this._tableModel.setFiltersApplied(true);
    }

    @Override
    public void applyFilters(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.applyFilters();
    }

    @Override
    public void setFilter(Object[] objectArray, int n2, boolean bl) {
        this._filterTableModel.removeAllFilters(n2);
        this._tableModel.removeAllFilters(n2);
        if (objectArray != null) {
            if (bl) {
                this._filterTableModel.addFilter(n2, new InFilter<Object>(objectArray));
            } else {
                this._tableModel.addFilter(n2, new InFilter<Object>(objectArray));
            }
        }
    }

    @Override
    public void setExcludeFilter(Object[] objectArray, int n2, boolean bl) {
        this._filterTableModel.removeAllFilters(n2);
        this._tableModel.removeAllFilters(n2);
        if (objectArray != null) {
            if (bl) {
                this._filterTableModel.addFilter(n2, new NotInFilter<Object>(objectArray));
            } else {
                this._tableModel.addFilter(n2, new NotInFilter<Object>(objectArray));
            }
        }
    }

    @Override
    public void setFilter(Filter filter, int n2, boolean bl) {
        this._filterTableModel.removeAllFilters(n2);
        this._tableModel.removeAllFilters(n2);
        if (filter != null) {
            if (bl) {
                this._filterTableModel.addFilter(n2, filter);
            } else {
                this._tableModel.addFilter(n2, filter);
            }
        }
    }

    @Override
    public int getFilteredRowIndex(int n2) {
        if (!(this._tableModel.isFiltersApplied() && this._tableModel.hasFilter() || this._filterTableModel.isFiltersApplied() && this._filterTableModel.hasFilter())) {
            return n2;
        }
        return TableModelWrapperUtils.getRowAt(this._tableModel, this._originalTableModel, n2);
    }

    @Override
    public int getActualRowIndex(int n2) {
        return TableModelWrapperUtils.getActualRowAt((TableModel)this._tableModel, n2, this._originalTableModel);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        if (this._originalTableModel instanceof AbstractTableModel) {
            TableModelListener[] tableModelListenerArray;
            for (TableModelListener tableModelListener2 : tableModelListenerArray = ((AbstractTableModel)this._originalTableModel).getTableModelListeners()) {
                this._originalTableModel.removeTableModelListener(tableModelListener2);
            }
            this._originalTableModel.addTableModelListener(tableModelListener);
            for (TableModelListener tableModelListener2 : tableModelListenerArray) {
                this._originalTableModel.addTableModelListener(tableModelListener2);
            }
            this._originalTableModel.addTableModelListener(tableModelListener);
        } else {
            this._originalTableModel.addTableModelListener(tableModelListener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this._originalTableModel.removeTableModelListener(tableModelListener);
        this._originalTableModel.removeTableModelListener(tableModelListener);
    }
}

