/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.utils.HtmlUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class ImagePreviewPanel
extends JPanel {
    private static final int \u0110 = 100;
    private static final int \u010f = 60;
    private Color \u0102;
    private Color \u0103;
    private Color \u010e;
    private ImageIcon \u0107;
    private String \u0104;
    private Dimension \u0109;
    private String \u010d;
    private boolean \u0106;
    private boolean \u010c;
    private int \u0101 = 255;
    private A \u010a;
    private JLabel \u0105;
    private JLabel \u010b;
    private JTextArea \u0108;

    public ImagePreviewPanel() {
        this.\u0102();
    }

    public ImagePreviewPanel(String string, ImageIcon imageIcon, Dimension dimension, String string2, int n2) {
        this.\u0104 = string;
        this.\u0107 = imageIcon;
        this.\u0109 = dimension;
        this.\u010d = string2;
        this.\u0101 = n2;
        this.\u0102();
    }

    public Dimension getImageSize() {
        return this.\u0109;
    }

    public void setImageSize(Dimension dimension) {
        this.\u0109 = dimension;
        this.\u0103();
    }

    private void \u0102() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        this.\u010a = new A(this.\u0107);
        this.add(this.\u010a);
        if (this.getShowDetails() != 0) {
            JComponent jComponent = this.createDetailsPanel();
            JideSwingUtilities.setOpaqueRecursively(jComponent, false);
            this.add((Component)jComponent, "After");
        }
        this.\u0104();
    }

    protected JComponent createDetailsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1, 2));
        if ((this.getShowDetails() & 1) != 0) {
            this.\u0105 = new JLabel(this.getImageTitle() != null ? this.getImageTitle() : ""){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 12);
                }
            };
            jPanel.add(this.createLabel(this.getResourceString("ImagePreviewList.title"), this.\u0105));
        }
        if ((this.getShowDetails() & 4) != 0) {
            this.\u010b = new JLabel(this.\u0101()){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 12);
                }
            };
            jPanel.add(this.createLabel(this.getResourceString("ImagePreviewList.size"), this.\u010b));
        }
        if ((this.getShowDetails() & 2) != 0) {
            this.\u0108 = new MultilineLabel(this.getImageDescription() != null ? this.getImageDescription() : ""){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 20);
                }
            };
            JScrollPane jScrollPane = new JScrollPane(this.\u0108);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)this.createDescription(this.getResourceString("ImagePreviewList.description"), jScrollPane), "vary");
        } else {
            jPanel.add(Box.createGlue(), "vary");
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        return jPanel;
    }

    private String \u0101() {
        Dimension dimension = this.getImageSize();
        if (dimension == null) {
            return this.getIcon() != null ? this.getIcon().getIconWidth() + " x " + this.getIcon().getIconHeight() : "";
        }
        return dimension.width + " x " + dimension.height;
    }

    protected JComponent createDescription(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(UIDefaultsLookup.getFont("TitledBorder.font"));
        jPanel.add((Component)jLabel, "First");
        jPanel.add(jComponent);
        return jPanel;
    }

    protected JComponent createLabel(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(UIDefaultsLookup.getFont("TitledBorder.font"));
        jPanel.add((Component)jLabel, "Before");
        if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setEditable(false);
        }
        jComponent.setBorder(BorderFactory.createEmptyBorder());
        jComponent.setOpaque(false);
        jPanel.add(jComponent);
        return jPanel;
    }

    public ImagePreviewPanel(String string, ImageIcon imageIcon) {
        this.\u0104 = string;
        this.\u0107 = imageIcon;
    }

    @Override
    public void paint(Graphics graphics) {
        Insets insets = this.getInsets();
        graphics.setColor(this.getGridBackground());
        graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        graphics.setColor(this.getGridForeground());
        graphics.drawRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        super.paint(graphics);
        if (this.isSelected()) {
            Color color = this.getHighlightBackground();
            graphics.setColor(color);
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }
        if (this.isFocused()) {
            graphics.setColor(new Color(~this.getBackground().getRGB()));
            BasicGraphicsUtils.drawDashedRect(graphics, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }
    }

    public boolean isSelected() {
        return this.\u0106;
    }

    public void setSelected(boolean bl) {
        this.\u0106 = bl;
        this.repaint();
    }

    public boolean isFocused() {
        return this.\u010c;
    }

    public void setFocused(boolean bl) {
        this.\u010c = bl;
        this.repaint();
    }

    public ImageIcon getIcon() {
        return this.\u0107;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.\u0107 = imageIcon;
        this.\u010a.\u0101(imageIcon);
        this.\u0103();
        this.repaint();
    }

    private void \u0103() {
        String string = this.\u0101();
        if (this.\u010b != null && !JideSwingUtilities.equals(this.\u010b.getText(), string)) {
            this.\u010b.setText(string);
        }
    }

    public String getImageTitle() {
        return this.\u0104;
    }

    public void setImageTitle(String string) {
        this.\u0104 = string;
        if (this.\u0105 != null && !JideSwingUtilities.equals(this.\u0105.getText(), this.\u0104)) {
            this.\u0105.setText(this.\u0104);
        }
        this.\u0104();
    }

    private void \u0104() {
        if (this.getImageTitle() == null && this.getImageDescription() == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("<HTML>" + (this.getImageTitle() != null ? "<B>" + HtmlUtils.formatHtmlSubString(this.getResourceString("ImagePreviewList.title")) + "</B> " + HtmlUtils.formatHtmlSubString(this.getImageTitle()) : "") + (this.getImageDescription() != null ? "<BR><B>" + HtmlUtils.formatHtmlSubString(this.getResourceString("ImagePreviewList.description")) + "</B> " + HtmlUtils.formatHtmlSubString(this.getImageDescription()) : "") + "</HTML>");
        }
    }

    public String getImageDescription() {
        return this.\u010d;
    }

    public void setImageDescription(String string) {
        this.\u010d = string;
        if (this.\u0108 != null && !JideSwingUtilities.equals(this.\u0108.getText(), this.\u010d)) {
            this.\u0108.setText(this.\u010d);
        }
        this.\u0104();
    }

    public int getShowDetails() {
        return this.\u0101;
    }

    public void setShowDetails(int n2) {
        int n3 = this.\u0101;
        if (n3 != n2) {
            this.\u0101 = n2;
            this.\u0102();
        }
    }

    private static BufferedImage \u0101(Component component, ImageIcon imageIcon, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (n2 >= imageIcon.getIconWidth() / 2) {
            BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
            graphics2D.dispose();
            return bufferedImage;
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
        graphics2D.dispose();
        return JideSwingUtilities.getFasterScaledInstance(bufferedImage, n2, n3, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public Color getGridForeground() {
        return this.\u0102;
    }

    public void setGridForeground(Color color) {
        this.\u0102 = color;
    }

    public Color getGridBackground() {
        return this.\u0103;
    }

    public void setGridBackground(Color color) {
        this.\u0103 = color;
    }

    public Color getHighlightBackground() {
        return this.\u010e;
    }

    public void setHighlightBackground(Color color) {
        this.\u010e = color;
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.list.list", this.getLocale()).getString(string);
    }

    private class A
    extends JComponent {
        private ImageIcon \u0103;
        private int \u0102 = 12;

        public A() {
            this.setDoubleBuffered(true);
        }

        public A(ImageIcon imageIcon) {
            this.\u0103 = imageIcon;
            this.setDoubleBuffered(true);
        }

        public void \u0101(ImageIcon imageIcon) {
            this.\u0103 = imageIcon;
        }

        public int \u0101() {
            return this.\u0102;
        }

        public void \u0101(int n2) {
            this.\u0102 = n2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n2;
            int n3;
            int n4;
            int n5;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            int n6 = this.getWidth();
            int n7 = this.getHeight();
            if (this.isOpaque()) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, n6, n7);
            }
            if ((n5 = this.\u0103 != null ? this.\u0103.getIconWidth() : 100) * (n4 = n7 - 2 * this.\u0102) > (n3 = n6 - 2 * this.\u0102) * (n2 = this.\u0103 != null ? this.\u0103.getIconHeight() : 100)) {
                n4 = n3 * n2 / n5;
            } else if (n5 * n4 < n3 * n2) {
                n3 = n4 * n5 / n2;
            }
            if (n3 > n5) {
                n3 = n5;
            }
            if (n4 > n2) {
                n4 = n2;
            }
            if (n3 < 0 || n4 < 0) {
                return;
            }
            int n8 = (n6 - n3) / 2;
            int n9 = (n7 - n4) / 2;
            JideSwingUtilities.drawShadow(graphics2D, this, n8, n9, n3, n4);
            graphics2D.setColor(ImagePreviewPanel.this.getGridForeground());
            graphics2D.drawRect(n8 - 1, n9 - 1, n3 + 1, n4 + 1);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(n8, n9, n3, n4);
            if (this.\u0103 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(n5 == n3 ? this.\u0103.getImage() : ImagePreviewPanel.\u0101(this, this.\u0103, n3, n4), n8, n9, this);
            }
            graphics2D.dispose();
        }
    }
}

