/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableScrollPaneSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int[] \u013e = new int[]{0};

    public TableScrollPaneSearchable(TableScrollPane tableScrollPane) {
        super(tableScrollPane);
    }

    @Override
    public void installListeners() {
        TableScrollPane tableScrollPane;
        if (this._componentListener == null) {
            this._componentListener = this.createComponentListener();
        }
        this._component.addComponentListener(this._componentListener);
        Component component = JideSwingUtilities.getScrollPane(this._component);
        if (component != null) {
            component.addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            this._keyListener = this.createKeyListener();
        }
        if ((tableScrollPane = (TableScrollPane)this._component).getMainTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getMainTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowFooterTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowHeaderTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowHeaderTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getColumnFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getColumnFooterTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowHeaderColumnFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowHeaderColumnFooterTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowFooterColumnFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowFooterColumnFooterTable(), this._keyListener, 0);
        }
        if (this._focusListener == null) {
            this._focusListener = this.createFocusListener();
        }
        this.getComponent().addFocusListener(this._focusListener);
        tableScrollPane.getModel().addTableModelListener(this);
        this._component.addPropertyChangeListener("model", this);
    }

    @Override
    public void uninstallListeners() {
        Component component;
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            component = JideSwingUtilities.getScrollPane(this.getComponent());
            if (component != null) {
                component.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            component = (TableScrollPane)this._component;
            JideSwingUtilities.insertKeyListener(((TableScrollPane)component).getMainTable(), this._keyListener, 0);
            if (((TableScrollPane)component).getMainTable() != null) {
                ((TableScrollPane)component).getMainTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowHeaderTable() != null) {
                ((TableScrollPane)component).getRowHeaderTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowFooterTable() != null) {
                ((TableScrollPane)component).getRowFooterTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getColumnFooterTable() != null) {
                ((TableScrollPane)component).getColumnFooterTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowHeaderColumnFooterTable() != null) {
                ((TableScrollPane)component).getRowHeaderColumnFooterTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowFooterColumnFooterTable() != null) {
                ((TableScrollPane)component).getRowFooterColumnFooterTable().removeKeyListener(this._keyListener);
            }
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        if (this._component instanceof TableScrollPane) {
            ((TableScrollPane)this._component).getModel().removeTableModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl) {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            int n3 = n2;
            int n4 = this.getMainIndex();
            this.addTableScrollPaneSelection(tableScrollPane, n3, n4, bl);
        } else if (this.isRowSelectionAllowed(tableScrollPane)) {
            int n5 = n2;
            int n6 = this.getMainIndex();
            this.addTableScrollPaneSelection(tableScrollPane, n5, n6, bl);
        } else {
            int n7 = n2 / tableScrollPane.getColumnCount();
            int n8 = n2 % tableScrollPane.getColumnCount();
            this.addTableScrollPaneSelection(tableScrollPane, n7, n8, bl);
        }
    }

    protected void addTableScrollPaneSelection(TableScrollPane tableScrollPane, int n2, int n3, boolean bl) {
        if (!bl) {
            tableScrollPane.clearSelection();
        }
        if (n2 >= 0 && n3 >= 0 && n2 < tableScrollPane.getRowCount() && n3 < tableScrollPane.getColumnCount() && !tableScrollPane.isCellSelected(n2, n3)) {
            tableScrollPane.changeSelection(n2, n3, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(TableScrollPane tableScrollPane) {
        return this.getSearchColumnIndices().length == 1 && tableScrollPane.getColumnSelectionAllowed() && !tableScrollPane.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(TableScrollPane tableScrollPane) {
        return this.getSearchColumnIndices().length == 1 && !tableScrollPane.getColumnSelectionAllowed() && tableScrollPane.getRowSelectionAllowed();
    }

    @Override
    protected int getSelectedIndex() {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getSelectedColumn();
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getSelectedRow();
        }
        return tableScrollPane.getSelectedRow() * tableScrollPane.getColumnCount() + tableScrollPane.getSelectedColumn();
    }

    @Override
    protected Object getElementAt(int n2) {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return this.\u0101(tableScrollPane, this.getMainIndex(), n2);
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return this.\u0101(tableScrollPane, n2, this.getMainIndex());
        }
        if (this.getSearchColumnIndices().length > 1) {
            int n3 = n2 % tableScrollPane.getColumnCount();
            int n4 = tableScrollPane.convertColumnIndexToModel(n3);
            boolean bl = true;
            for (int n5 : this.getSearchColumnIndices()) {
                if (n5 != n4) continue;
                bl = false;
            }
            if (bl) {
                return null;
            }
            int n6 = n2 / tableScrollPane.getColumnCount();
            return this.\u0101(tableScrollPane, n6, n3);
        }
        int n7 = n2 % tableScrollPane.getColumnCount();
        int n8 = n2 / tableScrollPane.getColumnCount();
        return this.\u0101(tableScrollPane, n8, n7);
    }

    private Object \u0101(TableScrollPane tableScrollPane, int n2, int n3) {
        if (n2 >= 0 && n2 < tableScrollPane.getRowCount() && n3 >= 0 && n3 < tableScrollPane.getColumnCount()) {
            return tableScrollPane.getValueAt(n2, n3);
        }
        return null;
    }

    @Override
    protected int getElementCount() {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getColumnCount();
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getRowCount();
        }
        return tableScrollPane.getColumnCount() * tableScrollPane.getRowCount();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this.\u013e;
    }

    public void setSearchColumnIndices(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (!JideSwingUtilities.equals(nArray2 = this.\u013e, nArray, true)) {
            this.\u013e = nArray;
            this.hidePopup();
        }
    }

    public int getMainIndex() {
        if (this.\u013e.length == 0) {
            return -1;
        }
        return this.\u013e[0];
    }

    public void setMainIndex(int n2) {
        int[] nArray;
        int[] nArray2 = new int[]{n2};
        if (n2 < 0) {
            nArray2 = new int[]{};
        }
        if ((nArray = this.\u013e) != nArray2) {
            this.\u013e = nArray2;
            this.hidePopup();
        }
    }

    @Override
    protected boolean isFindNextKey(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return n2 == 39;
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return n2 == 40;
        }
        return n2 == 40 || n2 == 39;
    }

    @Override
    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return n2 == 37;
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return n2 == 38;
        }
        return n2 == 38 || n2 == 37;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getOldValue()).removeTableModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent keyEvent) {
        boolean bl = this.isSelectedCellEditable();
        return !bl && super.isActivateKey(keyEvent);
    }

    protected boolean isSelectedCellEditable() {
        int n2 = ((TableScrollPane)this._component).getSelectedRow();
        int n3 = ((TableScrollPane)this._component).getSelectedColumn();
        return n2 != -1 && n3 != -1 && ((TableScrollPane)this._component).isCellEditable(n2, n3);
    }
}

