/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ISortableTableModel;
import java.util.ArrayList;
import java.util.List;

public class SortItemSupport {
    protected List<ISortableTableModel.SortItem> _sortingColumns = new ArrayList<ISortableTableModel.SortItem>();
    private int \u0106 = -1;
    private int \u0103 = 0;
    private boolean \u0105 = true;
    private boolean \u0101 = true;
    private int[] \u0102;
    private SortOrderHandler \u0104;

    public int[] getMasterSortColumns() {
        return this.\u0102;
    }

    public void setMasterSortColumns(int[] nArray) {
        this.\u0102 = nArray;
    }

    public int getMasterSortColumnIndex(int n2) {
        int[] nArray = this.getMasterSortColumns();
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n3 = nArray[i2];
                if (n3 != n2) continue;
                return i2;
            }
        }
        return -1;
    }

    ISortableTableModel.SortItem \u0101(int n2) {
        for (ISortableTableModel.SortItem sortItem : this._sortingColumns) {
            if (sortItem.getColumn() != n2) continue;
            return sortItem;
        }
        return null;
    }

    protected void addSortItem(ISortableTableModel.SortItem sortItem) {
        if (this.getMaximumSortColumns() == -1 || this._sortingColumns.size() < this.getMaximumSortColumns()) {
            if (this.getSortPriority() == 1) {
                this._sortingColumns.add(0, sortItem);
            } else if (this.getSortPriority() == 0) {
                this._sortingColumns.add(sortItem);
            }
        } else if (this.getSortPriority() == 1) {
            this._sortingColumns.add(0, sortItem);
            this._sortingColumns.remove(this.getMaximumSortColumns());
        }
    }

    public boolean sortColumn(int n2) {
        return this.sortColumn(n2, false, true);
    }

    public boolean sortColumn(int n2, boolean bl) {
        return this.sortColumn(n2, bl, true);
    }

    public boolean unsortColumn(int n2) {
        ISortableTableModel.SortItem sortItem = this.\u0101(n2);
        if (sortItem != null) {
            this._sortingColumns.remove(sortItem);
            return true;
        }
        return false;
    }

    public boolean reverseColumnSortOrder(int n2) {
        ISortableTableModel.SortItem sortItem = this.\u0101(n2);
        if (sortItem != null) {
            sortItem.\u0101();
            return true;
        }
        return false;
    }

    public boolean sortColumn(int n2, boolean bl, boolean bl2) {
        ISortableTableModel.SortItem sortItem;
        if (bl) {
            this._sortingColumns.clear();
        }
        if ((sortItem = this.\u0101(n2)) != null) {
            if (sortItem.ascending != bl2) {
                sortItem.ascending = bl2;
                return true;
            }
            return false;
        }
        ISortableTableModel.SortItem sortItem2 = new ISortableTableModel.SortItem(n2);
        sortItem2.ascending = bl2;
        this.addSortItem(sortItem2);
        return true;
    }

    public boolean isColumnSorted(int n2) {
        return this.\u0101(n2) != null;
    }

    public boolean isColumnAscending(int n2) {
        ISortableTableModel.SortItem sortItem = this.\u0101(n2);
        return sortItem != null && sortItem.isAscending();
    }

    public boolean reset() {
        if (!this.isEmpty()) {
            this._sortingColumns.clear();
            return true;
        }
        return false;
    }

    protected boolean isEmpty() {
        return this._sortingColumns == null || this._sortingColumns.size() == 0;
    }

    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return new ArrayList<ISortableTableModel.SortItem>(this._sortingColumns);
    }

    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        this._sortingColumns = list;
    }

    public int getColumnSortRank(int n2) {
        for (int i2 = 0; i2 < this._sortingColumns.size(); ++i2) {
            ISortableTableModel.SortItem sortItem = this._sortingColumns.get(i2);
            if (sortItem.getColumn() != n2) continue;
            return i2;
        }
        return -1;
    }

    public boolean isMultiColumnSortable() {
        return this.\u0105;
    }

    public void setMultiColumnSortable(boolean bl) {
        boolean bl2 = this.\u0105;
        if (bl2 == bl) {
            return;
        }
        this.\u0105 = bl;
    }

    public boolean isSortable() {
        return this.\u0101;
    }

    public void setSortable(boolean bl) {
        this.\u0101 = bl;
    }

    public int getSortPriority() {
        return this.\u0103;
    }

    public void setSortPriority(int n2) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("sortPriority must be one the following value: SORT_PRIORITY_FILO (the default), or SORT_PRIORITY_FIFO");
        }
        this.\u0103 = n2;
    }

    public int getMaximumSortColumns() {
        return this.\u0106;
    }

    public void setMaximumSortColumns(int n2) {
        this.\u0106 = n2;
    }

    public SortOrderHandler getSortOrderHandler() {
        return this.\u0104;
    }

    public void setSortOrderHandler(SortOrderHandler sortOrderHandler) {
        this.\u0104 = sortOrderHandler;
    }

    public void toggleSortOrder(int n2, boolean bl) {
        SortOrderHandler sortOrderHandler = this.getSortOrderHandler();
        if (sortOrderHandler != null) {
            sortOrderHandler.toggleSortOrder(n2, bl);
        } else if (this.isMultiColumnSortable() && bl) {
            if (!this.isColumnSorted(n2)) {
                this.sortColumn(n2, false, true);
            } else if (this.isColumnAscending(n2)) {
                this.reverseColumnSortOrder(n2);
            } else {
                this.unsortColumn(n2);
            }
        } else if (!this.isColumnSorted(n2)) {
            this.sortColumn(n2, true, true);
        } else if (this.isColumnAscending(n2)) {
            this.reverseColumnSortOrder(n2);
        } else {
            this.reset();
        }
    }

    public static interface SortOrderHandler {
        public void toggleSortOrder(int var1, boolean var2);
    }
}

