/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.PagedTablePane;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.paging.PageNavigationBar;
import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class PagedTablePaneNavigationBar
extends PageNavigationBar {
    private PagedTablePane \u0108;

    public PagedTablePaneNavigationBar(PagedTablePane pagedTablePane) {
        this.\u0108 = pagedTablePane;
        int n2 = 20;
        final JTable[] jTableArray = this.\u0108.getTables();
        int n3 = jTableArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            final JTable jTable = jTableArray[i2];
            jTable.addMouseWheelListener(this.createMouseWheelListener());
            jTable.getSelectionModel().addListSelectionListener(this.createSelectionListener());
            TableModel object = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PageNavigationSupport.class);
            n2 = jTable.getPreferredScrollableViewportSize().height / jTable.getRowHeight();
            if (this._pageNavigationSupport == null) {
                if (object instanceof PageNavigationSupport) {
                    this._pageNavigationSupport = (PageNavigationSupport)((Object)object);
                } else {
                    this._pageNavigationSupport = this.createPageTableModel(jTable.getModel(), n2);
                    jTable.setModel((TableModel)((Object)this._pageNavigationSupport));
                }
                this._pageNavigationSupport.addPageNavigationListener(this.createPageNavigationListener());
                final JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jTable);
                if (jScrollPane != null) {
                    jScrollPane.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            int n2 = jScrollPane.getViewport().getHeight() / jTable.getRowHeight();
                            int n3 = jTableArray.length;
                            for (int i2 = 0; i2 < n3; ++i2) {
                                JTable jTable2 = jTableArray[i2];
                                PageNavigationSupport pageNavigationSupport = (PageNavigationSupport)((Object)TableModelWrapperUtils.getActualTableModel(jTable2.getModel(), PageNavigationSupport.class));
                                if (pageNavigationSupport == null) continue;
                                pageNavigationSupport.setPageSize(n2);
                                pageNavigationSupport.setCurrentPage(i2);
                            }
                        }
                    });
                }
            }
            if (!(object instanceof PageNavigationSupport)) continue;
            ((PageNavigationSupport)((Object)object)).setPageSize(n2);
            ((PageNavigationSupport)((Object)object)).setCurrentPage(i2);
        }
        this.initComponents();
        for (JTable jTable : jTableArray) {
            this.registerKeyboardActions(jTable);
        }
        if (this._pageNavigationSupport != null) {
            this._pageNavigationSupport.addPageNavigationListener(new PageNavigationListener(){

                @Override
                public void pageNavigationEventFired(PageNavigationEvent pageNavigationEvent) {
                    if (pageNavigationEvent.getID() == 14101) {
                        int n2 = pageNavigationEvent.getNewValue();
                        JTable[] jTableArray = PagedTablePaneNavigationBar.this.\u0108.getTables();
                        for (int i2 = 1; i2 < jTableArray.length; ++i2) {
                            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTableArray[i2].getModel(), PageNavigationSupport.class);
                            if (tableModel == PagedTablePaneNavigationBar.this._pageNavigationSupport || !(tableModel instanceof PageNavigationSupport)) continue;
                            ((PageNavigationSupport)((Object)tableModel)).setCurrentPage(n2 + i2);
                        }
                    }
                }
            });
            this._pageNavigationSupport.setPageSize(n2);
        }
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    @Override
    public void lastPage() {
        if (this._pageNavigationSupport != null) {
            int n2 = this.getSelectedRecordIndex();
            int n3 = this.\u0108.getTables().length;
            this._pageNavigationSupport.setCurrentPage(this._pageNavigationSupport.getPageCount() - n3);
            this.setSelectedRecordIndex(n2);
            this.updateButtonPanel();
        }
    }

    @Override
    protected int getPageSize() {
        return this.\u0108.getTables().length * this._pageNavigationSupport.getPageSize();
    }

    @Override
    protected int getSelectedRecordIndex() {
        JTable[] jTableArray = this.\u0108.getTables();
        for (int i2 = 0; i2 < jTableArray.length; ++i2) {
            JTable jTable = jTableArray[i2];
            if (!jTable.hasFocus()) continue;
            return i2 * this._pageNavigationSupport.getPageSize() + jTable.getSelectedRow();
        }
        return -1;
    }

    @Override
    protected void setSelectedRecordIndex(int n2) {
        JTable[] jTableArray = this.\u0108.getTables();
        int n3 = n2 / this._pageNavigationSupport.getPageSize();
        int n4 = n2 % this._pageNavigationSupport.getPageSize();
        if (jTableArray[n3] != null) {
            if (!jTableArray[n3].hasFocus()) {
                jTableArray[n3].requestFocus();
            }
            jTableArray[n3].getSelectionModel().setSelectionInterval(n4, n4);
        }
    }

    @Override
    protected void changeCurrentPage(int n2) {
        this._pageNavigationSupport.setCurrentPage(n2);
    }
}

