/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.AbstractGaugeTickStyle;
import com.jidesoft.gauge.DefaultGaugeModel;
import com.jidesoft.gauge.DefaultNeedleRenderer;
import com.jidesoft.gauge.DialAxis;
import com.jidesoft.gauge.DialFrame;
import com.jidesoft.gauge.DialLabelOrientation;
import com.jidesoft.gauge.DialTickStyle;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.NeedleDescriptor;
import com.jidesoft.gauge.NeedleRenderer;
import com.jidesoft.gauge.NeedleStyle;
import com.jidesoft.range.Positionable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

public class Dial
extends AbstractGauge<DialAxis> {
    public static final String PROPERTY_DIAL_BACKGROUND = "Dial Background";
    private boolean \u015b = false;
    private double \u015c = 0.0;
    private double \u0159 = 360.0;
    private int \u014a;
    private int \u0149;
    private float \u014b;
    private double \u0146 = 0.0;
    private double \u014c = 0.0;
    private List<DialAxis> \u015d = new CopyOnWriteArrayList<DialAxis>();
    private double \u0151;
    private double \u014f = 3.0;
    private int \u0156 = 150;
    private NeedleRenderer \u0147 = null;
    private ActionListener \u0154;
    private Color \u015f = Color.white;
    private Paint \u015e = null;
    private DialFrame \u0155;
    private BufferedImage \u014e = null;
    private Shape \u0158 = null;
    private Dimension \u0152 = null;
    private Timer \u0153;
    private GaugeModel \u0148;
    private List<String> \u0157 = new CopyOnWriteArrayList<String>();
    private Map<String, NeedleRenderer> \u0160 = new HashMap<String, NeedleRenderer>();
    private Map<String, NeedleStyle> \u0150 = new HashMap<String, NeedleStyle>();
    private final A \u014d = new A();
    private List<Drawable> \u0161 = new CopyOnWriteArrayList<Drawable>();
    private Map<String, Shape> \u015a = new HashMap<String, Shape>();

    public Dial() {
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(300, 300));
        this.\u0154 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dial.this.\u0102();
            }
        };
        this.setAnimateOnChange(this.\u015b);
        this.setAxis(new DialAxis(0.0, 100.0, 10.0, 2.0));
        this.setModel(new DefaultGaugeModel());
        this.setAnimatedModel(new DefaultGaugeModel());
    }

    public List<String> getNeedleNames() {
        return this.\u0157;
    }

    public GaugeModel getAnimatedModel() {
        return this.\u0148;
    }

    public void setAnimatedModel(GaugeModel gaugeModel) {
        this.\u0148 = gaugeModel;
    }

    public DialAxis getAxis() {
        if (this.\u015d == null || this.\u015d.size() == 0) {
            return null;
        }
        return this.\u015d.get(0);
    }

    public void setAxis(DialAxis dialAxis) {
        if (this.\u015d == null) {
            this.\u015d = new CopyOnWriteArrayList<DialAxis>();
        } else {
            for (DialAxis dialAxis2 : this.\u015d) {
                dialAxis2.removePropertyChangeListener(this.\u014d);
            }
            this.\u015d.clear();
        }
        this.\u015d.add(dialAxis);
        if (dialAxis != null) {
            dialAxis.addPropertyChangeListener(this.\u014d);
        }
    }

    public void addAxis(DialAxis dialAxis) {
        if (this.\u015d == null) {
            this.\u015d = new CopyOnWriteArrayList<DialAxis>();
        }
        this.\u015d.add(dialAxis);
        if (dialAxis != null) {
            dialAxis.addPropertyChangeListener(this.\u014d);
        }
    }

    public void removeAxis(DialAxis dialAxis) {
        if (this.\u015d == null) {
            this.\u015d = new CopyOnWriteArrayList<DialAxis>();
        }
        if (this.\u015d.contains(dialAxis)) {
            dialAxis.removePropertyChangeListener(this.\u014d);
            this.\u015d.remove(dialAxis);
        }
    }

    public void addNeedle(String string, NeedleStyle needleStyle) {
        this.\u0157.add(string);
        this.\u0150.put(string, needleStyle);
        this.repaint();
    }

    public void setNeedleStyle(String string, NeedleStyle needleStyle) {
        assert (this.\u0157.contains(string));
        this.\u0150.put(string, needleStyle);
        this.repaint();
    }

    public NeedleStyle getNeedleStyle(String string) {
        NeedleStyle needleStyle = this.\u0150.get(string);
        if (needleStyle == null) {
            needleStyle = new NeedleStyle();
        }
        return needleStyle;
    }

    public void removeNeedle(String string) {
        this.\u0157.remove(string);
        this.\u0150.remove(string);
        this.\u0160.remove(string);
        this.repaint();
    }

    public void removeNeedles() {
        ArrayList<String> arrayList = new ArrayList<String>(this.\u0157);
        for (String string : arrayList) {
            this.\u0157.remove(string);
            this.\u0150.remove(string);
            this.\u0160.remove(string);
        }
        GaugeModel gaugeModel = this.getModel();
        if (gaugeModel != null) {
            gaugeModel.clearValues();
        }
        if (this.\u0148 != null) {
            this.\u0148.clearValues();
        }
        this.repaint();
    }

    public void setNeedleRenderer(String string, NeedleRenderer needleRenderer) {
        this.\u0160.put(string, needleRenderer);
    }

    public void removeNeedleRenderer(String string) {
        this.\u0160.remove(string);
    }

    public NeedleRenderer getNeedleRenderer(String string) {
        return this.\u0160.get(string);
    }

    public void addDrawable(Drawable drawable) {
        this.\u0161.add(drawable);
        this.repaint();
    }

    public void removeDrawable(Drawable drawable) {
        this.\u0161.remove(drawable);
        this.repaint();
    }

    public void removeDrawables() {
        this.\u0161.clear();
        this.repaint();
    }

    public boolean isAnimateOnChange() {
        return this.\u015b;
    }

    public void setAnimateOnChange(boolean bl) {
        this.\u015b = bl;
        if (bl) {
            this.\u0103();
        } else if (this.\u0153 != null && this.\u0153.isRunning()) {
            this.\u0153.stop();
            this.\u0153 = null;
        }
    }

    private void \u0103() {
        if (this.\u0153 != null && this.\u0153.isRunning()) {
            this.\u0153.stop();
        }
        this.\u0153 = new Timer(this.\u0156, this.\u0154);
        this.\u0153.start();
    }

    public double getNeedleAnimationSpeed() {
        return this.\u014f;
    }

    public void setNeedleAnimationSpeed(double d2) {
        this.\u014f = d2;
    }

    public int getNeedleAnimationPeriod() {
        return this.\u0156;
    }

    public void setNeedleAnimationPeriod(int n2) {
        this.\u0156 = n2;
        this.\u0103();
    }

    @Override
    public void setValue(String string, Positionable positionable, boolean bl) {
        Double d2;
        GaugeModel gaugeModel = this.getModel();
        Positionable positionable2 = gaugeModel == null ? null : gaugeModel.getValue(string);
        Double d3 = positionable2 == null ? null : Double.valueOf(positionable2.position());
        DialAxis dialAxis = this.getAxis();
        double d4 = dialAxis.minimum();
        double d5 = dialAxis.maximum();
        Double d6 = d2 = positionable == null ? null : Double.valueOf(positionable.position());
        if (d2 != null) {
            if (d2 < d4) {
                d2 = d4;
            } else if (d2 > d5) {
                d2 = d5;
            }
        }
        gaugeModel.setValue(string, positionable, bl);
        if (!this.\u015b || this.\u0148.getValue(string) == null) {
            this.\u0148.setValue(string, positionable, false);
        }
        this.firePropertyChange(string, d3, d2);
    }

    public Color getFaceColor() {
        return this.\u015f;
    }

    public void setFaceColor(Color color) {
        this.\u015f = color;
        this.\u014e = null;
        this.repaint();
    }

    public Paint getFacePaint() {
        return this.\u015e;
    }

    public void setFacePaint(Paint paint) {
        this.\u015e = paint;
        this.\u014e = null;
        this.repaint();
    }

    public void setDialBackground(Paint paint) {
        Paint paint2 = this.getBackgroundPaint();
        this.setBackgroundPaint(paint);
        this.firePropertyChange(PROPERTY_DIAL_BACKGROUND, paint2, paint);
    }

    public Paint getDialBackground() {
        return this.getBackgroundPaint();
    }

    public Color getTickColor() {
        DialAxis dialAxis = this.getAxis();
        if (dialAxis == null) {
            return Color.black;
        }
        DialTickStyle dialTickStyle = (DialTickStyle)dialAxis.getMajorTickStyle();
        return dialTickStyle == null ? Color.black : dialTickStyle.getTickColor();
    }

    public void setTickColor(Color color) {
        for (DialAxis dialAxis : this.\u015d) {
            ((DialTickStyle)dialAxis.getMajorTickStyle()).setTickColor(color);
            ((DialTickStyle)dialAxis.getMinorTickStyle()).setTickColor(color);
        }
        this.\u014e = null;
        this.repaint();
    }

    public double getStartAngle() {
        return this.\u015c;
    }

    public void setStartAngle(double d2) {
        this.\u015c = d2;
        this.repaint();
    }

    public double getEndAngle() {
        return this.\u0159;
    }

    public void setEndAngle(double d2) {
        this.\u0159 = d2;
        this.repaint();
    }

    Double \u0102(String string) {
        GaugeModel gaugeModel = this.getModel();
        Positionable positionable = this.\u015b ? this.\u0148.getValue(string) : (gaugeModel == null ? null : gaugeModel.getValue(string));
        Double d2 = positionable == null ? null : Double.valueOf(positionable.position());
        return this.getAngle(d2);
    }

    public NeedleDescriptor needleAt(Point2D point2D) {
        for (Map.Entry<String, Shape> entry : this.\u015a.entrySet()) {
            Shape shape = entry.getValue();
            if (!shape.contains(point2D)) continue;
            return new NeedleDescriptor(entry.getKey(), shape);
        }
        return null;
    }

    public Collection<NeedleDescriptor> needlesAt(Point2D point2D) {
        ArrayList<NeedleDescriptor> arrayList = new ArrayList<NeedleDescriptor>();
        for (Map.Entry<String, Shape> entry : this.\u015a.entrySet()) {
            Shape shape = entry.getValue();
            if (!shape.contains(point2D)) continue;
            NeedleDescriptor needleDescriptor = new NeedleDescriptor(entry.getKey(), shape);
            arrayList.add(needleDescriptor);
        }
        return arrayList;
    }

    public NeedleDescriptor rendered(String string) {
        Shape shape = this.\u015a.get(string);
        if (shape == null) {
            return null;
        }
        int n2 = this.\u0157.indexOf(string);
        return new NeedleDescriptor(string, shape, n2);
    }

    public Double getAngle(Double d2) {
        return this.getAngle(this.getAxis(), d2);
    }

    public Double getAngle(DialAxis dialAxis, Double d2) {
        if (d2 == null) {
            return null;
        }
        double d3 = dialAxis.getEndAngle() - dialAxis.getStartAngle();
        double d4 = dialAxis.minimum();
        double d5 = dialAxis.maximum();
        return dialAxis.getStartAngle() + d3 * (d2 - d4) / (d5 - d4);
    }

    private void \u0102() {
        for (String string : this.\u0157) {
            this.\u0101(string);
        }
        this.repaint();
    }

    private void \u0101(String string) {
        Double d2;
        Positionable positionable = this.\u0148.getValue(string);
        GaugeModel gaugeModel = this.getModel();
        Positionable positionable2 = gaugeModel == null ? null : gaugeModel.getValue(string);
        Double d3 = positionable == null ? null : Double.valueOf(positionable.position());
        Double d4 = d2 = positionable2 == null ? null : Double.valueOf(positionable2.position());
        if (d3 != null && d2 != null) {
            double d5 = d2 - d3;
            this.\u0151 = Math.signum(d5) + this.\u014f * (double)this.\u0156 / 1000.0 * d5;
            if (Math.abs(d3 - d2) <= 1.0) {
                this.\u0148.setValue(string, this.createPositionable(d2));
            } else {
                this.\u0148.setValue(string, this.createPositionable(d3 + this.\u0151));
            }
        }
    }

    Pair<Double, Double> \u0101(double d2, double d3) {
        double d4 = d3 - d2;
        if (Math.abs(d4) > 360.0) {
            if (d4 > 0.0) {
                while (Math.abs(d4 = (d3 -= 360.0) - d2) > 360.0) {
                }
            } else {
                while (Math.abs(d4 = d3 - (d2 += 360.0)) > 360.0) {
                }
            }
        }
        while (Math.min(d2, d3) < 0.0) {
            d2 += 360.0;
            d3 += 360.0;
        }
        while (Math.max(d2, d3) >= 360.0) {
            d2 -= 360.0;
            d3 -= 360.0;
        }
        return new Pair<Double, Double>(d2, d3);
    }

    boolean \u0102(double d2, double d3, double d4) {
        assert (d2 >= 0.0 && d2 < 360.0);
        Pair<Double, Double> pair = this.\u0101(d3, d4);
        return Math.min(pair.getFirst(), pair.getSecond()) < d2 && Math.max(pair.getFirst(), pair.getSecond()) > d2;
    }

    public static double normalizeAngle(double d2) {
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 >= 360.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    double \u0101(double d2, double d3, double d4) {
        double d5;
        double d6 = Dial.normalizeAngle(d2);
        double d7 = d4;
        double d8 = d3;
        if (d7 == d8) {
            d7 += 360.0;
        }
        while (d7 <= 0.0) {
            d8 += 360.0;
            d7 += 360.0;
        }
        double d9 = Math.max(d8, d7);
        double d10 = Math.min(d8, d7);
        if (d10 < d6 && d9 > d6) {
            return d6;
        }
        if (d10 < d6 - 360.0 && d9 > d6 - 360.0) {
            return d6;
        }
        if (d10 < d6 + 360.0 && d9 > d6 + 360.0) {
            return d6;
        }
        double d11 = Math.abs(d6 - d9);
        if (d11 > 180.0) {
            d11 = 360.0 - d11;
        }
        if ((d5 = Math.abs(d10 - d6)) > 180.0) {
            d5 = 360.0 - d5;
        }
        if (d11 < d5) {
            return d9;
        }
        return d10;
    }

    protected Paint deriveFacePaint(Color color, float f2, float f3, float f4) {
        Color color2 = ColorUtils.getDerivedColor(color, 0.75f);
        return JideSwingUtilities.getRadialGradientPaint(f2 - 0.2f * f4, f3 - 0.2f * f4, f4, new float[]{0.2f, 1.0f}, new Color[]{color2, color});
    }

    private Pair<Point2D, Float> \u0102(Dimension dimension, Insets insets) {
        double d2 = this.\u015c;
        double d3 = this.\u0159;
        if (this.\u0155 != null) {
            double d4 = this.\u0155.getArcEndAngle();
            if (d2 < d3) {
                d2 -= d4;
                d3 += d4;
            } else {
                d2 += d4;
                d3 -= d4;
            }
        }
        int n2 = dimension == null ? 0 : dimension.width - insets.left - insets.right;
        int n3 = dimension == null ? 0 : dimension.height - insets.top - insets.bottom;
        return this.\u0101(d2, d3, n2, n3, true);
    }

    private Pair<Point2D, Float> \u0101(double d2, double d3, int n2, int n3, boolean bl) {
        double d4;
        double d5 = this.\u0101(90.0, d2, d3);
        double d6 = this.\u0101(270.0, d2, d3);
        double d7 = this.\u0101(180.0, d2, d3);
        double d8 = this.\u0101(0.0, d2, d3);
        if (d6 > 0.0 && d6 < 180.0) {
            d6 = 0.0;
        }
        if (d5 > 180.0 && d5 < 360.0) {
            d5 = 0.0;
        }
        double d9 = this.\u0155 == null ? 0.0 : this.\u0155.getMidChordRadius();
        double d10 = this.\u0104();
        double d11 = d10 + Math.max(d9, Math.abs(Math.sin(Math.toRadians(d5))));
        double d12 = d10 + Math.max(d9, Math.abs(Math.sin(Math.toRadians(d6))));
        double d13 = d10 + Math.max(d9, Math.abs(Math.cos(Math.toRadians(d7))));
        double d14 = d10 + Math.max(d9, Math.abs(Math.cos(Math.toRadians(d8))));
        double d15 = d11 + d12;
        double d16 = d13 + d14;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        double d17 = (double)n2 / d16;
        double d18 = d17 * d15;
        double d19 = n2;
        double d20 = d18;
        if (d18 > (double)n3) {
            d4 = (double)n3 / d15;
            d19 = d4 * d16;
            d20 = n3;
        }
        d4 = d3 - d2;
        float f2 = (float)((d16 - 0.0 * d10) / d16 * (d19 / d16));
        if (bl) {
            double d21 = f2;
            double d22 = (double)f2 * (1.0 + this.\u0104());
            int n4 = (int)(d22 - d21);
            double d23 = Math.asin((float)n4 / f2);
            double d24 = Math.toDegrees(d23);
            if (d2 < d3) {
                return this.\u0101(d2 - d24, d3 + d24, n2, n3, false);
            }
            return this.\u0101(d2 + d24, d3 - d24, n2, n3, false);
        }
        float f3 = 0.0f;
        for (String string : this.\u0157) {
            float f4;
            NeedleStyle needleStyle = this.getNeedleStyle(string);
            if (needleStyle == null) continue;
            BasicStroke basicStroke = needleStyle.getOutlineStroke();
            float f5 = f4 = basicStroke == null ? 0.0f : basicStroke.getLineWidth();
            float f6 = (float)((double)f2 * needleStyle.getTailLength() + (double)f4);
            if (!(f6 > f3)) continue;
            f3 = f6;
        }
        float f7 = d4 <= 180.0 ? f3 : 0.0f;
        float f8 = (float)((double)((float)n2 / 2.0f) - (d14 - d13) * 0.5 * d19 / d16);
        float f9 = (float)(d11 * (d20 - (double)f7) / d15 + ((double)n3 - d20) / 2.0);
        return new Pair<Point2D, Float>(new Point2D.Double(f8, f9), Float.valueOf(f2 -= f7));
    }

    private Image \u0101(Dimension dimension, Insets insets) {
        int n2;
        int n3 = dimension == null ? 0 : dimension.width - insets.left - insets.right;
        int n4 = n2 = dimension == null ? 0 : dimension.height - insets.top - insets.bottom;
        if (this.getFontComparisonSize() == null && dimension != null && dimension.width > 0 && dimension.height > 0) {
            int n5 = Math.min(n3, n2);
            this.setFontComparisonSize(new Dimension(n5, n5));
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.\u014e != null && this.\u014e.getWidth() == n3 && this.\u014e.getHeight() == n2) {
            ChartUtils.clearBufferedImage(this.\u014e, Color.black);
        } else {
            this.\u014e = new BufferedImage(n3, n2, 2);
        }
        Graphics2D graphics2D = (Graphics2D)this.\u014e.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Pair<Point2D, Float> pair = this.\u0102(dimension, insets);
        Point2D point2D = pair.getFirst();
        Float f2 = pair.getSecond();
        float f3 = (float)point2D.getX();
        float f4 = (float)point2D.getY();
        if (f2.floatValue() > 0.0f) {
            int n5;
            Color color;
            Object object;
            int color2;
            ZOrder zOrder;
            Paint paint;
            int n8 = insets.left;
            int n9 = insets.top;
            if (this.\u015e != null) {
                paint = this.\u015e instanceof Color ? this.deriveFacePaint((Color)this.\u015e, f3 + (float)n8, f4 + (float)n9, f2.floatValue()) : this.\u015e;
            } else {
                if (this.\u015f == null) {
                    this.\u015f = Color.white;
                }
                paint = this.\u015f;
            }
            graphics2D.translate(-n8, -n9);
            graphics2D.setPaint(paint);
            GeneralPath generalPath = this.\u0101(null, f3 + (float)n8, f4 + (float)n9, f2.floatValue());
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.translate(n8, n9);
            Shape shape = graphics2D.getClip();
            generalPath = this.\u0101(null, f3, f4, f2.floatValue() + 1.0f);
            this.\u0101(graphics2D, n8, n9);
            int n10 = 1 + (this.\u0155 == null ? 0 : this.\u0155.getInnerBorderWidth());
            GeneralPath generalPath2 = this.\u0101(null, f3, f4, f2.floatValue() + (float)n10);
            graphics2D.setClip(generalPath2);
            graphics2D.translate(-n8, -n9);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n8, n9);
            this.\u0158 = affineTransform.createTransformedShape(generalPath);
            for (Drawable object22 : this.\u0161) {
                if (!(object22 instanceof ZOrder) || (zOrder = (ZOrder)((Object)object22)).getZOrder() >= 0) continue;
                object22.draw(graphics2D);
            }
            graphics2D.setClip(shape);
            Shape shape2 = this.\u0101(f3 + (float)n8, f4 + (float)n9, f2.floatValue());
            Color color3 = this.\u0155 == null ? Color.black : this.\u0155.getFill();
            graphics2D.setPaint(color3);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.fill(shape2);
            graphics2D.translate(n8, n9);
            ZOrder zOrder2 = zOrder = this.\u0155 == null ? null : this.\u0155.getOuterBorderColor();
            if (this.\u0155 != null && zOrder != null && (color2 = this.\u0155.getOuterBorderWidth()) > 0) {
                double n6 = f2.floatValue();
                double list = (double)f2.floatValue() * (1.0 + this.\u0104());
                double fontMetrics = list - n6;
                object = this.\u0101(null, f3, f4, list, fontMetrics);
                ((Path2D)object).closePath();
                graphics2D.setStroke(new BasicStroke(color2));
                graphics2D.setColor((Color)((Object)zOrder));
                graphics2D.draw((Shape)object);
            }
            Color color4 = color = this.\u0155 == null ? null : this.\u0155.getInnerBorderColor();
            if (this.\u0155 != null && color != null && (n5 = this.\u0155.getInnerBorderWidth()) > 0) {
                graphics2D.setStroke(new BasicStroke(n5));
                graphics2D.setColor(color);
                generalPath = this.\u0101(null, f3, f4, f2.floatValue());
                graphics2D.draw(generalPath);
            }
            for (DialAxis dialAxis : this.\u015d) {
                Object object2;
                double d2;
                double d3;
                List<Tick> list = dialAxis.ticks();
                Font font = this.tickLabelFontForAxis(dialAxis);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                List<Tick> list2 = this.isAllowTickLabelOverlap() ? list : this.\u0101(graphics2D, dialAxis, list, fontMetrics);
                object = this.longestTickLabel(list2, fontMetrics);
                boolean bl = dialAxis.getLabelRadius() < dialAxis.getInnerRadius();
                for (Tick tick : list) {
                    assert (tick != null);
                    d3 = tick.getPosition();
                    d2 = this.getAngle(dialAxis, d3);
                    object2 = tick.isMajor() ? (DialTickStyle)dialAxis.getMajorTickStyle() : (DialTickStyle)dialAxis.getMinorTickStyle();
                    if (!((AbstractGaugeTickStyle)object2).isVisible()) continue;
                    graphics2D.setColor(((AbstractGaugeTickStyle)object2).getTickColor());
                    this.\u0101(graphics2D, dialAxis, f3, f4, d2, f2.floatValue(), (DialTickStyle)object2);
                }
                if (!dialAxis.isTickLabelsVisible()) continue;
                for (Tick tick : list2) {
                    d3 = tick.getPosition();
                    d2 = this.getAngle(dialAxis, d3);
                    if (!tick.isMajor() || (object2 = dialAxis.getTickLabelColor()) == null) continue;
                    graphics2D.setColor((Color)object2);
                    String string = tick.getLabel();
                    if (string == null) continue;
                    this.\u0101(graphics2D, dialAxis, f3, f4, d2, f2.floatValue(), string, (String)object, bl);
                }
            }
        }
        graphics2D.dispose();
        this.\u0105();
        return this.\u014e;
    }

    @Override
    protected Point2D calculatePixelPoint2D(DialAxis dialAxis, double d2) {
        double d3 = this.getAngle(dialAxis, d2);
        double d4 = Math.toRadians(d3);
        int n2 = this.getPivotX();
        int n3 = this.getPivotY();
        float f2 = this.getRadius();
        double d5 = dialAxis.getLabelRadius();
        double d6 = (double)n2 + d5 * (double)f2 * Math.cos(d4);
        double d7 = (double)n3 - d5 * (double)f2 * Math.sin(d4);
        return new Point2D.Double(d6, d7);
    }

    private List<Tick> \u0101(Graphics2D graphics2D, DialAxis dialAxis, List<Tick> list, FontMetrics fontMetrics) {
        boolean bl;
        int n2 = 1;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        do {
            int n3 = 0;
            bl = false;
            Shape shape = null;
            arrayList.clear();
            String string = this.longestTickLabel(list, fontMetrics);
            int n4 = fontMetrics.stringWidth(string);
            boolean bl2 = dialAxis.getLabelRadius() < dialAxis.getInnerRadius();
            for (Tick tick : list) {
                if (tick.isMajor()) {
                    if (n3 == 0) {
                        Point2D point2D = this.calculatePixelPoint2D(dialAxis, tick.getPosition());
                        DialLabelOrientation dialLabelOrientation = dialAxis.getLabelOrientation();
                        double d2 = this.getAngle(dialAxis, tick.getPosition());
                        String string2 = tick.getLabel();
                        int n5 = string2 == null ? 0 : fontMetrics.stringWidth(string2);
                        double d3 = Math.toRadians(d2);
                        double d4 = this.\u0101(dialLabelOrientation, d2);
                        Insets insets = this.getInsets();
                        double d5 = point2D.getX() - (double)insets.left;
                        double d6 = point2D.getY() - (double)insets.top;
                        if (dialLabelOrientation == DialLabelOrientation.UPRIGHT) {
                            int n6 = (n4 - n5 - fontMetrics.stringWidth("0")) / 2;
                            double d7 = bl2 ? Math.cos(d3) * (double)n6 : -Math.cos(d3) * (double)n6;
                            d5 += d7;
                        }
                        Shape shape2 = this.\u0101(fontMetrics, tick.getLabel(), d5, d6, d4);
                        if (shape != null && shape2 != null) {
                            Area area = new Area(shape2);
                            Area area2 = new Area(shape);
                            area.intersect(area2);
                            if (!area.isEmpty()) {
                                bl = true;
                                break;
                            }
                        }
                        arrayList.add(tick);
                        shape = shape2;
                    }
                    if (++n3 != n2) continue;
                    n3 = 0;
                    continue;
                }
                arrayList.add(tick);
            }
            ++n2;
        } while (bl);
        graphics2D2.dispose();
        return arrayList;
    }

    private double \u0104() {
        double d2 = this.\u0155 == null ? 0.02 : this.\u0155.getFrameWidth();
        return d2;
    }

    private Shape \u0101(float f2, float f3, float f4) {
        assert (f4 > 0.0f);
        double d2 = f4;
        double d3 = (double)f4 * (1.0 + this.\u0104());
        double d4 = d3 - d2;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = this.\u0101(generalPath, f2, f3, d2);
        this.\u0101(generalPath, f2, f3, d3, d4);
        generalPath2.closePath();
        return generalPath2;
    }

    private GeneralPath \u0101(GeneralPath generalPath, float f2, float f3, double d2) {
        double d3;
        assert (this.\u014b > 0.0f);
        double d4 = this.\u0159 - this.\u015c;
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        double d5 = (double)f2 + d2 * Math.cos(Math.toRadians(this.\u015c));
        double d6 = (double)f3 - d2 * Math.sin(Math.toRadians(this.\u015c));
        generalPath.moveTo(d5, d6);
        Arc2D.Double double_ = new Arc2D.Double((double)f2 - d2, (double)f3 - d2, d2 * 2.0, d2 * 2.0, this.\u015c, d4, 0);
        generalPath.append(double_, false);
        double d7 = d3 = this.\u0155 == null ? 0.0 : this.\u0155.getArcEndAngle();
        if (d4 < 360.0 - 2.0 * d3) {
            double d8 = this.\u0155 == null ? 0.0 : this.\u0155.getMidChordRadius();
            double d9 = Dial.normalizeAngle((this.\u015c + this.\u0159) / 2.0 + 180.0);
            double d10 = d8 * d2;
            double d11 = (double)f2 + d10 * Math.cos(Math.toRadians(d9));
            double d12 = (double)f3 - d10 * Math.sin(Math.toRadians(d9));
            double d13 = (double)f2 + d2 * Math.cos(Math.toRadians(this.\u0159 + d3 * Math.signum(d4)));
            double d14 = (double)f3 - d2 * Math.sin(Math.toRadians(this.\u0159 + d3 * Math.signum(d4)));
            double d15 = d4 >= 0.0 ? (double)f2 - d11 : d11 - (double)f2;
            double d16 = d4 >= 0.0 ? (double)f3 - d12 : d12 - (double)f3;
            double d17 = d11 + d16;
            double d18 = d12 - d15;
            double d19 = d11 - d16;
            double d20 = d12 + d15;
            double d21 = (double)f2 + d2 * Math.cos(Math.toRadians(this.\u015c - d3 * Math.signum(d4)));
            double d22 = (double)f3 - d2 * Math.sin(Math.toRadians(this.\u015c - d3 * Math.signum(d4)));
            generalPath.curveTo(d13, d14, d17, d18, d11, d12);
            generalPath.curveTo(d19, d20, d21, d22, d5, d6);
        }
        return generalPath;
    }

    private GeneralPath \u0101(GeneralPath generalPath, float f2, float f3, double d2, double d3) {
        double d4;
        double d5;
        assert (this.\u014b > 0.0f);
        double d6 = this.\u0159 - this.\u015c;
        double d7 = Math.asin(d3 / (2.0 * d2));
        double d8 = 2.0 * Math.toDegrees(d7);
        double d9 = d6 >= 0.0 ? this.\u015c - d8 : this.\u015c + d8;
        double d10 = d5 = d6 >= 0.0 ? this.\u0159 + d8 : this.\u0159 - d8;
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        double d11 = (double)f2 + d2 * Math.cos(Math.toRadians(d9));
        double d12 = (double)f3 - d2 * Math.sin(Math.toRadians(d9));
        double d13 = (double)f2 + d2 * Math.cos(Math.toRadians(d5));
        double d14 = (double)f3 - d2 * Math.sin(Math.toRadians(d5));
        generalPath.moveTo(d11, d12);
        double d15 = d4 = this.\u0155 == null ? 0.0 : this.\u0155.getArcEndAngle();
        if (d6 < 360.0 - 2.0 * d4) {
            double d16 = this.\u0155 == null ? 0.0 : this.\u0155.getMidChordRadius();
            double d17 = Dial.normalizeAngle((this.\u015c + this.\u0159) / 2.0 + 180.0);
            double d18 = d16 * d2 + d3;
            double d19 = (double)f2 + d18 * Math.cos(Math.toRadians(d17));
            double d20 = (double)f3 - d18 * Math.sin(Math.toRadians(d17));
            double d21 = (double)f2 + d2 * Math.cos(Math.toRadians(d5 + d4 * Math.signum(d6)));
            double d22 = (double)f3 - d2 * Math.sin(Math.toRadians(d5 + d4 * Math.signum(d6)));
            double d23 = d6 >= 0.0 ? (double)f2 - d19 : d19 - (double)f2;
            double d24 = d6 >= 0.0 ? (double)f3 - d20 : d20 - (double)f3;
            double d25 = d19 + d24;
            double d26 = d20 - d23;
            double d27 = d19 - d24;
            double d28 = d20 + d23;
            double d29 = (double)f2 + d2 * Math.cos(Math.toRadians(d9 - d4 * Math.signum(d6)));
            double d30 = (double)f3 - d2 * Math.sin(Math.toRadians(d9 - d4 * Math.signum(d6)));
            generalPath.curveTo(d29, d30, d27, d28, d19, d20);
            generalPath.curveTo(d25, d26, d21, d22, d13, d14);
        }
        Arc2D.Double double_ = new Arc2D.Double((double)f2 - d2, (double)f3 - d2, d2 * 2.0, d2 * 2.0, d5, -d6, 0);
        generalPath.append(double_, true);
        return generalPath;
    }

    private void \u0101(Graphics2D graphics2D, int n2, int n3) {
        graphics2D.translate(-n2, -n3);
        for (DialAxis dialAxis : this.\u015d) {
            GeneralPath generalPath = this.createSegment(dialAxis.getStartAngle(), dialAxis.getEndAngle(), dialAxis.getInnerRadius(), dialAxis.getOuterRadius());
            Paint paint = dialAxis.getFill();
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(generalPath);
            }
            Color color = dialAxis.getBorderColor();
            BasicStroke basicStroke = dialAxis.getBorderStroke();
            if (color == null) continue;
            graphics2D.setColor(color);
            if (basicStroke == null) continue;
            graphics2D.setStroke(basicStroke);
            float f2 = basicStroke.getLineWidth() / this.\u014b;
            generalPath = this.createSegment(dialAxis.getStartAngle(), dialAxis.getEndAngle(), dialAxis.getInnerRadius() - (double)(f2 / 2.0f), dialAxis.getOuterRadius() + (double)(f2 / 2.0f));
            graphics2D.draw(generalPath);
        }
        graphics2D.translate(n2, n3);
    }

    public DialFrame getFrame() {
        return this.\u0155;
    }

    public void setFrame(DialFrame dialFrame) {
        this.\u0155 = dialFrame;
    }

    public float getRadius() {
        return this.\u014b;
    }

    private void \u0105() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        Pair<Point2D, Float> pair = this.\u0102(dimension, insets);
        Point2D point2D = pair.getFirst();
        this.\u014b = pair.getSecond().floatValue();
        this.\u014a = insets == null ? (int)point2D.getX() : insets.left + (int)point2D.getX();
        this.\u0149 = insets == null ? (int)point2D.getY() : insets.top + (int)point2D.getY();
    }

    public int getPivotX() {
        return this.\u014a;
    }

    public int getPivotY() {
        return this.\u0149;
    }

    public void update() {
        this.\u014e = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shape = graphics2D.getClip();
        Rectangle rectangle2 = rectangle = shape == null ? new Rectangle(0, 0, 0, 0) : shape.getBounds();
        if (this.isOpaque()) {
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        if (!dimension.equals(this.\u0152)) {
            this.\u014e = null;
        }
        this.\u0152 = dimension;
        Dimension dimension2 = this.getFontComparisonSize();
        if (this.isResizeFonts() && dimension.height > 0 && dimension2 != null) {
            int n2 = dimension.width - insets.left - insets.right;
            int n3 = dimension.height - insets.top - insets.bottom;
            float f2 = (float)n3 / (float)dimension2.height;
            float f3 = (float)n2 / (float)dimension2.width;
            this.setFontSizeRatio(Math.min(f2, f3));
        }
        if (this.\u014e == null) {
            this.\u0105();
            this.\u0101(dimension, insets);
        }
        graphics2D.drawImage((Image)this.\u014e, insets == null ? 0 : insets.left, insets == null ? 0 : insets.top, this);
        Area area = new Area(shape);
        area.intersect(new Area(this.\u0158));
        graphics2D.setClip(area);
        for (Drawable drawable : this.\u0161) {
            if (drawable instanceof ZOrder) {
                ZOrder zOrder = (ZOrder)((Object)drawable);
                if (zOrder.getZOrder() < 0 || zOrder.getZOrder() >= 100) continue;
                drawable.draw(graphics2D);
                continue;
            }
            drawable.draw(graphics2D);
        }
        this.\u0101(graphics2D);
        for (Drawable drawable : this.\u0161) {
            ZOrder zOrder;
            if (!(drawable instanceof ZOrder) || (zOrder = (ZOrder)((Object)drawable)).getZOrder() < 100) continue;
            drawable.draw(graphics2D);
        }
        graphics2D.setClip(shape);
    }

    private void \u0101(Graphics2D graphics2D) {
        float f2 = this.getRadius();
        this.\u015a.clear();
        for (String string : this.\u0157) {
            Shape shape;
            NeedleStyle needleStyle;
            Double d2;
            GaugeModel gaugeModel = this.getModel();
            Positionable positionable = this.\u015b ? this.\u0148.getValue(string) : (gaugeModel == null ? null : gaugeModel.getValue(string));
            Double d3 = d2 = positionable == null ? null : Double.valueOf(positionable.position());
            Double d4 = this.\u0102(string);
            if (d4 == null) continue;
            NeedleRenderer needleRenderer = this.\u0160.get(string);
            if (needleRenderer == null) {
                if (this.\u0147 == null) {
                    this.\u0147 = new DefaultNeedleRenderer();
                }
                needleRenderer = this.\u0147;
            }
            if (!(needleStyle = this.\u0150.get(string)).isVisible() || (shape = needleRenderer.paintNeedle(graphics2D, this, d2, this.\u014a, this.\u0149, d4, f2, needleStyle)) == null) continue;
            this.\u015a.put(string, shape);
        }
    }

    private void \u0101(Graphics2D graphics2D, DialAxis dialAxis, float f2, float f3, double d2, float f4, DialTickStyle dialTickStyle) {
        double d3 = dialAxis.getInnerRadius();
        double d4 = dialAxis.getOuterRadius();
        double d5 = d4 - d3;
        double d6 = Math.toRadians(d2);
        double d7 = d4 - d5 * dialTickStyle.getTickStart();
        double d8 = d4 - d5 * (dialTickStyle.getTickStart() + dialTickStyle.getTickLength());
        double d9 = (double)f2 + d7 * (double)f4 * Math.cos(d6);
        double d10 = (double)f3 - d7 * (double)f4 * Math.sin(d6);
        double d11 = (double)f2 + d8 * (double)f4 * Math.cos(d6);
        double d12 = (double)f3 - d8 * (double)f4 * Math.sin(d6);
        double d13 = dialTickStyle.getTickWidth();
        float f5 = (float)((double)f4 * d13 / 100.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        BasicStroke basicStroke = new BasicStroke(f5, 1, 1);
        graphics2D.setStroke(basicStroke);
        Line2D.Double double_ = new Line2D.Double(d9, d10, d11, d12);
        graphics2D.draw(double_);
    }

    private double \u0101(DialLabelOrientation dialLabelOrientation, double d2) {
        double d3 = Math.toRadians(d2);
        double d4 = dialLabelOrientation == DialLabelOrientation.PERPENDICULAR_OUTWARD ? d3 : (dialLabelOrientation == DialLabelOrientation.PERPENDICULAR_INWARD ? d3 - Math.PI : (dialLabelOrientation == DialLabelOrientation.TANGENTIAL_CLOCKWISE ? d3 - 1.5707963267948966 : (dialLabelOrientation == DialLabelOrientation.TANGENTIAL_ANTICLOCKWISE ? d3 + 1.5707963267948966 : 0.0)));
        return d4;
    }

    private void \u0101(Graphics2D graphics2D, DialAxis dialAxis, float f2, float f3, double d2, float f4, String string, String string2, boolean bl) {
        double d3 = Math.toRadians(d2);
        DialLabelOrientation dialLabelOrientation = dialAxis.getLabelOrientation();
        double d4 = dialAxis.getLabelRadius();
        Font font = this.tickLabelFontForAxis(dialAxis);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.stringWidth(string2);
        float f5 = f2 + (float)(d4 * (double)f4 * Math.cos(d3)) - (float)n2 / 2.0f;
        float f6 = f3 - (float)(d4 * (double)f4 * Math.sin(d3));
        double d5 = this.\u0101(dialLabelOrientation, d2);
        if (dialLabelOrientation == DialLabelOrientation.UPRIGHT) {
            int n4 = (n3 - n2 - fontMetrics.stringWidth("0")) / 2;
            double d6 = bl ? Math.cos(d3) * (double)n4 : -Math.cos(d3) * (double)n4;
            f5 = f2 + (float)(d4 * (double)f4 * Math.cos(d3) - (double)((float)n2 / 2.0f) + d6);
        }
        this.drawRotatedStringIfWithinBounds(graphics2D, font, string, Math.round(f5), Math.round(f6), d5);
    }

    private Shape \u0101(FontMetrics fontMetrics, String string, double d2, double d3, double d4) {
        if (string == null || "".equals(string)) {
            return null;
        }
        boolean bl = true;
        boolean bl2 = false;
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getAscent();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - (double)n2 / 2.0 - 1.0, d3 - (double)fontMetrics.getHeight() / 2.0 - 0.0, n2 + 2, n3 + 0);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-d4, d2, d3);
        return affineTransform.createTransformedShape(double_);
    }

    public GeneralPath createSegment(double d2, double d3, double d4, double d5) {
        int n2 = this.getPivotX();
        int n3 = this.getPivotY();
        float f2 = this.getRadius();
        double d6 = Math.toRadians(d2);
        double d7 = Math.toRadians(d3);
        GeneralPath generalPath = new GeneralPath();
        double d8 = d4 * (double)f2;
        double d9 = d5 * (double)f2;
        Point2D.Double double_ = new Point2D.Double((double)n2 + d8 * Math.cos(d6), (double)n3 - d8 * Math.sin(d6));
        Point2D.Double double_2 = new Point2D.Double((double)n2 + d9 * Math.cos(d7), (double)n3 - d9 * Math.sin(d7));
        generalPath.moveTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        Arc2D.Double double_3 = new Arc2D.Double((double)n2 - d8, (double)n3 - d8, d8 * 2.0, d8 * 2.0, d2, d3 - d2, 0);
        generalPath.append(double_3, true);
        generalPath.lineTo(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        Arc2D.Double double_4 = new Arc2D.Double((double)n2 - d9, (double)n3 - d9, d9 * 2.0, d9 * 2.0, d3, d2 - d3, 0);
        generalPath.append(double_4, true);
        generalPath.lineTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        generalPath.closePath();
        return generalPath;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Dial.class.getName(), 4096);
        }
    }

    class A
    implements PropertyChangeListener {
        A() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Dial.this.\u014e = null;
            Dial.this.repaint();
        }
    }
}

