/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import sun.awt.dnd.SunDragSourceContextPeer;

public class EditorDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent \u0101 = null;

    private static int \u0101() {
        return DragSource.getDragThreshold();
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiersEx();
        if ((n2 & 0x400) != 1024) {
            return 0;
        }
        JComponent jComponent = this.getComponent(mouseEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        return SunDragSourceContextPeer.convertModifiersToDropAction(n2, transferHandler.getSourceActions(jComponent));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.\u0101 = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.\u0101 = mouseEvent;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0101 = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.\u0101 != null) {
            mouseEvent.consume();
            int n2 = this.mapDragOperationFromModifiers(mouseEvent);
            if (n2 == 0) {
                return;
            }
            int n3 = Math.abs(mouseEvent.getX() - this.\u0101.getX());
            int n4 = Math.abs(mouseEvent.getY() - this.\u0101.getY());
            if (n3 > EditorDragGestureRecognizer.\u0101() || n4 > EditorDragGestureRecognizer.\u0101()) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.\u0101, n2);
                this.\u0101 = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private TransferHandler \u0101(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? null : jComponent.getTransferHandler();
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? true : jComponent.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }
}

