/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorDocumentComponent;
import com.jidesoft.editor.CodeEditorDocumentPane;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorDocumentPaneFindAndReplaceTarget
implements FindAndReplaceTarget,
DocumentListener {
    private CodeEditor \u012a;
    private String \u012c;
    private CodeEditorDocumentPane \u012b;
    private boolean \u012e = false;
    private boolean \u012d = false;
    private DocumentListener[] \u0129;

    public CodeEditorDocumentPaneFindAndReplaceTarget(CodeEditorDocumentPane codeEditorDocumentPane) {
        this.\u012b = codeEditorDocumentPane;
        this.next();
    }

    @Override
    public FindResultIntepreter getIntepreter() {
        return this.\u012a;
    }

    public CodeEditor getCodeEditor() {
        return this.\u012a;
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new JLabel(this.getResourceString("FindAndReplace.allOpenFiles"));
    }

    @Override
    public boolean hasNext() {
        String string = this.\u012b.getNextDocument(this.\u012c);
        return string != null && this.\u012b.getDocument(string) instanceof CodeEditorDocumentComponent;
    }

    @Override
    public void next() {
        DocumentComponent documentComponent;
        String string;
        if (this.\u012a != null && this.\u012e) {
            this.\u012a.getDocument().endCompoundEdit();
        }
        if ((string = this.\u012b.getNextDocument(this.\u012c)) != null && (documentComponent = this.\u012b.getDocument(string)) instanceof CodeEditorDocumentComponent) {
            this.changeCurrentEditor(((CodeEditorDocumentComponent)documentComponent).getCodeEditor(), string);
            return;
        }
        this.changeCurrentEditor(null, null);
    }

    @Override
    public boolean hasPrevious() {
        String string = this.\u012b.getPreviousDocument(this.\u012c);
        return string != null && this.\u012b.getDocument(string) instanceof CodeEditorDocumentComponent;
    }

    @Override
    public void previous() {
        DocumentComponent documentComponent;
        String string = this.\u012b.getPreviousDocument(this.\u012c);
        if (string != null && (documentComponent = this.\u012b.getDocument(string)) instanceof CodeEditorDocumentComponent) {
            this.changeCurrentEditor(((CodeEditorDocumentComponent)documentComponent).getCodeEditor(), string);
            return;
        }
        this.changeCurrentEditor(null, null);
    }

    @Override
    public int getCurrentPosition(boolean bl) {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            return bl ? this.getCodeEditor().getSelectionEnd() : this.getCodeEditor().getSelectionStart();
        }
        return this.getCodeEditor().getCaretModel().getOffset();
    }

    @Override
    public void adjustCurrentPosition(String string, boolean bl) {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            int n2 = bl ? this.getCodeEditor().getSelectionStart() : this.getCodeEditor().getSelectionEnd();
            this.getCodeEditor().select(n2, n2, true);
        }
    }

    @Override
    public void highlight(int n2, int n3) {
        if (this.\u012c != null && !this.\u012c.equals(this.\u012b.getActiveDocumentName())) {
            this.\u012b.setActiveDocument(this.\u012c, true);
        }
        this.getCodeEditor().\u0102(n2, n3, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int n2, int n3, String string) throws BadLocationException {
        this.getCodeEditor().getDocument().beginCompoundEdit();
        try {
            this.getCodeEditor().getDocument().remove(n2, n3);
            this.getCodeEditor().getDocument().insertString(n2, string, null);
            this.getCodeEditor().getCaretModel().setOffset(n2 + string.length());
        }
        finally {
            this.getCodeEditor().getDocument().endCompoundEdit();
        }
    }

    @Override
    public Window getPromptDialogParent() {
        return JideSwingUtilities.getWindowForComponent(this.getCodeEditor());
    }

    @Override
    public Point getPromptDialogLocation(Rectangle rectangle) {
        if (!this.getCodeEditor().isChangePromptDialogPosition()) {
            return null;
        }
        Point point = this.getCodeEditor().getCaretLocation();
        Point point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), Math.min(point.y + 50, this.getCodeEditor().getPainter().getHeight() - rectangle.height - 50));
        if (point2.y <= point.y && point2.y + rectangle.height >= point.y) {
            point2.y = Math.max(0, point.y - 50 - rectangle.height);
        }
        SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
        return point2;
    }

    @Override
    public Point getPromptDialogLocation() {
        Point point = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 10));
        SwingUtilities.convertPointToScreen(point, this.getCodeEditor().getPainter());
        return point;
    }

    @Override
    public void scrollToShowCaret(Rectangle rectangle) {
        Point point = this.getCodeEditor().getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getCodeEditor().getPainter());
        if (rectangle.y <= point.y && point.y <= rectangle.y + rectangle.height) {
            Point point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + 5));
            SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
            int n2 = this.getCodeEditor().getCaretModel().getViewPosition().line;
            if (rectangle.y <= point2.y && point2.y <= rectangle.y + rectangle.height) {
                Point point3 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 5));
                SwingUtilities.convertPointToScreen(point3, this.getCodeEditor().getPainter());
                if ((rectangle.y > point3.y || point3.y > rectangle.y + rectangle.height) && n2 >= this.getCodeEditor().getVisibleLines() - 5) {
                    this.getCodeEditor().setFirstLine(n2 - this.getCodeEditor().getVisibleLines() + 5);
                }
            } else if (n2 >= 5) {
                this.getCodeEditor().setFirstLine(n2 - 5);
            }
        }
    }

    @Override
    public String getCurrentName() {
        return this.\u012b.getDocument(this.\u012c).getTitle();
    }

    @Override
    public CharSequence getCurrentText() {
        CharSequence charSequence = this.getCodeEditor().getDocument() instanceof LazyLoadDocument ? ((LazyLoadDocument)this.getCodeEditor().getDocument()).getLazyLoadText() : this.getCodeEditor().getRawText();
        this.setTargetChanged(false);
        return charSequence;
    }

    @Override
    public void showMessage(String string) {
        this.getCodeEditor().showMessage(string);
    }

    @Override
    public void replaceAllStarts() {
        this.\u012e = true;
        this.getCodeEditor().getDocument().beginCompoundEdit();
        for (DocumentListener documentListener : this.\u0129 = this.getCodeEditor().getDocument().getDocumentListeners()) {
            this.getCodeEditor().getDocument().removeDocumentListener(documentListener);
        }
    }

    @Override
    public void replaceAllEnds() {
        this.getCodeEditor().getDocument().endCompoundEdit();
        if (this.\u0129 != null) {
            DocumentEvent documentEvent = this.getCodeEditor().createReplaceAllDocumentEvent();
            for (DocumentListener documentListener : this.\u0129) {
                this.getCodeEditor().getDocument().addDocumentListener(documentListener);
                documentListener.changedUpdate(documentEvent);
            }
        }
        this.\u012e = false;
    }

    protected void changeCurrentEditor(CodeEditor codeEditor, String string) {
        if (this.\u012a != null) {
            if (this.\u012e) {
                this.\u012a.getDocument().endCompoundEdit();
            }
            this.\u012a.getDocument().removeDocumentListener(this);
        }
        this.\u012a = codeEditor;
        this.\u012c = string;
        this.setTargetChanged(true);
        if (this.\u012a != null) {
            if (this.\u012e) {
                this.\u012a.getDocument().beginCompoundEdit();
            }
            this.\u012a.getDocument().addDocumentListener(this);
        }
    }

    protected void setTargetChanged(boolean bl) {
        this.\u012d = bl;
    }

    @Override
    public boolean isTargetChanged() {
        return this.\u012d;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getResourceString(String string) {
        return this.getCodeEditor().getResourceString(string);
    }

    @Override
    public Locale getLocale() {
        return this.getCodeEditor().getLocale();
    }
}

