/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.G;
import com.jidesoft.docking.J;
import java.awt.Rectangle;
import java.io.Serializable;

public class DockContext
implements Serializable {
    public static final int MODE_FLOATABLE = 1;
    public static final int MODE_AUTOHIDABLE = 2;
    public static final int MODE_DOCKABLE = 4;
    public static final int MODE_HIDABLE = 8;
    public static final int MODE_ALL = 15;
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_FLOATING = 1;
    public static final int STATE_AUTOHIDE = 2;
    public static final int STATE_AUTOHIDE_SHOWING = 3;
    public static final int STATE_FRAMEDOCKED = 4;
    public static final String[] STATE_NAMES = new String[]{"HIDE", "FLOAT", "AUTOHIDE", "AUTOHIDE_ACTIVE", "DOCK"};
    private int \u0109 = 4;
    private int \u010b = 4;
    private int \u0113 = 15;
    public static final int DOCK_SIDE_NORTH = 1;
    public static final int DOCK_SIDE_SOUTH = 2;
    public static final int DOCK_SIDE_EAST = 4;
    public static final int DOCK_SIDE_WEST = 8;
    public static final int DOCK_SIDE_CENTER = 16;
    public static final int DOCK_SIDE_UNKNOWN = 32;
    public static final int DOCK_SIDE_HORIZONTAL = 3;
    public static final int DOCK_SIDE_VERTICAL = 12;
    public static final int DOCK_SIDE_ALL = 15;
    public static final int DOCK_SIDE_ALL_AND_CENTER = 31;
    public static final String[] SIDE_NAMES = new String[]{"NORTH", "SOUTH", "EAST", "WEST", "CENTER", "FLOAT", "UNKNOWN"};
    private int \u010e = 4;
    private int \u010c;
    private boolean \u0110 = true;
    private int \u010a = 2;
    private Rectangle \u0107;
    private int \u0101 = 0;
    private int \u0116 = 0;
    private int \u0111 = 200;
    private int \u0115 = 200;
    private int \u0117 = 200;
    private int \u0112 = 200;
    private Rectangle \u0104;
    private int \u0103;
    private J \u0105;
    private J \u0118;
    private J \u010d;
    private J \u0102;
    private J \u0114;
    private J \u0108;
    private J \u010f;
    private boolean \u0106 = true;

    public int getInitMode() {
        return this.\u0109;
    }

    public void setInitMode(int n2) {
        if (n2 > 4 || n2 < -4) {
            throw new IllegalArgumentException(n2 + " is an invalid init mode for the setInitMode method. Valid modes are STATE_FRAMEDOCKED, STATE_FLOATING, STATE_AUTOHIDE, STATE_AUTOHIDE_SHOWING, STATE_HIDDEN and their negative values.");
        }
        this.\u0109 = n2;
    }

    public int getCurrentMode() {
        if (this.\u010b == -1) {
            return this.\u0109;
        }
        return this.\u010b;
    }

    public boolean isHidden() {
        return this.\u010b == 0;
    }

    public boolean isDocked() {
        return this.\u010b == 4;
    }

    public boolean isFloated() {
        return this.\u010b == 1;
    }

    public boolean isAutohide() {
        return this.\u010b == 2;
    }

    public boolean isAutohideShowing() {
        return this.\u010b == 3;
    }

    public void setCurrentMode(int n2) {
        this.\u010b = n2;
    }

    public int getInitSide() {
        return this.\u010e;
    }

    public void setInitSide(int n2) {
        if (n2 != 4 && n2 != 8 && n2 != 2 && n2 != 1 && n2 != 16) {
            throw new IllegalArgumentException(n2 + " is an invalid init side for the setInitSide method. Valid sides are DOCK_SIDE_EAST, DOCK_SIDE_WEST, DOCK_SIDE_SOUTH, DOCK_SIDE_NORTH and DOCK_SIDE_CENTER.");
        }
        this.\u010e = n2;
    }

    public boolean isInitPosition() {
        return this.\u0110;
    }

    public void setInitPosition(boolean bl) {
        this.\u0110 = bl;
    }

    public int getInitIndex() {
        return this.\u010c;
    }

    public void setInitIndex(int n2) {
        this.\u010c = n2;
    }

    public int getCurrentDockSide() {
        return this.\u010a;
    }

    public void setCurrentDockSide(int n2) {
        this.\u010a = n2;
    }

    public Rectangle getUndockedBounds() {
        return this.\u0107;
    }

    public void setUndockedBounds(Rectangle rectangle) {
        this.\u0107 = rectangle;
    }

    public int getAutohideWidth() {
        return this.\u0111;
    }

    public void setAutohideWidth(int n2) {
        this.\u0111 = n2;
    }

    public int getAutohideHeight() {
        return this.\u0115;
    }

    public void setAutohideHeight(int n2) {
        this.\u0115 = n2;
    }

    public int getDockedWidth() {
        return this.\u0101;
    }

    public void setDockedWidth(int n2) {
        this.\u0101 = n2;
    }

    public int getDockedHeight() {
        return this.\u0116;
    }

    public void setDockedHeight(int n2) {
        this.\u0116 = n2;
    }

    public J getHiddenPreviousState() {
        return this.\u0105;
    }

    public void setHiddenPreviousState(J j2) {
        this.\u0105 = j2;
    }

    public J getClosePreviousState() {
        return this.\u0118;
    }

    public void setClosePreviousState(J j2) {
        this.\u0118 = j2;
    }

    public J getDockPreviousState() {
        return this.\u010d;
    }

    public void setDockPreviousState(J j2) {
        this.\u010d = j2;
    }

    public J getFloatPreviousState() {
        return this.\u0102;
    }

    public void setFloatPreviousState(J j2) {
        this.\u0102 = j2;
    }

    public J getAutohidePreviousState() {
        return this.\u0114;
    }

    public void setAutohidePreviousState(J j2) {
        this.\u0114 = j2;
    }

    public static String getDockSideName(int n2) {
        return SIDE_NAMES[(int)(Math.log(n2) / Math.log(2.0))];
    }

    public static String getStateName(int n2) {
        return STATE_NAMES[n2];
    }

    public int getDockID() {
        return this.\u0103;
    }

    public void setDockID(DockingManager dockingManager, int n2) {
        this.\u0103 = n2;
        if (dockingManager != null) {
            G.\u0102(dockingManager).\u0101(this.\u0103);
        }
    }

    public void resetDockID(DockingManager dockingManager) {
        int n2 = G.\u0102(dockingManager).\u0104(this.getDockID());
        this.setDockID(dockingManager, n2);
    }

    public int getCanMode() {
        return this.\u0113;
    }

    public void setCanMode(int n2) {
        this.\u0113 = n2;
    }

    public boolean isDockable() {
        return (this.getCanMode() & 4) != 0;
    }

    public void setDockable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 4);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFB);
        }
    }

    public boolean isHidable() {
        return (this.getCanMode() & 8) != 0;
    }

    public void setHidable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 8);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFF7);
        }
    }

    public boolean isAutohidable() {
        return (this.getCanMode() & 2) != 0;
    }

    public void setAutohidable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 2);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFD);
        }
    }

    public boolean isFloatable() {
        return (this.getCanMode() & 1) != 0;
    }

    public void setFloatable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 1);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFE);
        }
    }

    public J getAvailablePreviousState() {
        return this.\u0108;
    }

    public void setAvailablePreviousState(J j2) {
        this.\u0108 = j2;
    }

    public boolean isAvailable() {
        return this.\u0106;
    }

    public void setAvailable(boolean bl) {
        this.\u0106 = bl;
    }

    public J getMaximizedPreviousState() {
        return this.\u010f;
    }

    public void setMaximizedPreviousState(J j2) {
        this.\u010f = j2;
    }

    public Object clone() throws CloneNotSupportedException {
        DockContext dockContext = new DockContext();
        dockContext.setInitSide(this.getInitSide());
        dockContext.setInitMode(this.getInitMode());
        dockContext.setInitIndex(this.getInitIndex());
        dockContext.setUndockedBounds(this.getUndockedBounds());
        dockContext.setAutohideHeight(this.getAutohideHeight());
        dockContext.setAutohideWidth(this.getAutohideWidth());
        dockContext.setCanMode(this.getCanMode());
        dockContext.setCurrentDockSide(this.getCurrentDockSide());
        dockContext.setCurrentMode(this.getCurrentMode());
        dockContext.setDockedHeight(this.getDockedHeight());
        dockContext.setDockedWidth(this.getDockedWidth());
        return dockContext;
    }

    int \u0103() {
        return this.\u0117;
    }

    void \u0101(int n2) {
        this.\u0117 = n2;
    }

    int \u0102() {
        return this.\u0112;
    }

    void \u0102(int n2) {
        this.\u0112 = n2;
    }

    Rectangle \u0101() {
        return this.\u0104;
    }

    void \u0101(Rectangle rectangle) {
        this.\u0104 = rectangle;
    }
}

