/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.A;
import com.jidesoft.diff.AbstractDiffPane;
import com.jidesoft.diff.C;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffMargin;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.DifferenceList;
import com.jidesoft.diff.F;
import com.jidesoft.margin.AbstractMargin;
import com.jidesoft.margin.MarginArea;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.marker.MarkerArea;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public abstract class BasicDiffPane<T>
extends AbstractDiffPane {
    protected final int GAP_TITLE_PANE = 2;
    protected JComponent _fromComponent;
    protected JComponent _toComponent;
    protected JScrollPane _fromScrollPane;
    protected JScrollPane _toScrollPane;
    protected DiffDivider _fromToDivider;
    protected AbstractMargin _fromDiffMargin;
    protected AbstractMargin _toDiffMargin;
    protected JComponent _fromTitle;
    protected JComponent _toTitle;
    protected MarginArea _fromMarginArea;
    protected MarginArea _toMarginArea;
    protected AbstractMargin _fromDiffLineNumberMargin;
    protected AbstractMargin _toDiffLineNumberMargin;
    protected MarkerArea _fromMarkerArea;
    protected MarkerArea _toMarkerArea;
    protected RowMarginSupport _fromRowMarginSupport;
    protected RowMarginSupport _toRowMarginSupport;
    protected List<Difference> _differences;
    private boolean \u011f = false;
    private boolean \u0125 = false;
    private boolean \u0122 = true;
    protected static final int POSITION_BEFORE_FIRST = 0;
    protected static final int POSITION_ON_FIRST = 1;
    protected static final int POSITION_IN_THE_MIDDLE = 2;
    protected static final int POSITION_ON_LAST = 3;
    protected static final int POSITION_AFTER_LAST = 4;
    protected static final int POSITION_ON_FIRST_AND_LAST = 5;
    private boolean \u011e = false;
    private boolean \u0121 = false;
    private AdjustmentListener \u0120;
    private AdjustmentListener \u011d;
    private AdjustmentListener \u0124;
    private AdjustmentListener \u0123;
    protected boolean _diffed = false;

    public BasicDiffPane() {
        super("", "");
    }

    public BasicDiffPane(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public void flip() {
        String string = this.getFromTitle();
        String string2 = this.getToTitle();
        this.\u0103();
        if (this._diffed) {
            List<Difference> list = this.getDifferences();
            ArrayList arrayList = list instanceof DifferenceList ? new DifferenceList() : new ArrayList();
            if (list != null) {
                for (Difference difference : list) {
                    List<Difference> list2;
                    if (difference == null) continue;
                    Difference difference2 = new Difference(difference.getAddedStart(), difference.getAddedEnd(), difference.getDeletedStart(), difference.getDeletedEnd());
                    arrayList.add(difference2);
                    if (!(list instanceof DifferenceList) || !(arrayList instanceof DifferenceList) || (list2 = ((DifferenceList)list).getLinesDiff(difference)) == null) continue;
                    ArrayList<Difference> arrayList2 = new ArrayList<Difference>();
                    for (Difference difference3 : list2) {
                        if (difference3 == null) continue;
                        arrayList2.add(new Difference(difference3.getAddedStart(), difference3.getAddedEnd(), difference3.getDeletedStart(), difference3.getDeletedEnd()));
                    }
                    ((DifferenceList)arrayList).addLinesDiff(difference2, arrayList2);
                }
                this.differencesUpdated(arrayList);
            }
        }
        this.setFromTitle(string2);
        this.setToTitle(string);
        JideSwingUtilities.invalidateRecursively(this);
    }

    void \u0103() {
        super.flip();
    }

    protected AbstractMargin createDiffMargin(RowMarginSupport rowMarginSupport, boolean bl) {
        DiffMargin diffMargin = new DiffMargin(rowMarginSupport, bl);
        diffMargin.\u0101(!this.isReadOnly());
        return diffMargin;
    }

    @Override
    public JComponent createPane(Object object, int n2) {
        if (n2 == 0) {
            this._fromComponent = this.createComponent(object, n2);
            this._fromScrollPane = new JScrollPane(this._fromComponent);
            this._fromRowMarginSupport = this.createRowMarginSupport(this._fromComponent, this._fromScrollPane);
            this._fromDiffMargin = this.createDiffMargin(this._fromRowMarginSupport, true);
            this._fromDiffLineNumberMargin = new C(this._fromRowMarginSupport);
            this._fromMarkerArea = new F(this.createMarkerSupport(this._fromComponent));
            ((F)this._fromMarkerArea).\u0107(this.getChangedColor());
            ((F)this._fromMarkerArea).\u0108(this.getInsertedColor());
            ((F)this._fromMarkerArea).\u0106(this.getDeletedColor());
            this._fromMarginArea = new MarginArea();
            this._fromMarginArea.addMarginComponent(this._fromDiffLineNumberMargin);
            this._fromMarginArea.addMarginComponent(this._fromDiffMargin);
            this.customizePane(this._fromComponent, 0);
            JPanel jPanel = new JPanel(new BorderLayout(1, 1));
            jPanel.add((Component)this._fromMarkerArea, "Before");
            jPanel.add(this._fromScrollPane);
            jPanel.add((Component)this._fromMarginArea, "After");
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add(jPanel);
            this._fromTitle = this.createFromTitle();
            jPanel2.add((Component)this._fromTitle, "First");
            return jPanel2;
        }
        this._toComponent = this.createComponent(object, n2);
        this._toScrollPane = new JScrollPane(this._toComponent);
        this._toRowMarginSupport = this.createRowMarginSupport(this._toComponent, this._toScrollPane);
        this._toDiffMargin = this.createDiffMargin(this._toRowMarginSupport, false);
        this._toDiffLineNumberMargin = new C(this._toRowMarginSupport);
        this._toMarkerArea = new F(this.createMarkerSupport(this._toComponent));
        ((F)this._toMarkerArea).\u0107(this.getChangedColor());
        ((F)this._toMarkerArea).\u0108(this.getInsertedColor());
        ((F)this._toMarkerArea).\u0106(this.getDeletedColor());
        this._toMarginArea = new MarginArea();
        this._toMarginArea.removeAll();
        this._toMarginArea.addMarginComponent(this._toDiffLineNumberMargin);
        this._toMarginArea.addMarginComponent(this._toDiffMargin);
        this.customizePane(this._toComponent, 1);
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add((Component)this._toMarginArea, "Before");
        jPanel.add(this._toScrollPane);
        jPanel.add((Component)this._toMarkerArea, "After");
        JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
        jPanel3.add(jPanel);
        this._toTitle = this.createToTitle();
        jPanel3.add((Component)this._toTitle, "First");
        return jPanel3;
    }

    protected abstract MarkerSupport createMarkerSupport(JComponent var1);

    protected abstract RowMarginSupport createRowMarginSupport(JComponent var1, JScrollPane var2);

    @Override
    public DiffDivider createDivider(int n2) {
        return new DiffDivider();
    }

    @Override
    protected void customizeDivider(DiffDivider diffDivider, int n2) {
        this._fromToDivider = diffDivider;
        this._fromToDivider.setChangedColor(this.getChangedColor());
        this._fromToDivider.setInsertedColor(this.getInsertedColor());
        this._fromToDivider.setDeletedColor(this.getDeletedColor());
        this._fromToDivider.setFirstConverter(this.createFromRowConverter());
        this._fromToDivider.setSecondConverter(this.createToRowConverter());
        this._fromToDivider.addPropertyChangeListener("selectedDifference", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (BasicDiffPane.this._fromComponent != null) {
                    BasicDiffPane.this._fromComponent.repaint();
                }
                if (BasicDiffPane.this._toComponent != null) {
                    BasicDiffPane.this._toComponent.repaint();
                }
            }
        });
    }

    @Override
    public void setChangedColor(Color color) {
        super.setChangedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setChangedColor(this.getChangedColor());
        }
        if (this._fromMarkerArea instanceof F) {
            ((F)this._fromMarkerArea).\u0107(this.getChangedColor());
        } else if (this._fromMarkerArea instanceof A) {
            ((A)this._fromMarkerArea).\u0103(this.getChangedColor());
        }
        if (this._toMarkerArea instanceof F) {
            ((F)this._toMarkerArea).\u0107(this.getChangedColor());
        } else if (this._toMarkerArea instanceof A) {
            ((A)this._toMarkerArea).\u0103(this.getChangedColor());
        }
    }

    @Override
    public void setInsertedColor(Color color) {
        super.setInsertedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setInsertedColor(this.getInsertedColor());
        }
        if (this._fromMarkerArea instanceof F) {
            ((F)this._fromMarkerArea).\u0108(this.getInsertedColor());
        } else if (this._fromMarkerArea instanceof A) {
            ((A)this._fromMarkerArea).\u0104(this.getInsertedColor());
        }
        if (this._toMarkerArea instanceof F) {
            ((F)this._toMarkerArea).\u0108(this.getInsertedColor());
        } else if (this._toMarkerArea instanceof A) {
            ((A)this._toMarkerArea).\u0104(this.getInsertedColor());
        }
    }

    @Override
    public void setDeletedColor(Color color) {
        super.setDeletedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setDeletedColor(this.getDeletedColor());
        }
        if (this._fromMarkerArea instanceof F) {
            ((F)this._fromMarkerArea).\u0106(this.getDeletedColor());
        } else if (this._fromMarkerArea instanceof A) {
            ((A)this._fromMarkerArea).\u0102(this.getDeletedColor());
        }
        if (this._toMarkerArea instanceof F) {
            ((F)this._toMarkerArea).\u0106(this.getDeletedColor());
        } else if (this._toMarkerArea instanceof A) {
            ((A)this._toMarkerArea).\u0102(this.getDeletedColor());
        }
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n2) {
        super.adjustDividerOffset(diffDivider, n2);
        diffDivider.adjustSecondVerticalOffset(-1, 2 + this._toTitle.getPreferredSize().height);
        diffDivider.adjustFirstVerticalOffset(-1, 2 + this._fromTitle.getPreferredSize().height);
    }

    protected JComponent createFromTitle() {
        return new JLabel();
    }

    protected JComponent createToTitle() {
        return new JLabel();
    }

    public String getFromTitle() {
        if (this._fromTitle instanceof JLabel) {
            return ((JLabel)this._fromTitle).getText();
        }
        return null;
    }

    public void setFromTitle(String string) {
        String string2;
        if (this._fromTitle instanceof JLabel && !JideSwingUtilities.equals(string2 = this.getFromTitle(), string)) {
            ((JLabel)this._fromTitle).setText(string);
            this.adjustDividerOffset(this._fromToDivider, 0);
        }
    }

    public String getToTitle() {
        if (this._toTitle instanceof JLabel) {
            return ((JLabel)this._toTitle).getText();
        }
        return null;
    }

    public void setToTitle(String string) {
        String string2;
        if (this._toTitle instanceof JLabel && !JideSwingUtilities.equals(string2 = this.getToTitle(), string)) {
            ((JLabel)this._toTitle).setText(string);
            this.adjustDividerOffset(this._fromToDivider, 0);
        }
    }

    public abstract JComponent createComponent(Object var1, int var2);

    protected DiffDivider.RowConverter createFromRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n2) {
                return BasicDiffPane.this._fromRowMarginSupport.rowToPosition(n2);
            }
        };
    }

    public abstract T[] getFromItems();

    public abstract T[] getToItems();

    public JComponent getFromComponent() {
        return this._fromComponent;
    }

    public JComponent getToComponent() {
        return this._toComponent;
    }

    protected DiffDivider.RowConverter createToRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n2) {
                return BasicDiffPane.this._toRowMarginSupport.rowToPosition(n2);
            }
        };
    }

    protected void synchronizeViewport(DiffDivider diffDivider, boolean bl, boolean bl2) {
        RowMarginSupport rowMarginSupport = (RowMarginSupport)this._fromDiffLineNumberMargin.getMarginSupport();
        RowMarginSupport rowMarginSupport2 = (RowMarginSupport)this._toDiffLineNumberMargin.getMarginSupport();
        JViewport jViewport = this._toScrollPane.getViewport();
        JViewport jViewport2 = this._fromScrollPane.getViewport();
        if (bl2) {
            if (bl) {
                Point point = jViewport2.getViewPosition();
                if (diffDivider.getDifferences() != null) {
                    int n2 = rowMarginSupport.positionToRow(0);
                    int n3 = rowMarginSupport.positionToRow(jViewport2.getViewSize().height) / rowMarginSupport.getRowHeight(0);
                    int n4 = diffDivider.getSecondMatchLine(n3, n2);
                    point.y = jViewport.getViewPosition().y + rowMarginSupport2.rowToPosition(n4) - rowMarginSupport.rowToPosition(n2);
                }
                point.y = Math.max(0, Math.min(point.y, (int)(jViewport.getView().getSize().getHeight() - jViewport.getSize().getHeight())));
                jViewport.setViewPosition(point);
            } else {
                Point point = jViewport.getViewPosition();
                if (diffDivider.getDifferences() != null) {
                    int n5 = rowMarginSupport2.positionToRow(0);
                    int n6 = rowMarginSupport2.positionToRow(jViewport.getViewSize().height) / rowMarginSupport.getRowHeight(0);
                    int n7 = diffDivider.getFirstMatchLine(n6, n5);
                    point.y = jViewport2.getViewPosition().y + rowMarginSupport.rowToPosition(n7) - rowMarginSupport2.rowToPosition(n5);
                }
                point.y = Math.max(0, Math.min(point.y, (int)(jViewport2.getView().getSize().getHeight() - jViewport2.getSize().getHeight())));
                jViewport2.setViewPosition(point);
            }
        } else if (bl) {
            Point point = jViewport2.getViewPosition();
            point.y = jViewport.getViewPosition().y;
            jViewport.setViewPosition(point);
        } else {
            Point point = jViewport.getViewPosition();
            point.y = jViewport2.getViewPosition().y;
            jViewport2.setViewPosition(point);
        }
    }

    Difference \u0103(int n2, int n3) {
        return this.\u0101(n2, n3, false);
    }

    Difference \u0101(int n2, int n3, boolean bl) {
        if (this._differences != null && this._differences.size() > 0 && n3 >= 0) {
            int n4;
            Difference difference = this._differences.get(0);
            Difference difference2 = this._differences.get(this._differences.size() - 1);
            int n5 = n2 == 0 ? difference.getDeletedStart() : difference.getAddedStart();
            int n6 = n2 == 0 ? difference2.getDeletedStart() : difference2.getAddedStart();
            int n7 = n4 = n2 == 0 ? difference2.getDeletedEnd() : difference2.getAddedEnd();
            if (n3 >= n5 && (n3 <= n6 || n4 >= 0 && n3 <= n4)) {
                int n8 = 0;
                int n9 = this._differences.size();
                int n10 = n9 / 2;
                while (n8 < n9) {
                    int n11;
                    Difference difference3 = this._differences.get(n10);
                    int n12 = n2 == 0 ? difference3.getDeletedStart() : difference3.getAddedStart();
                    int n13 = n11 = n2 == 0 ? difference3.getDeletedEnd() : difference3.getAddedEnd();
                    if (n3 == n12 || n11 >= 0 && n3 >= n12 && n3 <= n11) {
                        Difference difference42;
                        int n14;
                        if (!bl) {
                            return difference3;
                        }
                        if (n2 == 0 && difference3.getDeletedEnd() >= 0 || n2 != 0 && difference3.getAddedEnd() >= 0) {
                            return difference3;
                        }
                        ArrayList<Difference> arrayList = new ArrayList<Difference>();
                        for (n14 = n10 + 1; n14 < this._differences.size() && (difference42 = this._differences.get(n14)) != null && n12 == (n2 == 0 ? difference42.getDeletedStart() : difference42.getAddedStart()); ++n14) {
                            arrayList.add(difference42);
                        }
                        for (n14 = n10 - 1; n14 >= 0 && (difference42 = this._differences.get(n14)) != null && n12 == (n2 == 0 ? difference42.getDeletedStart() : difference42.getAddedStart()); --n14) {
                            arrayList.add(difference42);
                        }
                        if (arrayList.size() > 0) {
                            for (Difference difference42 : arrayList) {
                                if ((n2 != 0 || difference42.getDeletedEnd() < 0) && (n2 == 0 || difference42.getAddedEnd() < 0)) continue;
                                return difference42;
                            }
                        }
                        return difference3;
                    }
                    if (n3 > n12) {
                        n8 = n10 + 1;
                    } else {
                        n9 = n10;
                    }
                    n10 = n8 + (n9 - n8) / 2;
                }
            }
        }
        return null;
    }

    void \u0102(int n2) {
        int n3 = this.getSelectedIndex(n2);
        this._fromToDivider.setSelectedDifference(this.\u0103(n2, n3));
        this.updateActions(n2);
    }

    @Override
    protected void updateActions(int n2) {
        if (this._differences == null || this._differences.size() == 0) {
            ((Action)this._actions.get("first")).setEnabled(false);
            ((Action)this._actions.get("next")).setEnabled(false);
            ((Action)this._actions.get("previous")).setEnabled(false);
            ((Action)this._actions.get("last")).setEnabled(false);
        } else if (n2 == -1) {
            ((Action)this._actions.get("first")).setEnabled(true);
            ((Action)this._actions.get("next")).setEnabled(true);
            ((Action)this._actions.get("previous")).setEnabled(true);
            ((Action)this._actions.get("last")).setEnabled(true);
        } else {
            int n3;
            Difference difference = this._fromToDivider.getSelectedDifference();
            int n4 = this._differences.indexOf(difference);
            if (n4 < 0) {
                Difference difference2 = this._differences.get(0);
                Difference difference3 = this._differences.get(this._differences.size() - 1);
                int n5 = n2 == 0 ? difference2.getDeletedStart() : difference2.getAddedStart();
                int n6 = n2 == 0 ? difference3.getDeletedStart() : difference3.getAddedStart();
                n3 = this.getCaretPosition(n2, n5, n6);
            } else {
                n3 = n4 == 0 ? (this._differences.size() > 1 ? 1 : 5) : (n4 == this._differences.size() - 1 ? 3 : 2);
            }
            if (n3 == 0) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(true);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(true);
            } else if (n3 == 1) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(this._differences.size() != 0);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(this._differences.size() != 0);
            } else if (n3 == 5) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(false);
            } else if (n3 == 2) {
                ((Action)this._actions.get("first")).setEnabled(true);
                ((Action)this._actions.get("next")).setEnabled(true);
                ((Action)this._actions.get("previous")).setEnabled(true);
                ((Action)this._actions.get("last")).setEnabled(true);
            } else if (n3 == 3) {
                ((Action)this._actions.get("first")).setEnabled(this._differences.size() != 0);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(this._differences.size() != 0);
                ((Action)this._actions.get("last")).setEnabled(false);
            } else if (n3 == 4) {
                ((Action)this._actions.get("first")).setEnabled(true);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(true);
                ((Action)this._actions.get("last")).setEnabled(false);
            }
        }
    }

    protected abstract int getSelectedIndex(int var1);

    protected int getCaretPosition(int n2, int n3, int n4) {
        int n5 = this.getSelectedIndex(n2);
        if (n5 < n3) {
            return 0;
        }
        if (n5 == n3) {
            return n3 != n4 ? 1 : 5;
        }
        if (n5 > n3 && n5 < n4) {
            return 2;
        }
        if (n5 == n4) {
            return 3;
        }
        if (n5 > n4) {
            return 4;
        }
        return -1;
    }

    @Override
    public void firstChange() {
        super.firstChange();
        if (this._differences != null && this._differences.size() > 0) {
            if (this._toComponent.hasFocus()) {
                int n2 = this._differences.get(0).getAddedStart();
                int n3 = this._differences.get(0).getAddedEnd();
                this.scrollTo(false, n2, n3);
                this._fromToDivider.setSelectedDifference(this._differences.get(0));
            } else {
                if (!this._fromComponent.hasFocus()) {
                    this._fromComponent.requestFocusInWindow();
                }
                int n4 = this._differences.get(0).getDeletedStart();
                int n5 = this._differences.get(0).getDeletedEnd();
                this.scrollTo(true, n4, n5);
                this._fromToDivider.setSelectedDifference(this._differences.get(0));
            }
            this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
        }
    }

    @Override
    public void previousChange() {
        super.previousChange();
        if (this._toComponent.hasFocus()) {
            int n2;
            int n3;
            int n4 = this._fromToDivider.getSelectedDifference() == null ? ((n3 = BasicDiffPane.binarySearchAdded(this._differences, n2 = this.getSelectedIndex(1))) < 0 ? Math.abs(n3) - 2 : Math.abs(n3) - 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) - 1;
            if (n4 >= 0 && n4 < this._differences.size()) {
                Difference difference = this._differences.get(n4);
                n3 = difference.getAddedStart();
                int n5 = difference.getAddedEnd();
                this.scrollTo(false, n3, n5);
                this._fromToDivider.setSelectedDifference(difference);
            }
        } else {
            int n6;
            int n7;
            int n8;
            if (!this._fromComponent.hasFocus()) {
                this._fromComponent.requestFocusInWindow();
            }
            if ((n8 = this._fromToDivider.getSelectedDifference() == null ? ((n7 = BasicDiffPane.binarySearchDeleted(this._differences, n6 = this.getSelectedIndex(0))) < 0 ? Math.abs(n7) - 2 : Math.abs(n7) - 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) - 1) >= 0 && n8 < this._differences.size()) {
                Difference difference = this._differences.get(n8);
                n7 = difference.getDeletedStart();
                int n9 = difference.getDeletedEnd();
                this.scrollTo(true, n7, n9);
                this._fromToDivider.setSelectedDifference(difference);
            }
        }
        this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
    }

    @Override
    public void nextChange() {
        super.nextChange();
        if (this._toComponent.hasFocus()) {
            int n2;
            int n3;
            int n4 = this._fromToDivider.getSelectedDifference() == null ? ((n3 = BasicDiffPane.binarySearchAdded(this._differences, n2 = this.getSelectedIndex(1))) < 0 ? Math.abs(n3) - 1 : Math.abs(n3) + 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) + 1;
            if (n4 >= 0 && n4 < this._differences.size()) {
                Difference difference = this._differences.get(n4);
                n3 = difference.getAddedStart();
                int n5 = difference.getAddedEnd();
                this.scrollTo(false, n3, n5);
                this._fromToDivider.setSelectedDifference(difference);
            }
        } else {
            int n6;
            int n7;
            int n8;
            if (!this._fromComponent.hasFocus()) {
                this._fromComponent.requestFocusInWindow();
            }
            if ((n8 = this._fromToDivider.getSelectedDifference() == null ? ((n7 = BasicDiffPane.binarySearchDeleted(this._differences, n6 = this.getSelectedIndex(0))) < 0 ? Math.abs(n7) - 1 : Math.abs(n7) + 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) + 1) >= 0 && n8 < this._differences.size()) {
                Difference difference = this._differences.get(n8);
                n7 = difference.getDeletedStart();
                int n9 = difference.getDeletedEnd();
                this.scrollTo(true, n7, n9);
                this._fromToDivider.setSelectedDifference(difference);
            }
        }
        this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
    }

    @Override
    public void lastChange() {
        super.lastChange();
        if (this._differences != null && this._differences.size() > 0) {
            if (this._toComponent.hasFocus()) {
                int n2 = this._differences.get(this._differences.size() - 1).getAddedStart();
                int n3 = this._differences.get(this._differences.size() - 1).getAddedEnd();
                this.scrollTo(false, n2, n3);
                this._fromToDivider.setSelectedDifference(this._differences.get(this._differences.size() - 1));
            } else {
                if (!this._fromComponent.hasFocus()) {
                    this._fromComponent.requestFocusInWindow();
                }
                int n4 = this._differences.get(this._differences.size() - 1).getDeletedStart();
                int n5 = this._differences.get(this._differences.size() - 1).getDeletedEnd();
                this.scrollTo(true, n4, n5);
                this._fromToDivider.setSelectedDifference(this._differences.get(this._differences.size() - 1));
            }
            this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
        }
    }

    protected void scrollTo(boolean bl, int n2, int n3) {
        RowMarginSupport rowMarginSupport = bl ? this._fromRowMarginSupport : this._toRowMarginSupport;
        rowMarginSupport.scrollTo(n2, (n3 >= 0 ? n3 : n2) + 10, this.isSelectOnNavigation());
        rowMarginSupport.scrollTo(n2, n2, this.isSelectOnNavigation());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this._fromScrollPane != null) {
            if (this.\u011d != null) {
                this._fromScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.\u011d);
            }
            if (this.\u0120 != null) {
                this._fromScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.\u0120);
            }
            this.\u011d = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this.\u011e) {
                        return;
                    }
                    BasicDiffPane.this.\u0121 = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, true, true);
                        BasicDiffPane.this._fromToDivider.repaint();
                        BasicDiffPane.this._toDiffMargin.repaint();
                        BasicDiffPane.this._toDiffLineNumberMargin.repaint();
                    }
                    finally {
                        BasicDiffPane.this.\u0121 = false;
                    }
                }
            };
            this._fromScrollPane.getVerticalScrollBar().addAdjustmentListener(this.\u011d);
            this.\u0120 = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this.\u011e) {
                        return;
                    }
                    BasicDiffPane.this.\u0121 = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, true, false);
                        BasicDiffPane.this._fromToDivider.repaint();
                        BasicDiffPane.this._fromDiffMargin.repaint();
                        BasicDiffPane.this._fromDiffLineNumberMargin.repaint();
                    }
                    finally {
                        BasicDiffPane.this.\u0121 = false;
                    }
                }
            };
            this._fromScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.\u0120);
        }
        if (this._toScrollPane != null) {
            if (this.\u0123 != null) {
                this._toScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.\u0123);
            }
            if (this.\u0124 != null) {
                this._toScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.\u0124);
            }
            this.\u0123 = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this.\u0121) {
                        return;
                    }
                    BasicDiffPane.this.\u011e = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, false, true);
                        BasicDiffPane.this._fromToDivider.repaint();
                        BasicDiffPane.this._fromDiffLineNumberMargin.repaint();
                        BasicDiffPane.this._fromDiffMargin.repaint();
                    }
                    finally {
                        BasicDiffPane.this.\u011e = false;
                    }
                }
            };
            this._toScrollPane.getVerticalScrollBar().addAdjustmentListener(this.\u0123);
            this.\u0124 = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this.\u0121) {
                        return;
                    }
                    BasicDiffPane.this.\u011e = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, false, false);
                        BasicDiffPane.this._fromToDivider.repaint();
                    }
                    finally {
                        BasicDiffPane.this.\u011e = false;
                    }
                }
            };
            this._toScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.\u0124);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._fromScrollPane != null) {
            if (this.\u011d != null) {
                this._fromScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.\u011d);
            }
            if (this.\u0120 != null) {
                this._fromScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.\u0120);
            }
        }
        if (this._toScrollPane != null) {
            if (this.\u0123 != null) {
                this._toScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.\u0123);
            }
            if (this.\u0124 != null) {
                this._toScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.\u0124);
            }
        }
        this.\u011d = null;
        this.\u0120 = null;
        this.\u0123 = null;
        this.\u0124 = null;
    }

    private String \u0105(int n2, int n3) {
        if (n3 == -1 || n2 == n3) {
            return MessageFormat.format(this.getResourceString("DiffPane.lineChanged"), n2 + 1);
        }
        return MessageFormat.format(this.getResourceString("DiffPane.linesChanged"), n2 + 1, n3 + 1);
    }

    public List<Difference> getDifferencesForDiff() {
        List<Difference> list = this.diff(this.getFromItems(), this.getToItems());
        if (list instanceof DifferenceList && this.isHighlightExactChange()) {
            for (Difference difference : list) {
                int n2 = difference.getAddedStart();
                int n3 = difference.getAddedEnd();
                int n4 = difference.getDeletedStart();
                int n5 = difference.getDeletedEnd();
                boolean bl = false;
                boolean bl2 = false;
                if (n5 == -1) {
                    bl = true;
                } else if (n3 == -1) {
                    bl2 = true;
                }
                if (bl2 || bl) continue;
                Diff<?> diff = n5 - n4 == 0 && n3 - n2 == 0 ? this.createLineDiff(n2, n4) : this.createLinesDiff(n4, n5, n2, n3);
                List<Difference> list2 = null;
                if (diff != null) {
                    list2 = diff.diff();
                    this.customizeLinesDiff(diff, list2);
                }
                ((DifferenceList)list).addLinesDiff(difference, list2);
            }
        }
        return list;
    }

    public List<Difference> getDifferences() {
        return this._differences;
    }

    protected List<Difference> diff(T[] TArray, T[] TArray2) {
        Diff<T> diff = this.createDiff(TArray, TArray2);
        return diff.diff();
    }

    protected Diff<T> createDiff(T[] TArray, T[] TArray2) {
        return new Diff<T>(TArray, TArray2);
    }

    public List<Difference> diff() {
        this._diffed = true;
        List<Difference> list = this.getDifferencesForDiff();
        this.differencesUpdated(list);
        return list;
    }

    public void runDiff() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BasicDiffPane.this.diff();
            }
        });
    }

    public void clearDiff() {
        this._diffed = false;
        this.differencesUpdated(null);
    }

    public boolean isHighlightExactChange() {
        return this.\u011f;
    }

    public boolean isReadOnly() {
        return this.\u0125;
    }

    public void setReadOnly(boolean bl) {
        this.\u0125 = bl;
        ((DiffMargin)this._fromDiffMargin).\u0101(!this.\u0125);
        ((DiffMargin)this._toDiffMargin).\u0101(!this.\u0125);
    }

    public void setHighlightExactChange(boolean bl) {
        if (this.\u011f != bl) {
            this.\u011f = bl;
            this.diff();
        }
    }

    protected void differencesUpdated(final List<Difference> list) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.\u0102(list);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicDiffPane.this.\u0102(list);
                }
            });
        }
    }

    private void \u0102(final List<Difference> list) {
        this._differences = list;
        this.updateActions(this._fromComponent.hasFocus() ? 0 : (this._toComponent.hasFocus() ? 1 : -1));
        this.\u0102();
        this._fromToDivider.setDifferences(list);
        HashMap<Integer, Difference> hashMap = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, Difference> hashMap2 = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        this.clearHighlights();
        this.startHighlights();
        if (list != null) {
            for (Difference difference : list) {
                int n2 = difference.getAddedStart();
                int n3 = difference.getAddedEnd();
                int n4 = difference.getDeletedStart();
                int n5 = difference.getDeletedEnd();
                if (n5 == -1) {
                    hashMap.put(n4, difference);
                } else {
                    hashMap.put(n4, difference);
                    hashSet.add(n5 + 1);
                }
                if (n3 == -1) {
                    hashMap2.put(n2, difference);
                } else {
                    hashMap2.put(n2, difference);
                    hashSet2.add(n3 + 1);
                }
                boolean bl = false;
                boolean bl2 = false;
                if (n5 == -1) {
                    bl = true;
                } else if (n3 == -1) {
                    bl2 = true;
                }
                Color color = bl ? this._insertedColor : (bl2 ? this._deletedColor : this._changedColor);
                Color color2 = Color.GRAY;
                String string = this.\u0105(n2, n3);
                if (bl2) {
                    this.highlightDeleted(n4, n5, n2, color, color2, string);
                    continue;
                }
                if (bl) {
                    this.highlightInserted(n4, n2, n3, color, color2, string);
                    continue;
                }
                if (this.isHighlightExactChange()) {
                    Diff<?> diff;
                    if (list instanceof DifferenceList) {
                        diff = ((DifferenceList)list).getLinesDiff(difference);
                        if (diff != null) {
                            this.highlightChangedExactly((List<Difference>)((Object)diff), n4, n5, n2, n3, color, color2, string);
                            continue;
                        }
                        this.highlightChanged(n4, n5, n2, n3, color, color2, string);
                        continue;
                    }
                    diff = n5 - n4 == 0 && n3 - n2 == 0 ? this.createLineDiff(n2, n4) : this.createLinesDiff(n4, n5, n2, n3);
                    if (diff != null) {
                        List<Difference> list2 = diff.diff();
                        if (Thread.currentThread().isInterrupted()) continue;
                        this.customizeLinesDiff(diff, list2);
                        this.highlightChangedExactly(list2, n4, n5, n2, n3, color, color2, string);
                        continue;
                    }
                    this.highlightChanged(n4, n5, n2, n3, color, color2, string);
                    continue;
                }
                this.highlightChanged(n4, n5, n2, n3, color, color2, string);
            }
        }
        this.endHighlights();
        ((DiffMargin)this._fromDiffMargin).\u0103(hashMap, hashSet);
        ((C)this._fromDiffLineNumberMargin).\u0102(hashMap, hashSet);
        ((DiffMargin)this._toDiffMargin).\u0103(hashMap2, hashSet2);
        ((C)this._toDiffLineNumberMargin).\u0102(hashMap2, hashSet2);
        ((DiffMargin)this._fromDiffMargin).\u0101(new DiffMargin.Handler(){

            @Override
            public void handle(Difference difference, int n2) {
                boolean bl = difference.getAddedEnd() == -1 ? BasicDiffPane.this.insert(difference.getAddedStart(), difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false) : BasicDiffPane.this.replace(difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                if (bl) {
                    List<Difference> list2 = BasicDiffPane.this.acceptDifference(list, difference);
                    BasicDiffPane.this.differencesUpdated(list2);
                }
            }
        });
        ((DiffMargin)this._toDiffMargin).\u0101(new DiffMargin.Handler(){

            @Override
            public void handle(Difference difference, int n2) {
                boolean bl;
                if (difference.getDeletedEnd() == -1 && difference.getAddedEnd() != -1 && (bl = BasicDiffPane.this.delete(difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, false))) {
                    List<Difference> list2 = BasicDiffPane.this.acceptDifference(list, difference);
                    BasicDiffPane.this.differencesUpdated(list2);
                }
            }
        });
        if (list != null && list.size() > 0) {
            this._fromMarkerArea.setMode(100);
            this._toMarkerArea.setMode(100);
        } else {
            this._fromMarkerArea.setMode(0);
            this._toMarkerArea.setMode(0);
        }
    }

    protected List<Difference> customizeLinesDiff(Diff diff, List<Difference> list) {
        return list;
    }

    protected static int binarySearchAdded(List<Difference> list, int n2) {
        int n3 = 0;
        int n4 = list.size() - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = n3 + n4 >>> 1;
            Difference difference = list.get(n6);
            int n7 = difference.getAddedStart() < n2 ? -1 : (n5 = difference.getAddedStart() > n2 ? 1 : 0);
            if (n5 < 0) {
                n3 = n6 + 1;
                continue;
            }
            if (n5 > 0) {
                n4 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n3 + 1);
    }

    protected static int binarySearchDeleted(List<Difference> list, int n2) {
        int n3 = 0;
        int n4 = list.size() - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = n3 + n4 >>> 1;
            Difference difference = list.get(n6);
            int n7 = difference.getDeletedStart() < n2 ? -1 : (n5 = difference.getDeletedStart() > n2 ? 1 : 0);
            if (n5 < 0) {
                n3 = n6 + 1;
                continue;
            }
            if (n5 > 0) {
                n4 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n3 + 1);
    }

    protected int getToMatchingRow(int n2) {
        int n3 = n2;
        if (this._differences != null) {
            for (Difference difference : this._differences) {
                if (n2 < difference.getDeletedStart()) break;
                n3 -= this.\u0104(difference.getDeletedStart(), difference.getDeletedEnd()) - this.\u0104(difference.getAddedStart(), difference.getAddedEnd());
            }
            return Math.max(0, n3);
        }
        return n2;
    }

    protected int getFromMatchingRow(int n2) {
        int n3 = n2;
        if (this._differences != null) {
            for (Difference difference : this._differences) {
                if (n2 < difference.getAddedStart()) break;
                n3 -= this.\u0104(difference.getAddedStart(), difference.getAddedEnd()) - this.\u0104(difference.getDeletedStart(), difference.getDeletedEnd());
            }
            return Math.max(0, n3);
        }
        return n2;
    }

    private int \u0104(int n2, int n3) {
        return n3 == -1 ? 0 : n3 - n2 + 1;
    }

    public void clearHighlights() {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().clearMarkers();
        this._toMarkerArea.getMarkerSupport().getMarkerModel().clearMarkers();
    }

    public void startHighlights() {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(true);
        this._toMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(true);
    }

    public void endHighlights() {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(false);
        this._toMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(false);
        this._fromComponent.repaint();
        this._toComponent.repaint();
    }

    @Deprecated
    public Diff<?> createLineDiff(int n2, int n3) {
        return this.createLinesDiff(n3, n3, n2, n2);
    }

    protected Diff<?> createLinesDiff(int n2, int n3, int n4, int n5) {
        return null;
    }

    public void highlightChangedExactly(List<Difference> list, int n2, int n3, int n4, int n5, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n2, n3, 124, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n4, n5, 124, string);
    }

    public void highlightChanged(int n2, int n3, int n4, int n5, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n2, n3, 124, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n4, n5, 124, string);
    }

    public void highlightInserted(int n2, int n3, int n4, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n2, n2, 126, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n3, n4, 125, string);
    }

    public void highlightDeleted(int n2, int n3, int n4, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n2, n3, 125, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n4, n4, 126, string);
    }

    protected List<Difference> acceptDifference(List<Difference> list, Difference difference) {
        boolean bl = false;
        int n2 = 0;
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference2 : list) {
            if (difference2.getDeletedStart() == difference.getDeletedStart() && difference2.getDeletedEnd() == difference.getDeletedEnd()) {
                bl = true;
                if (difference.getAddedEnd() == -1) {
                    n2 = -(difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                    continue;
                }
                if (difference.getDeletedEnd() == -1) {
                    n2 = difference.getAddedEnd() - difference.getAddedStart() + 1;
                    continue;
                }
                n2 = difference.getAddedEnd() - difference.getAddedStart() + 1 - (difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                continue;
            }
            if (bl && n2 != 0) {
                difference2.adjustAdded(-n2);
            }
            arrayList.add(difference2);
        }
        return arrayList;
    }

    private void \u0102() {
        if (this._differences == null || this._differences.size() == 0) {
            this.setMessage(this.getResourceString("DiffPane.noChange"));
        } else if (this._differences.size() == 1) {
            this.setMessage(this.getResourceString("DiffPane.oneChange"));
        } else {
            this.setMessage(MessageFormat.format(this.getResourceString("DiffPane.hasChanges"), this._differences.size()));
        }
    }

    public abstract boolean delete(int var1, int var2, boolean var3);

    public abstract boolean insert(int var1, int var2, int var3, boolean var4);

    public boolean replace(int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2 = this.delete(n2, n3, false);
        if (bl2) {
            bl2 = this.insert(n2, n4, n5, false);
        }
        if (bl2 && bl && this._diffed) {
            this.runDiff();
        }
        return bl2;
    }

    public boolean isSelectOnNavigation() {
        return this.\u0122;
    }

    public void setSelectOnNavigation(boolean bl) {
        this.\u0122 = bl;
    }
}

