/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.AbstractComboBoxSearchable;
import com.jidesoft.combobox.TreeComboBox;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeComboBoxSearchable
extends AbstractComboBoxSearchable
implements TreeModelListener {
    private boolean \u0121 = false;
    private transient List<TreePath> \u0120;

    public TreeComboBoxSearchable(TreeComboBox treeComboBox) {
        super(treeComboBox);
        if (treeComboBox.getTreeModel() != null) {
            treeComboBox.getTreeModel().addTreeModelListener(this);
        }
        treeComboBox.addPropertyChangeListener("treeModel", this);
    }

    public boolean isRecursive() {
        return this.\u0121;
    }

    public void setRecursive(boolean bl) {
        this.\u0121 = bl;
        this.resetTreePathes();
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof TreeComboBox && ((TreeComboBox)this._component).getTreeModel() != null) {
            ((TreeComboBox)this._component).getTreeModel().removeTreeModelListener(this);
        }
        this._component.removePropertyChangeListener("treeModel", this);
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl) {
        JTree jTree = ((TreeComboBox)this._component).getTree();
        if (jTree == null) {
            return;
        }
        if (this.isShowPopupDuringSearching()) {
            try {
                if (!((AbstractComboBox)this._component).isPopupVisible()) {
                    ((AbstractComboBox)this._component).showPopup();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        if (!this.isRecursive()) {
            if (bl) {
                jTree.addSelectionInterval(n2, n2);
            } else {
                jTree.setSelectionRow(n2);
            }
            jTree.scrollRowToVisible(n2);
        } else {
            Object object = this.getElementAt(n2);
            if (object instanceof TreePath) {
                TreePath treePath = (TreePath)object;
                if (bl) {
                    jTree.addSelectionPath(treePath);
                } else {
                    jTree.setSelectionPath(treePath);
                }
                jTree.scrollPathToVisible(treePath);
            }
        }
        if (((AbstractComboBox)this._component).getPopupLocation() == 1) {
            this.setPopupLocation(3);
        } else {
            this.setPopupLocation(1);
        }
    }

    @Override
    protected int getSelectedIndex() {
        JTree jTree = ((TreeComboBox)this._component).getTree();
        if (jTree == null) {
            return -1;
        }
        if (!this.isRecursive()) {
            int[] nArray = jTree.getSelectionRows();
            return nArray != null && nArray.length != 0 ? nArray[0] : -1;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            return this.getTreePathes().indexOf(treePathArray[0]);
        }
        return -1;
    }

    @Override
    protected Object getElementAt(int n2) {
        if (n2 == -1) {
            return null;
        }
        if (!this.isRecursive()) {
            JTree jTree = ((TreeComboBox)this._component).getTree();
            if (jTree == null) {
                return null;
            }
            return jTree.getPathForRow(n2);
        }
        return this.getTreePathes().get(n2);
    }

    @Override
    protected int getElementCount() {
        if (!this.isRecursive()) {
            JTree jTree = ((TreeComboBox)this._component).getTree();
            if (jTree == null) {
                return 0;
            }
            return jTree.getRowCount();
        }
        return this.getTreePathes().size();
    }

    protected void populateTreePaths() {
        this.\u0120 = new ArrayList<TreePath>();
        Object object = ((TreeComboBox)this._component).getTreeModel().getRoot();
        this.\u0101(object, new TreePath(object), ((TreeComboBox)this._component).getTreeModel());
    }

    private void \u0101(Object object, TreePath treePath, TreeModel treeModel) {
        this.\u0120.add(treePath);
        for (int i2 = 0; i2 < treeModel.getChildCount(object); ++i2) {
            Object object2 = treeModel.getChild(object, i2);
            this.\u0101(object2, treePath.pathByAddingChild(object2), treeModel);
        }
    }

    protected void resetTreePathes() {
        this.\u0120 = null;
    }

    protected List<TreePath> getTreePathes() {
        if (this.\u0120 == null) {
            this.populateTreePaths();
        }
        return this.\u0120;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object object2 = ((TreePath)object).getLastPathComponent();
            return object2.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("treeModel".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getOldValue()).removeTreeModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getNewValue()).addTreeModelListener(this);
            }
            this.resetTreePathes();
        }
    }
}

