/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;

public class SplineEngine {
    public static double splineEval(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d4 - d3;
        double d10 = (d2 - d3) / d9;
        double d11 = 1.0 - d10;
        return d11 * d11 * (d5 * (2.0 * d10 + 1.0) + d7 * d9 * d10) + d10 * d10 * (d6 * (3.0 - 2.0 * d10) - d8 * d9 * d11);
    }

    public static double[] computeSplineSlopes(int n2, double[] dArray, double[] dArray2) {
        int n3;
        if (n2 <= 0) {
            return new double[0];
        }
        int n4 = n2 + 1;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n4];
        double[] dArray7 = new double[n4];
        double[] dArray8 = new double[n4];
        for (n3 = 0; n3 < n2; ++n3) {
            dArray3[n3] = dArray[n3 + 1] - dArray[n3];
            dArray4[n3] = 1.0 / dArray3[n3];
            dArray5[n3] = 3.0 * (dArray2[n3 + 1] - dArray2[n3]) * dArray4[n3] * dArray4[n3];
        }
        dArray6[0] = 2.0 * dArray4[0];
        dArray7[0] = dArray5[0];
        for (n3 = 1; n3 <= n2; ++n3) {
            double d2 = dArray4[n3 - 1] / dArray6[n3 - 1];
            dArray6[n3] = (2.0 - d2) * dArray4[n3 - 1];
            dArray7[n3] = dArray5[n3 - 1] - d2 * dArray7[n3 - 1];
            if (n3 >= n2) continue;
            int n5 = n3;
            dArray6[n5] = dArray6[n5] + 2.0 * dArray4[n3];
            int n6 = n3;
            dArray7[n6] = dArray7[n6] + dArray5[n3];
        }
        dArray8[n2] = dArray7[n2] / dArray6[n2];
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            dArray8[n3] = (dArray7[n3] - dArray4[n3] * dArray8[n3 + 1]) / dArray6[n3];
        }
        return dArray8;
    }

    public static double[] lagrange(double[] dArray, double[] dArray2, double[][] dArray3) {
        assert (dArray.length == dArray2.length) : "x and y are parallel arrays and must have the same length!";
        int n2 = dArray.length;
        double[] dArray4 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray3[i2][0] = 1.0;
            double d2 = dArray2[i2];
            int n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i3 == i2) continue;
                dArray3[i2][n3 + 1] = dArray3[i2][n3];
                for (int i4 = n3; i4 > 0; --i4) {
                    dArray3[i2][i4] = dArray3[i2][i4 - 1] - dArray3[i2][i4] * dArray[i3];
                }
                double[] dArray5 = dArray3[i2];
                dArray5[0] = dArray5[0] * -dArray[i3];
                ++n3;
                d2 /= dArray[i2] - dArray[i3];
            }
            n3 = 0;
            while (n3 < n2) {
                double[] dArray6 = dArray3[i2];
                int n4 = n3++;
                dArray6[n4] = dArray6[n4] * d2;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + dArray3[i2][n3];
            }
        }
        return dArray4;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(SplineEngine.class.getName(), 4096);
        }
    }
}

