/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.annotation;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.annotation.AbstractLabel;
import com.jidesoft.chart.annotation.ChartAnnotation;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ChartLabel
extends AbstractLabel
implements Chartable,
ChartAnnotation,
Comparable<Chartable> {
    private static final int \u0119 = 200;
    private Positionable \u011b;
    private Positionable \u011a;
    private Point \u0116;
    private Color \u0118 = null;
    private Border \u0117 = null;

    public ChartLabel(double d2, double d3, String string) {
        this(new RealPosition(d2), new RealPosition(d3), string);
    }

    public ChartLabel(double d2, double d3) {
        this(new RealPosition(d2), new RealPosition(d3), null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2) {
        this(positionable, positionable2, null, null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2, String string) {
        this(positionable, positionable2, string, null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2, String string, Color color) {
        this(positionable, positionable2, string, color, null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2, String string, Color color, Font font) {
        super(string, color, font);
        this.\u011b = positionable;
        this.\u011a = positionable2;
        this.setZOrder(200);
    }

    @Override
    public Color getBackground() {
        return this.\u0118;
    }

    @Override
    public void setBackground(Color color) {
        this.\u0118 = color;
    }

    public Border getBorder() {
        return this.\u0117;
    }

    public void setBorder(Border border) {
        this.\u0117 = border;
    }

    @Override
    public Positionable getX() {
        return this.\u011b;
    }

    @Override
    public Positionable getY() {
        return this.\u011a;
    }

    public Point getPixelOffset() {
        return this.\u0116;
    }

    public void setPixelOffset(Point point) {
        this.\u0116 = point;
    }

    @Override
    public int compareTo(Chartable chartable) {
        if (chartable == null || this.\u011b == null) {
            return 0;
        }
        return this.\u011b.compareTo(chartable.getX());
    }

    @Override
    public void draw(Graphics2D graphics2D, Chart chart) {
        if (graphics2D != null) {
            int n2;
            Color color = this.getColor();
            Font font = this.getFont();
            graphics2D.setColor(color);
            graphics2D.setFont(font);
            Point point = chart.calculatePixelPoint(new Point2D.Double(this.getX().position(), this.getY().position()));
            Point point2 = this.getPixelOffset();
            if (point2 != null) {
                point = new Point(point.x + point2.x, point.y + point2.y);
            }
            LabelStyle labelStyle = this.getLabelStyle();
            double d2 = chart.getAnimationPosition();
            int n3 = d2 == 1.0 ? point.x : chart.interpolateXForAnimation(point.x, null);
            int n4 = n2 = d2 == 1.0 ? point.y : chart.interpolateYForAnimation(point.y, null);
            if (labelStyle == null || labelStyle.getRotation() == null || labelStyle.getRotation() == 0.0) {
                String string = this.getLabel();
                if (this.\u0103()) {
                    Font font2;
                    Color color2;
                    if (labelStyle == null) {
                        color2 = UIManager.getColor("Label.foreground");
                        font2 = UIManager.getFont("Label.font");
                    } else {
                        color2 = labelStyle.getColor();
                        if (color2 == null) {
                            color2 = UIManager.getColor("Label.foreground");
                        }
                        if ((font2 = labelStyle.getFont()) == null) {
                            font2 = UIManager.getFont("Label.font");
                        }
                    }
                    JLabel jLabel = this.getLabelComponent();
                    jLabel.setForeground(color2);
                    jLabel.setBorder(this.\u0117);
                    jLabel.setBackground(this.\u0118);
                    jLabel.setOpaque(this.\u0118 != null);
                    jLabel.setFont(font2);
                    jLabel.setText(string);
                    Dimension dimension = jLabel.getPreferredSize();
                    jLabel.setSize(dimension);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
                    graphics2D.translate(n3 - dimension.width / 2, n2 - fontMetrics.getAscent());
                    jLabel.paint(graphics2D);
                    graphics2D.translate(-n3 + dimension.width / 2, -n2 + fontMetrics.getAscent());
                } else {
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    if (string != null) {
                        int n5 = fontMetrics.stringWidth(string);
                        graphics2D.drawString(string, n3 - n5 / 2, n2);
                    }
                }
            } else {
                Double d3 = labelStyle.getRotation();
                if (d3 == null) {
                    d3 = 0.0;
                }
                this.paint((Graphics)graphics2D, n3, n2, d3);
            }
        }
    }

    private boolean \u0103() {
        String string = this.getLabel();
        if (string == null) {
            return false;
        }
        return (string = string.trim().toLowerCase()).startsWith("<html>") || this.\u0118 != null || this.\u0117 != null;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.\u011b == null ? 0 : this.\u011b.hashCode());
        n3 = 31 * n3 + (this.\u011a == null ? 0 : this.\u011a.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartLabel chartLabel = (ChartLabel)object;
        if (this.\u011b == null ? chartLabel.\u011b != null : !this.\u011b.equals(chartLabel.\u011b)) {
            return false;
        }
        return !(this.\u011a == null ? chartLabel.\u011a != null : !this.\u011a.equals(chartLabel.\u011a));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ChartLabel[");
        stringBuilder.append(this.getLabel());
        stringBuilder.append(", ");
        stringBuilder.append(this.\u011b);
        stringBuilder.append(", ");
        stringBuilder.append(this.\u011a);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

