/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.logger;

import com.nuodb.jdbc.logger.Jdk14LoggerFactory;
import com.nuodb.jdbc.logger.LoggerFactory;
import com.nuodb.jdbc.logger.NoopLoggerFactory;
import com.nuodb.jdbc.logger.Slf4jLoggerFactory;
import com.nuodb.jdbc.logger.StandardLoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;

public class LoggerManager {
    public static final String SLF4J_LOGGER = "slf4jLogger";
    public static final String JDK14_LOGGER = "jdk14Logger";
    public static final String STANDARD_LOGGER = "standardLogger";
    public static final String STANDARD_LOGGER_LEVEL = "standardLogger.level";
    public static final String STANDARD_LOGGER_PATTERN = "standardLogger.pattern";
    public static final String STANDARD_LOGGER_LOG_WRITER = "standardLogger.logWriter";
    public static final boolean STANDARD_LOGGER_DEFAULT = true;
    public static final boolean JDK14_LOGGER_DEFAULT = false;
    public static final boolean SLF4J_LOGGER_DEFAULT = false;
    private static final Collection<String> LOGGER_PROPERTIES = Collections.unmodifiableList(Arrays.asList("slf4jLogger", "jdk14Logger", "standardLogger", "standardLogger.level", "standardLogger.pattern", "standardLogger.logWriter"));
    private LoggerFactory loggerFactory;

    public static boolean isLoggerProperty(String property) {
        return LOGGER_PROPERTIES.contains(property);
    }

    public static Collection<String> getLoggerProperties() {
        return LOGGER_PROPERTIES;
    }

    public static LoggerManager getLoggerManager() {
        return new LoggerManager(new Properties());
    }

    public static LoggerManager getLoggerManager(Properties properties) {
        return new LoggerManager(properties);
    }

    private LoggerManager(Properties properties) {
        this.loggerFactory = this.createLoggerFactory(properties);
    }

    protected LoggerFactory createLoggerFactory(Properties properties) {
        LoggerFactory loggerFactory = null;
        if (LoggerManager.getBoolean(properties, JDK14_LOGGER, false)) {
            loggerFactory = new Jdk14LoggerFactory();
        } else if (LoggerManager.getBoolean(properties, SLF4J_LOGGER, false)) {
            loggerFactory = new Slf4jLoggerFactory();
        } else if (LoggerManager.getBoolean(properties, STANDARD_LOGGER, true)) {
            loggerFactory = new StandardLoggerFactory();
        }
        if (loggerFactory == null) {
            loggerFactory = new NoopLoggerFactory();
        }
        loggerFactory.init(properties);
        return loggerFactory;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public static Logger getParentLogger() {
        return Jdk14LoggerFactory.PARENT_LOGGER;
    }

    private static boolean getBoolean(Properties properties, String property, boolean defaultValue) {
        String value = properties.getProperty(property);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }
}

