/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EncodedDataStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;

public class RemEncodedStream
extends EncodedDataStream {
    public RemEncodedStream(int protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void encodeDate(Date date) {
        super.encodeScaledDate(date);
    }

    @Override
    public void encodeTime(Time time) throws SQLException {
        super.encodeScaledTime(time);
    }

    @Override
    public void encodeTimestamp(Timestamp timestamp) throws SQLException {
        super.encodeScaledTimestamp(timestamp);
    }

    @Override
    public void encodeBigDecimal(BigDecimal bd) {
        if (this.protocolVersion >= 11) {
            super.encodeBigDecimal(bd);
        } else {
            super.encodeOldBigDecimal(bd);
        }
    }

    @Override
    public void encodeArray(Array value) throws SQLException {
        if (this.protocolVersion < 19) {
            throw new SQLFeatureNotSupportedException(String.format("NuoDB server protocol {0} does not support ARRAY type", this.protocolVersion));
        }
        super.encodeArray(value);
    }
}

