/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

public class UTFConversions {
    private static final int[] UTF8_FLAGS = new int[]{0, 0, 192, 224, 240};

    private static int getUTF8SequenceLength(int code) {
        return code <= 127 ? 1 : (code <= 2047 ? 2 : (code <= 65535 ? 3 : (code <= 0x1FFFFF ? 4 : (code <= 0x3FFFFFF ? 5 : 6))));
    }

    private static int appendUTF8(int code, byte[] ba, int bi) {
        int len = UTFConversions.getUTF8SequenceLength(code);
        if (len == 1) {
            ba[bi] = (byte)code;
        } else {
            bi += len;
            for (int n = 1; n < len; ++n) {
                ba[bi - n] = (byte)(0x80 | code & 0x3F);
                code >>= 6;
            }
            ba[bi - len] = (byte)(UTF8_FLAGS[len] | code);
        }
        return len;
    }

    private static int length(char[] ca, int cs, int lim) {
        int len = 0;
        int cl = cs + lim;
        while (cs < cl) {
            char ch = ca[cs++];
            len += UTFConversions.getUTF8SequenceLength(ch);
        }
        return len;
    }

    private static int encode(char[] ca, int cs, int len, byte[] ba) {
        int bi = 0;
        int cl = cs + len;
        while (cs < cl) {
            char ch = ca[cs++];
            bi += UTFConversions.appendUTF8(ch, ba, bi);
        }
        return bi;
    }

    public static byte[] encode(String s) {
        char[] ca = s.toCharArray();
        int len = UTFConversions.length(ca, 0, ca.length);
        byte[] ba = new byte[len];
        UTFConversions.encode(ca, 0, ca.length, ba);
        return ba;
    }
}

