/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class SQLUtils {
    public static void close(ResultSet resultSet) {
        SQLUtils.close(resultSet, false);
    }

    public static void close(ResultSet resultSet, boolean quiet) {
        block3: {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    if (quiet) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public static void close(Statement statement) {
        SQLUtils.close(statement, false);
    }

    public static void close(Statement statement, boolean quite) {
        block3: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    if (quite) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public static void close(Connection connection) {
        SQLUtils.close(connection, false);
    }

    public static void close(Connection connection, boolean quite) {
        block3: {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    if (quite) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public static int drainResultSet(ResultSet resultSet) throws SQLException {
        int rows = 0;
        if (resultSet != null) {
            while (resultSet.next()) {
                ++rows;
            }
        }
        return rows;
    }

    public static List<String> getColumnNames(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        ArrayList<String> columns = new ArrayList<String>(metaData.getColumnCount());
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            columns.add(metaData.getColumnName(i + 1));
        }
        return columns;
    }

    public static List<String> getColumnLabels(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        ArrayList<String> columns = new ArrayList<String>(metaData.getColumnCount());
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            columns.add(metaData.getColumnLabel(i + 1));
        }
        return columns;
    }

    public static List<String> dumpMetaData(ResultSet resultSet) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String column = MessageFormat.format("Name {0}, type {1}/{2}, size {3}, precision {4}, scale {5}", metaData.getColumnLabel(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.getColumnDisplaySize(i), metaData.getPrecision(i), metaData.getScale(i));
            results.add(column);
        }
        return results;
    }
}

