/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.io.IOException;

public class Preconditions {
    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void ioCheckArgument(boolean expression, Object errorMessage) throws IOException {
        if (!expression) {
            throw new IOException(String.valueOf(errorMessage));
        }
    }

    public static void ioCheckArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) throws IOException {
        if (!expression) {
            throw new IOException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    private static String format(String template, Object ... errorMessageArgs) {
        return String.format(String.valueOf(template), errorMessageArgs);
    }
}

