/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.HasShortString;
import com.nuodb.xml.Tag;
import com.nuodb.xml.XmlException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LeaderSelector<Archive extends HasShortString> {
    private final long UNPARTITIONED_STORAGE_GROUP_ID = 2L;
    private List<String> notes = new LinkedList<String>();
    private Map<String, Archive> uuidmap = new HashMap<String, Archive>();
    private Map<String, Integer> aliveCount = new HashMap<String, Integer>();
    private Map<Archive, Long> lastWrites = new HashMap<Archive, Long>();
    private Map<Long, Vector<Archive>> candidates = new HashMap<Long, Vector<Archive>>();
    private Map<Long, Long> candidateEpochs = new HashMap<Long, Long>();
    private Map<Archive, Vector<Long>> leadingStorageGroups = new HashMap<Archive, Vector<Long>>();
    private Archive unpartitionedStorageGroupLeader = null;
    private long maxEpoch = 0L;
    private Set<Long> onlineStorageGroups = new HashSet<Long>();
    private final Set<Archive> archivesWithAllStorageGroupsOnline = new HashSet<Archive>();

    public void addOnlineStorageGroups(Collection<Long> onlineGroups) {
        this.onlineStorageGroups.addAll(onlineGroups);
    }

    public boolean requiresLeaderAssignment(Archive archive) {
        return !this.archivesWithAllStorageGroupsOnline.contains(archive);
    }

    public void add(Archive archive, Tag archiveHistory) {
        try {
            String local = archiveHistory.getAttribute("LocalArchive");
            if (this.uuidmap.containsKey(local)) {
                this.notes.add("Skipping duplicate LocalArchive ID " + local + " for " + archive.toShortString());
                return;
            }
            this.uuidmap.put(local, archive);
            if (!this.aliveCount.containsKey(local)) {
                this.aliveCount.put(local, 0);
            }
            this.lastWrites.put(archive, archiveHistory.getLongAttribute("LastWrite"));
            for (Tag child : archiveHistory) {
                try {
                    if (!child.isNamed("OtherArchive") || child.getLongAttribute("EndTime") != 0L) continue;
                    String other = child.getAttribute("Archive");
                    int count = 0;
                    if (this.aliveCount.containsKey(other)) {
                        count = this.aliveCount.get(other);
                    }
                    this.aliveCount.put(other, count + 1);
                }
                catch (XmlException xmle) {
                    this.notes.add("Malformed OtherArchive entry: " + xmle.getMessage() + "\nTag: " + child.toString());
                }
                catch (RuntimeException re) {
                    throw new IllegalStateException("Invalid archive history: " + re.getMessage() + "\nArchive: " + archive.toShortString());
                }
            }
            Tag archiveState = archiveHistory.findChild("ArchiveState");
            if (!this.parseArchiveState(archive, archiveState)) {
                this.archivesWithAllStorageGroupsOnline.add(archive);
            }
        }
        catch (XmlException xmle) {
            this.notes.add("Archive history was not readable for " + archive.toShortString());
        }
    }

    private boolean parseArchiveState(Archive archive, Tag archiveState) throws XmlException {
        boolean goodState = false;
        boolean hasOfflineSgs = false;
        if (archiveState != null) {
            Tag leaderCandidates = archiveState.findChild("LeaderCandidate");
            if (leaderCandidates != null) {
                long epoch = leaderCandidates.getLongAttribute("epoch");
                if (epoch > this.maxEpoch) {
                    this.maxEpoch = epoch;
                }
                for (Tag storageGroup : leaderCandidates) {
                    Vector<Object> candidateVector;
                    if (!storageGroup.getName().equals("StorageGroup")) continue;
                    goodState = true;
                    long sgId = storageGroup.getLongAttribute("id");
                    if (this.onlineStorageGroups.contains(sgId)) continue;
                    hasOfflineSgs = true;
                    this.notes.add(String.format("Archive %s is a leader candidate for sg id=%d epoch=%d", archive.toShortString(), sgId, epoch));
                    long candidateEpoch = 0L;
                    if (this.candidateEpochs.containsKey(sgId)) {
                        candidateEpoch = this.candidateEpochs.get(sgId);
                    }
                    if ((candidateVector = this.candidates.get(sgId)) == null || epoch > candidateEpoch) {
                        candidateVector = new Vector();
                        this.candidates.put(sgId, candidateVector);
                    }
                    if (epoch < candidateEpoch) continue;
                    candidateVector.add(archive);
                    this.candidateEpochs.put(sgId, epoch);
                }
            }
            if (!goodState) {
                this.notes.add(String.format("Archive %s has no storage group leader candidate information: raw XML:\n%s", archive.toShortString(), archiveState.toString()));
            }
        } else {
            this.notes.add(String.format("Archive %s has no archive state", archive.toShortString()));
        }
        return hasOfflineSgs;
    }

    public void clear() {
        this.notes.clear();
        this.uuidmap.clear();
        this.aliveCount.clear();
        this.lastWrites.clear();
        this.candidates.clear();
        this.candidateEpochs.clear();
        this.onlineStorageGroups.clear();
        this.leadingStorageGroups.clear();
        this.unpartitionedStorageGroupLeader = null;
        this.maxEpoch = 0L;
        this.archivesWithAllStorageGroupsOnline.clear();
    }

    /*
     * WARNING - void declaration
     */
    public Archive selectLeaders() {
        void var3_17;
        for (String string : this.aliveCount.keySet()) {
            if (this.uuidmap.containsKey(string)) continue;
            this.notes.add("OtherArchive references an unknown ID: " + string);
        }
        if (!this.candidates.isEmpty()) {
            HashMap<HasShortString, Integer> popularity = new HashMap<HasShortString, Integer>(this.candidates.size());
            for (Vector<Archive> vector : this.candidates.values()) {
                for (HasShortString archive : vector) {
                    int count = 0;
                    if (popularity.containsKey(archive)) {
                        count = (Integer)popularity.get(archive);
                    }
                    popularity.put(archive, 1 + count);
                }
            }
            for (Map.Entry<Long, Vector<Archive>> entry : this.candidates.entrySet()) {
                long l = entry.getKey();
                if (this.onlineStorageGroups.contains(l)) {
                    this.notes.add(String.format("Storage group id=%d is already on-line.", l));
                    continue;
                }
                HasShortString leader = (HasShortString)entry.getValue().get(0);
                for (HasShortString candidate : entry.getValue()) {
                    if ((Integer)popularity.get(candidate) <= (Integer)popularity.get(leader)) continue;
                    leader = candidate;
                }
                if (!this.leadingStorageGroups.containsKey(leader)) {
                    this.leadingStorageGroups.put(leader, new Vector());
                }
                this.leadingStorageGroups.get(leader).add(l);
                this.notes.add(String.format("Storage group id=%d leader is %s", l, leader.toShortString()));
                if (l != 2L) continue;
                this.unpartitionedStorageGroupLeader = leader;
            }
            if (this.onlineStorageGroups.isEmpty() && this.unpartitionedStorageGroupLeader == null) {
                this.notes.add("There is no leader archive for the UNPARTITIONED storage group.");
            }
            return this.unpartitionedStorageGroupLeader;
        }
        if (!this.onlineStorageGroups.isEmpty()) {
            return null;
        }
        this.notes.add("No leader candidates, could be an old database");
        if (this.uuidmap.size() == 0) {
            return null;
        }
        if (this.uuidmap.size() == 1) {
            this.notes.add("Only one archive");
            return (Archive)((HasShortString)this.uuidmap.values().iterator().next());
        }
        int maxAlive = 0;
        for (Map.Entry<String, Integer> entry : this.aliveCount.entrySet()) {
            int count;
            String string = entry.getKey();
            if (!this.uuidmap.containsKey(string) || (count = entry.getValue().intValue()) <= maxAlive) continue;
            maxAlive = count;
        }
        HashSet<Archive> hashSet = new HashSet<Archive>();
        for (Map.Entry<String, Integer> entry : this.aliveCount.entrySet()) {
            String uuid;
            if (entry.getValue() != maxAlive || !this.uuidmap.containsKey(uuid = entry.getKey())) continue;
            hashSet.add(this.uuidmap.get(uuid));
        }
        Object var3_13 = null;
        long l = -1L;
        for (HasShortString alive : hashSet) {
            void var3_14;
            long lastWrite = this.lastWrites.get(alive);
            if (lastWrite == 0L) {
                HasShortString hasShortString = alive;
                this.notes.add(String.format("Archive %s has lastWrite == 0, assumed to be last alive", hasShortString.toShortString()));
                break;
            }
            if (lastWrite <= l) continue;
            if (var3_14 == null) {
                this.notes.add(String.format("Archive %s tentatively selected as last alive", alive.toShortString()));
            } else {
                this.notes.add(String.format("Archive %s has lastWrite %d > %d of %s, so it's better", alive.toShortString(), lastWrite, l, var3_14.toShortString()));
            }
            HasShortString hasShortString = alive;
            l = lastWrite;
        }
        return var3_17;
    }

    public Map<String, String> getOptions(Archive archive) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (!this.candidates.isEmpty()) {
            if (archive.equals(this.unpartitionedStorageGroupLeader)) {
                options.put("--storage-group-epoch", Long.toString(this.maxEpoch + 1L));
            }
            StringBuffer buffer = new StringBuffer();
            if (this.leadingStorageGroups.containsKey(archive)) {
                for (long sgId : this.leadingStorageGroups.get(archive)) {
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append(sgId);
                }
            }
            if (buffer.length() == 0) {
                buffer.append("none");
            }
            options.put("--storage-group-leader", buffer.toString());
        }
        return options;
    }

    public List<String> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }
}

