/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.security.RemotePassword;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class RemoteGroup {
    BigInteger prime;
    BigInteger generator;
    BigInteger k;
    static RemoteGroup group;
    static Random random;

    public RemoteGroup(String primeString, String generatorString) {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.generator = new BigInteger("2");
        byte[] primeBytes = RemotePassword.getBytes(primeString);
        this.prime = new BigInteger(1, primeBytes);
        byte[] generatorBytes = this.generator.toByteArray();
        sha1.update(primeBytes);
        int pad = primeBytes.length - generatorBytes.length;
        if (pad > 0) {
            sha1.update(new byte[pad]);
        }
        sha1.update(generatorBytes);
        byte[] kBytes = sha1.digest();
        this.k = new BigInteger(kBytes);
    }

    public static RemoteGroup getGroup(int groupSize) {
        if (group == null) {
            String prime = "EEAF0AB9ADB38DD69C33F80AFA8FC5E86072618775FF3C0B9EA2314C9C256576D674DF7496EA81D3383B4813D692C6E0E0D5D8E250B98BE48E495C1D6089DAD15DC7D7B46154D6B6CE8EF4AD69B15D4982559B297BCF1885C529F566660E57EC68EDBC3C05726CC02FD4CBF4976EAA9AFD5138FE8376435B9FC61D2FC0EB06E3";
            group = new RemoteGroup(prime, "02");
        }
        return group;
    }

    static {
        random = new Random(System.currentTimeMillis());
    }
}

