/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.security.Cipher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CipherRC4
extends Cipher {
    byte[] buffer;
    byte[] state;
    int s1;
    int s2;

    public CipherRC4(byte[] key, int offset, int length) {
        this.setKey(key, offset, length);
    }

    public CipherRC4(byte[] key) {
        this.setKey(key, 0, key.length);
    }

    @Override
    public int getBlockSize() {
        return 1;
    }

    @Override
    public int read(InputStream inputStream, byte[] bytes, int offset, int length) throws IOException {
        int bytesRead;
        for (bytesRead = 0; bytesRead < length; bytesRead += inputStream.read(bytes, bytesRead, length - bytesRead)) {
        }
        this.transform(bytes, offset, bytesRead);
        return bytesRead;
    }

    @Override
    public void setKey(byte[] key, int offset, int length) {
        this.state = new byte[256];
        for (int n = 0; n < this.state.length; ++n) {
            this.state[n] = (byte)n;
        }
        int k2 = 0;
        for (int k1 = 0; k1 < 256; ++k1) {
            k2 = k2 + key[(k1 + offset) % length] + this.state[k1] & 0xFF;
            byte temp = this.state[k1];
            this.state[k1] = this.state[k2];
            this.state[k2] = temp;
        }
        this.s2 = 0;
        this.s1 = 0;
    }

    @Override
    public void write(OutputStream outputStream, byte[] bytes, int offset, int length) throws IOException {
        if (this.buffer == null || this.buffer.length < length) {
            this.buffer = new byte[length + 100];
        }
        int end = offset + length;
        for (int n = offset; n < end; ++n) {
            this.s1 = this.s1 + 1 & 0xFF;
            this.s2 = this.s2 + this.state[this.s1] & 0xFF;
            byte temp = this.state[this.s1];
            this.state[this.s1] = this.state[this.s2];
            this.state[this.s2] = temp;
            byte b = this.state[this.state[this.s1] + this.state[this.s2] & 0xFF];
            this.buffer[n] = (byte)(bytes[n] ^ b);
        }
        outputStream.write(this.buffer, 0, length);
    }

    public void transform(byte[] data, int offset, int length) {
        int n = offset;
        int end = offset + length;
        while (n < end) {
            this.s1 = this.s1 + 1 & 0xFF;
            this.s2 = this.s2 + this.state[this.s1] & 0xFF;
            byte temp = this.state[this.s1];
            this.state[this.s1] = this.state[this.s2];
            this.state[this.s2] = temp;
            byte b = this.state[this.state[this.s1] + this.state[this.s2] & 0xFF];
            int n2 = n++;
            data[n2] = (byte)(data[n2] ^ b);
        }
    }
}

