/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.CryptoInputStream;
import com.nuodb.impl.net.CryptoOutputStream;
import com.nuodb.impl.net.CryptoSocket;
import com.nuodb.impl.net.SocketMonitor;
import com.nuodb.impl.util.DataStream;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class SocketListener
implements SocketMonitor,
Runnable {
    protected Socket socket;
    protected CryptoInputStream inputStream;
    protected CryptoOutputStream outputStream;
    protected Thread thread;
    protected boolean shutdownRequested;
    protected DataStream dataInput;
    protected DataStream dataOutput;

    public SocketListener() {
    }

    public SocketListener(Socket socket) throws IOException {
        this.setSocket(socket);
    }

    private void init() throws IOException {
        this.inputStream = new CryptoInputStream(this.socket.getInputStream());
        this.outputStream = new CryptoOutputStream(this.socket.getOutputStream());
        this.dataInput = new DataStream();
        this.dataOutput = new DataStream();
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.init();
    }

    public void connect(String address, int port) throws IOException {
        this.connect(InetAddress.getByName(address), port);
    }

    public void connect(InetAddress address, int port) throws IOException {
        this.connect(address, port, 0);
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException {
        assert (this.socket == null);
        this.socket = new CryptoSocket(address, port, timeout);
        this.init();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void listener() {
        assert (this.socket != null);
        while (!this.shutdownRequested) {
            try {
                this.dataInput.getMessage(this.inputStream);
                this.messageReceived();
            }
            catch (IOException exception) {
                this.connectionFailed(exception);
                break;
            }
        }
        this.thread = null;
    }

    @Override
    public void run() {
        this.listener();
    }

    @Override
    public void connectionFailed(IOException exception) {
    }

    public Tag getXmlMessage() throws IOException {
        this.dataInput.getMessage(this.inputStream);
        Tag tag = null;
        try {
            tag = TagFactory.parseTag(this.dataInput.readString());
        }
        catch (XmlException exception) {
            throw new IOException(exception);
        }
        return tag;
    }

    public void messageReceived() throws IOException {
        String message = "";
        try {
            message = this.dataInput.readString();
            Tag tag = TagFactory.parseTag(message);
            this.messageReceived(tag);
        }
        catch (XmlException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void messageReceived(Tag tag) {
    }

    public Tag getXml() throws IOException {
        try {
            this.dataInput.getMessage(this.inputStream);
            return TagFactory.parseTag(this.dataInput.readString());
        }
        catch (XmlException exception) {
            throw new IOException(exception);
        }
    }

    public void start() {
        if (this.thread != null) {
            throw new IllegalStateException("SocketLister is already active");
        }
        this.shutdownRequested = false;
        this.thread = new Thread((Runnable)this, "SocketListener");
        this.thread.start();
    }

    public void shutdown() {
        this.shutdownRequested = true;
    }

    public synchronized void send(Tag xml) throws IOException {
        String string = xml.toString();
        this.dataOutput.write(string);
        this.dataOutput.send(this.outputStream);
        this.dataOutput.reset();
    }

    public void setSoTimeout(int timeout) throws IOException {
        this.socket.setSoTimeout(timeout);
    }

    public long receiveMessage(OutputStream out) throws IOException {
        int toRead;
        int count;
        int length = this.inputStream.readLength();
        byte[] buffer = new byte[4096];
        int l = 0;
        while (l < length && -1 != (count = this.inputStream.read(buffer, 0, toRead = Math.min(length - l, 4096)))) {
            if (0 == count) continue;
            l += count;
            out.write(buffer, 0, count);
        }
        return length;
    }
}

