/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.descriptions;

public enum ProcessType {
    TE(1),
    SM(2),
    SSM(6);

    private final int typeNum;

    private ProcessType(int typeNum) {
        this.typeNum = typeNum;
    }

    public int getTypeNum() {
        return this.typeNum;
    }

    public boolean isTransaction() {
        return this.isSubType(TE);
    }

    public boolean isArchive() {
        return this.isSubType(SM);
    }

    public boolean isSubType(ProcessType type) {
        return (this.typeNum & type.typeNum) == type.typeNum;
    }

    public static ProcessType fromTypeNum(int typeNum) {
        for (ProcessType type : ProcessType.values()) {
            if (typeNum != type.typeNum) continue;
            return type;
        }
        throw new IllegalArgumentException("No ProcessType with type number " + typeNum);
    }

    public static ProcessType fromString(String input) {
        return ProcessType.valueOf(input.trim().toUpperCase());
    }
}

