/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import com.vertica.support.IMessageSource;
import com.vertica.support.WarningCode;
import java.util.Locale;

public class Warning {
    private int m_nativeErrorCode = -1;
    private WarningCode m_warningCode;
    private String m_customState;
    private String m_msgKey;
    private String[] m_msgParams = null;
    private String m_message;
    private int m_componentId;
    private int m_rowNumber;
    private int m_columnNumber;
    private boolean m_hasPreformattedMessage = false;

    public Warning(WarningCode warningCode, String string, int n) {
        this(warningCode, string, n, -1, -1);
    }

    public Warning(WarningCode warningCode, String string, int n, int n2, int n3) {
        this.m_warningCode = warningCode;
        this.m_message = null == string ? "" : string;
        this.m_nativeErrorCode = n;
        this.m_rowNumber = n2;
        this.m_columnNumber = n3;
    }

    public Warning(WarningCode warningCode, int n, String string) {
        this(warningCode, n, string, -1, -1);
    }

    public Warning(WarningCode warningCode, int n, String string, String[] stringArray) {
        this(warningCode, n, string, stringArray, -1, -1);
    }

    public Warning(WarningCode warningCode, int n, String string, int n2, int n3) {
        this(warningCode, n, string, null, n2, n3);
    }

    public Warning(WarningCode warningCode, int n, String string, String[] stringArray, int n2, int n3) {
        this.m_warningCode = warningCode;
        this.m_customState = null;
        this.m_componentId = n;
        this.m_msgKey = string;
        this.m_msgParams = stringArray;
        this.m_rowNumber = n2;
        this.m_columnNumber = n3;
    }

    public Warning(WarningCode warningCode, String string) {
        this(warningCode, string, -1, -1);
    }

    public Warning(WarningCode warningCode, String string, int n, int n2) {
        this.m_warningCode = warningCode;
        this.m_message = null == string ? "" : string;
        this.m_hasPreformattedMessage = true;
        this.m_rowNumber = n;
        this.m_columnNumber = n2;
    }

    public Warning(String string, String string2) {
        this(string, string2, -1, -1);
    }

    public Warning(String string, String string2, int n, int n2) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = string;
        this.m_message = null == string2 ? "" : string2;
        this.m_hasPreformattedMessage = true;
        this.m_rowNumber = n;
        this.m_columnNumber = n2;
    }

    public Warning(String string, int n, String string2, int n2, int n3) {
        this(string, n, string2, null, n2, n3);
    }

    public Warning(String string, int n, String string2, String[] stringArray, int n2, int n3) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = string;
        this.m_componentId = n;
        this.m_msgKey = string2;
        this.m_msgParams = stringArray;
        this.m_rowNumber = n2;
        this.m_columnNumber = n3;
    }

    public Warning(String string, String string2, int n) {
        this(string, string2, n, -1, -1);
    }

    public Warning(String string, String string2, int n, int n2, int n3) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = string;
        this.m_message = null == string2 ? "" : string2;
        this.m_hasPreformattedMessage = true;
        this.m_nativeErrorCode = n;
        this.m_rowNumber = n2;
        this.m_columnNumber = n3;
    }

    public int getNativeErrorCode() {
        return this.m_nativeErrorCode;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public int getComponentId() {
        return this.m_componentId;
    }

    public String getCustomState() {
        return this.m_customState;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getMessageKey() {
        return this.m_msgKey;
    }

    public String[] getMessageParams() {
        return this.m_msgParams;
    }

    public int getRowNumber() {
        return this.m_rowNumber;
    }

    public WarningCode getWarningCode() {
        return this.m_warningCode;
    }

    public boolean hasCustomState() {
        return null != this.m_customState;
    }

    public boolean hasMessageParams() {
        return null != this.m_msgParams;
    }

    public boolean hasPreformattedMessage() {
        return this.m_hasPreformattedMessage;
    }

    public void setLocalizedWarningMessage(IMessageSource iMessageSource, Locale locale) {
        if (this.m_hasPreformattedMessage || null == this.m_msgKey) {
            return;
        }
        this.m_message = this.hasMessageParams() ? iMessageSource.loadMessage(locale, this.m_componentId, this.m_msgKey, this.m_msgParams) : iMessageSource.loadMessage(locale, this.m_componentId, this.m_msgKey);
    }
}

