/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.support.ILogger;
import com.vertica.support.exceptions.GeneralException;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public abstract class JDBCObjectFactory {
    private static JDBCObjectFactory s_factory = null;

    static JDBCObjectFactory getInstance() {
        return s_factory;
    }

    static void setInstance(JDBCObjectFactory jDBCObjectFactory) throws GeneralException {
        if (null == jDBCObjectFactory) {
            throw new GeneralException(1, JDBCMessageKey.INITIALIZE_FACTORY.name());
        }
        s_factory = jDBCObjectFactory;
    }

    protected JDBCObjectFactory() {
    }

    protected abstract SCallableStatement createCallableStatement(String var1, IStatement var2, SConnection var3, int var4) throws SQLException;

    protected abstract SConnection createConnection(IConnection var1, String var2) throws SQLException;

    protected abstract SConnectionHandle createConnectionHandle(SConnection var1, SPooledConnection var2) throws SQLException;

    protected abstract SDatabaseMetaData createDatabaseMetaData(SConnection var1, ILogger var2) throws SQLException;

    protected abstract SPreparedStatement createPreparedStatement(String var1, IStatement var2, SConnection var3, int var4) throws SQLException;

    protected abstract PooledConnection createPooledConnection(SConnection var1) throws SQLException;

    protected abstract SStatement createStatement(IStatement var1, SConnection var2, int var3) throws SQLException;
}

