/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import java.io.IOException;

public final class VerifyFilesResponseMessage
extends ResponseMessage {
    private String[] m_inputFiles;
    private String m_rejectionsFile;
    private String m_exceptionsFile;

    protected VerifyFilesResponseMessage(VStream vStream) {
        super(vStream);
    }

    protected void buildMessage(int n) throws IOException {
        int n2 = this.m_vStream.ReceiveIntegerR(2);
        this.m_inputFiles = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_inputFiles[i] = this.m_vStream.ReceiveString();
        }
        this.m_rejectionsFile = this.m_vStream.ReceiveString();
        this.m_exceptionsFile = this.m_vStream.ReceiveString();
    }

    public String[] getInputFileNames() {
        return this.m_inputFiles;
    }

    public String getRejectionsFileName() {
        return this.m_rejectionsFile;
    }

    public String getExceptionsFileName() {
        return this.m_exceptionsFile;
    }

    public MessageType getType() {
        return MessageType.VerifyFiles;
    }

    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[this.m_inputFiles.length + 3];
        StringBuilder stringBuilder = new StringBuilder();
        objectArray[0] = this.getType();
        for (int i = 0; i < this.m_inputFiles.length; ++i) {
            objectArray[i + 1] = this.m_inputFiles[i];
        }
        objectArray[this.m_inputFiles.length + 1] = "Rejects: " + (this.m_rejectionsFile.equals("") ? "RETURNREJECTED" : this.m_rejectionsFile);
        objectArray[this.m_inputFiles.length + 2] = "Exceptions: " + (this.m_rejectionsFile.equals("") ? "<none>" : this.m_exceptionsFile);
        return objectArray;
    }
}

