/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.support.exceptions.ErrorException;

public class ColumnMetadata
implements IColumn {
    private String m_label;
    private String m_name;
    private String m_catalogName;
    private String m_schemaName;
    private String m_tableName;
    private TypeMetadata m_typeMetadata;
    private Updatable m_updatable;
    private Searchable m_searchable;
    private Nullable m_nullable;
    private long m_columnLength;
    private boolean m_isAutoUnique;
    private boolean m_isCaseSensitive;

    public ColumnMetadata(TypeMetadata typeMetadata) throws NullPointerException {
        if (null == typeMetadata) {
            throw new NullPointerException();
        }
        this.m_typeMetadata = typeMetadata;
        this.m_label = "";
        this.m_name = "";
        this.m_catalogName = "";
        this.m_schemaName = "";
        this.m_tableName = "";
        this.m_updatable = Updatable.UNKNOWN;
        this.m_searchable = Searchable.SEARCHABLE;
        this.m_nullable = Nullable.UNKNOWN;
        this.m_columnLength = 0L;
        this.m_isAutoUnique = false;
        this.m_isCaseSensitive = false;
    }

    public String getCatalogName() {
        return this.m_catalogName;
    }

    public long getColumnLength() {
        return this.m_columnLength;
    }

    public long getDisplaySize() throws ErrorException {
        return TypeUtilities.getDisplaySize(this.m_typeMetadata, this.m_columnLength);
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getName() {
        return this.m_name;
    }

    public Nullable getNullable() {
        return this.m_nullable;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public Searchable getSearchable() {
        return this.m_searchable;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public TypeMetadata getTypeMetadata() {
        return this.m_typeMetadata;
    }

    public Updatable getUpdatable() {
        return this.m_updatable;
    }

    public boolean isAutoUnique() {
        return this.m_isAutoUnique;
    }

    public boolean isCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    public boolean isDefinitelyWritable() {
        return Updatable.WRITE == this.m_updatable;
    }

    public boolean isUnnamed() {
        return null == this.m_name;
    }

    public void setAutoUnique(boolean bl) {
        this.m_isAutoUnique = bl;
    }

    public void setCaseSensitive(boolean bl) {
        this.m_isCaseSensitive = bl;
    }

    public void setCatalogName(String string) {
        this.m_catalogName = string;
    }

    public void setColumnLength(long l) throws NumericOverflowException {
        if (l > 0xFFFFFFFFL || l < 0L) {
            throw new NumericOverflowException();
        }
        this.m_columnLength = l;
    }

    public void setLabel(String string) {
        this.m_label = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setNullable(Nullable nullable) {
        this.m_nullable = nullable;
    }

    public void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public void setSearchable(Searchable searchable) {
        this.m_searchable = searchable;
    }

    public void setTableName(String string) {
        this.m_tableName = string;
    }

    public void setTypeMetadata(TypeMetadata typeMetadata) throws NullPointerException {
        if (null == typeMetadata) {
            throw new NullPointerException();
        }
        this.m_typeMetadata = typeMetadata;
    }

    public void setUpdatable(Updatable updatable) {
        this.m_updatable = updatable;
    }

    public String toString() {
        if (this.isUnnamed()) {
            return "ColumnMetadata: <null>";
        }
        return "ColumnMetadata: " + this.getName();
    }
}

