/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.core.VStatement;
import com.vertica.dataengine.VParameterMetadata;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dataengine.VResultSet;
import com.vertica.dataengine.VStreamQueryExecutor;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.impl.DSIDataEngine;
import com.vertica.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.OrderType;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.exceptions.ParsingErrorID;
import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.io.CommandDescriptionResponseMessage;
import com.vertica.io.DescribeRequestMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.FlushRequestMessage;
import com.vertica.io.MessageType;
import com.vertica.io.ParameterDescriptionResponseMessage;
import com.vertica.io.ParseRequestMessage;
import com.vertica.io.ProtocolStream;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.parser.ParsedQuery;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDataEngine
extends DSIDataEngine {
    private VStatement m_statement;
    private DSILogger m_log;
    private ProtocolStream m_protocolStream;
    private VConnection m_connection;
    private boolean m_isPrepared;
    private boolean m_isInternal;
    private boolean m_isStdin;

    public VDataEngine(VStatement vStatement, boolean bl) {
        super(vStatement);
        this.m_statement = vStatement;
        this.m_connection = vStatement.getConnection();
        this.m_protocolStream = this.m_connection.getProtocolStream();
        this.m_isInternal = bl;
        this.m_isPrepared = !bl;
        this.m_log = this.m_connection.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, vStatement, bl);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void setDirectExecute() {
        this.m_isPrepared = false;
    }

    public void useStdin() {
        this.m_isStdin = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VQueryExecutor prepareImpl(String var1_1, boolean var2_2) throws ErrorException {
        block29: {
            block28: {
                block27: {
                    LogUtilities.logFunctionEntrance(this.m_log, new Object[]{var1_1, var2_2});
                    if (!this.m_isInternal) {
                        var3_3 = new ParsedQuery(var1_1, this.m_connection.useStandardConformingStrings(), this.m_statement.getMaxRows());
                        var3_3.parse();
                        var1_1 = var3_3.toString();
                    }
                    var3_3 = new LinkedList<E>();
                    var4_4 = "";
                    var5_5 = false;
                    this.m_connection.lock();
                    try {
                        try {
                            this.m_protocolStream.setWarningListener(this.getWarningListener());
                            this.m_connection.setCurrentStatement(this.m_statement);
                            this.m_connection.ensureNotInLRS(var1_1, this.m_statement.getResultBufferSize());
                            this.m_connection.clearLastServerErrorData();
                            try {
                                this.m_connection.endCurrentCopy();
                            }
                            catch (ErrorException var6_6) {
                                var5_5 = true;
                                throw var6_6;
                            }
                            this.m_connection.executeLRSWorkQueue();
                            if (!this.m_isPrepared) ** GOTO lbl-1000
                            var4_4 = this.m_statement.makeStatementName();
                            var6_7 = 0;
                            var7_10 = new int[var6_7];
                            Arrays.fill(var7_10, 0);
                            this.m_protocolStream.sendMessage(new ParseRequestMessage(var4_4, var1_1, var7_10));
                            this.m_protocolStream.sendMessage(new DescribeRequestMessage(false, var4_4));
                            this.m_protocolStream.sendMessage(new FlushRequestMessage());
                            this.m_protocolStream.readExpectedMessage(ParseRequestMessage.LEGAL_RESPONSE);
                            var8_12 = (ParameterDescriptionResponseMessage)this.m_protocolStream.readExpectedMessage(DescribeRequestMessage.LEGAL_RESPONSE_STEP1);
                            var9_13 = var8_12.getParameterTypes();
                            var10_14 = var8_12.getParameterTypmods();
                            var11_15 = var8_12.getParameterTypeNames();
                            var12_16 = var8_12.getParameterNotNulls();
                            if (!VDataEngine.$assertionsDisabled && var9_13.length != var10_14.length) {
                                throw new AssertionError();
                            }
                            if (!VDataEngine.$assertionsDisabled && var9_13.length != var12_16.length) {
                                throw new AssertionError();
                            }
                            var13_17 = this.m_protocolStream.readExpectedMessage(DescribeRequestMessage.LEGAL_RESPONSES_STEP2);
                            var14_18 = var13_17.getType().equals((Object)MessageType.RowDescription) != false ? ((RowDescriptionResponseMessage)var13_17).getRowDescription() : VResultSet.PSEUDO_ROWCOUNT_DESCRIPTION;
                            var15_19 = (CommandDescriptionResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.CommandDescription);
                            var16_20 = var15_19.getTag();
                            var3_3.add(var16_20);
                            if ("".equals(var16_20)) {
                                throw new ParsingException(ParsingErrorID.SYNTAX_ERR_OR_ACCESS_VIOLATION, 101, VMessageKey.ERROR_EMPTY_QUERY_NOT_SUPPORTED.toString());
                            }
                            if ("COPY_LOCAL".equals(var16_20)) {
                                if (this.m_connection.getDisableCopyLocal()) {
                                    throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_COPY_LOCAL_DISABLED.toString());
                                }
                                if (var9_13.length != 0) throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_PREPARED_COPY_NOT_SUPPORTED.toString());
                                this.m_statement.fallbackToUnnamed();
                                this.m_isPrepared = false;
                                var17_21 = this.prepareImpl(var1_1, var2_2);
                                var23_23 = null;
                                this.m_protocolStream.clearWarningListener();
                            }
                            ** GOTO lbl-1000
                        }
                        catch (ErrorException var6_9) {
                            try {
                                this.m_connection.handleError(var5_5 == false, var6_9);
                                throw var6_9;
                            }
                            catch (Throwable var22_38) {
                                var23_27 = null;
                                this.m_protocolStream.clearWarningListener();
                                throw var22_38;
                            }
                        }
                        var25_28 = null;
                        this.m_connection.unlock();
                        return var17_21;
lbl-1000:
                        // 1 sources

                        {
                            var17_22 = var15_19.hasCopyRewrite() != false && var9_13.length > 0;
                            var18_33 = new ArrayList<ParameterMetadata>();
                            var19_34 = this.m_connection.useStringBatchInserts();
                            for (var20_35 = 0; var20_35 < var9_13.length; ++var20_35) {
                                var21_37 = new VParameterMetadata(var20_35 + 1, ParameterType.INPUT, TypeUtils.createTypeMetadata(var9_13[var20_35], var10_14[var20_35], var11_15[var20_35]), TypeUtils.getColumnSize(var9_13[var20_35], var10_14[var20_35]), var11_15[var20_35], true, var12_16[var20_35] != false ? Nullable.NO_NULLS : Nullable.NULLABLE, var9_13[var20_35]);
                                var21_37.setConvertInputToString(var19_34 != false && var9_13[var20_35] != 15 && var9_13[var20_35] != 11 && var9_13[var20_35] != 12 && var9_13[var20_35] != 13 && var9_13[var20_35] != 116 && var9_13[var20_35] != 117 && var9_13[var20_35] != 17);
                                var18_33.add((ParameterMetadata)var21_37);
                            }
                            var20_36 = var1_1;
                            if (var17_22) {
                                var1_1 = var15_19.getCopyRewrite();
                            }
                            if (this.m_connection.getStreamingBatchInsert() && var17_22) ** GOTO lbl-1000
                            var21_37 = new VQueryExecutor(this.m_statement, var1_1, var20_36, var4_4, var18_33, var14_18, (List<String>)var3_3, false, var17_22 == false);
                            var23_24 = null;
                            this.m_protocolStream.clearWarningListener();
                        }
                        break block27;
lbl-1000:
                        // 1 sources

                        {
                            var21_37 = new VStreamQueryExecutor(this.m_statement, var1_1, var20_36, var4_4, var18_33, var14_18, (List<String>)var3_3, false, var17_22 == false);
                            var23_25 = null;
                            this.m_protocolStream.clearWarningListener();
                        }
                        break block28;
lbl-1000:
                        // 1 sources

                        {
                            if (this.m_isInternal) {
                                var3_3.add("SELECT");
                            } else {
                                this.m_protocolStream.sendMessage(new ParseRequestMessage(var4_4, var1_1, new int[0]));
                                this.m_protocolStream.sendMessage(new FlushRequestMessage());
                                var6_8 = this.m_protocolStream.readMessage();
                                while (var6_8.getType().equals((Object)MessageType.CommandDescription)) {
                                    var7_11 = ((CommandDescriptionResponseMessage)var6_8).getTag();
                                    if ("COPY_LOCAL".equals(var7_11) && this.m_connection.getDisableCopyLocal() && !this.m_isStdin) {
                                        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_COPY_LOCAL_DISABLED.toString());
                                    }
                                    var3_3.add(var7_11);
                                    var6_8 = this.m_protocolStream.readMessage();
                                }
                                if (var6_8.getType().equals((Object)MessageType.Error)) {
                                    var7_11 = ((ErrorResponseMessage)var6_8).getErrorData();
                                    throw var7_11.buildException();
                                }
                            }
                            var6_8 = new VQueryExecutor(this.m_statement, var1_1, (List<String>)var3_3, var2_2);
                            var23_26 = null;
                            this.m_protocolStream.clearWarningListener();
                        }
                        break block29;
                    }
                    catch (Throwable var24_39) {
                        var25_32 = null;
                        this.m_connection.unlock();
                        throw var24_39;
                    }
                }
                var25_29 = null;
                this.m_connection.unlock();
                return var21_37;
            }
            var25_30 = null;
            this.m_connection.unlock();
            return var21_37;
        }
        var25_31 = null;
        this.m_connection.unlock();
        return var6_8;
    }

    @Override
    public VQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        return this.prepareImpl(string, false);
    }

    @Override
    public VQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        StringBuilder stringBuilder = new StringBuilder(2048);
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
        return this.prepareImpl(stringBuilder.toString(), true);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        IMetadataSource iMetadataSource;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{metadataSourceID, map});
        switch (metadataSourceID) {
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case COLUMNS: 
            case COLUMN_PRIVILEGES: 
            case FOREIGN_KEYS: 
            case PRIMARY_KEYS: 
            case FUNCTIONS_JDBC4: 
            case FUNCTION_COLUMNS_JDBC4: 
            case PROCEDURES: 
            case PROCEDURE_COLUMNS: 
            case SCHEMA_ONLY: 
            case SPECIAL_COLUMNS: 
            case TABLES: 
            case TABLETYPE_ONLY: 
            case TABLE_PRIVILEGES: 
            case TYPE_INFO: {
                iMetadataSource = this.m_connection.getMetadataSource(metadataSourceID, map, string, string2, bl);
                break;
            }
            default: {
                iMetadataSource = new DSIEmptyMetadataSource(this.m_log);
            }
        }
        return iMetadataSource;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (!this.m_connection.getUseStrictCatalogFiltering() && arrayList.size() > 0 && "".equals(arrayList.get(0)) && (MetadataSourceID.TABLES.equals((Object)metadataSourceID) || MetadataSourceID.COLUMNS.equals((Object)metadataSourceID) || MetadataSourceID.CATALOG_SCHEMA_ONLY.equals((Object)metadataSourceID))) {
            arrayList.set(0, null);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
    }
}

