/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

public class OraURIUtil {
    private static final int IPV4LENGTH = 4;
    private static final int IPV6LENGTH = 16;
    private static final int IPV6V4LENGTH = 12;

    public static byte[] parseIPv4ToBytes(String string) {
        char c;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (n == 4) {
                return null;
            }
            c = cArray[i];
            if (c != '.' && (c < '0' || c > '9')) {
                return null;
            }
            if (Character.isDigit(c)) {
                if ((n2 = (n2 & 0xFF) * 10 + (Character.digit(c, 10) & 0xFF)) > 255) {
                    return null;
                }
            } else if (c == '.') {
                byArray[n++] = (byte)(n2 & 0xFF);
                n2 = 0;
            }
            if (i != cArray.length - 1) continue;
            byArray[n] = (byte)(n2 & 0xFF);
        }
        if (n == 3) {
            return byArray;
        }
        byte[] byArray2 = new byte[4];
        c = '\u0003';
        for (int i = n; i >= 0; --i) {
            byArray2[c--] = byArray[i];
        }
        return byArray2;
    }

    public static byte[] parseIPv6ToBytes(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        byte[] byArray = new byte[16];
        char[] cArray = new char[8];
        char[] cArray2 = string.toCharArray();
        int n = cArray2.length;
        if (n == 2 && cArray2[0] == ':' && cArray2[1] == ':') {
            return byArray;
        }
        if (n >= 2 && cArray2[0] == ':' && cArray2[1] != ':') {
            return null;
        }
        if (n >= 3 && string.indexOf("::") != string.lastIndexOf("::")) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            char c = cArray2[i];
            if (!(c == '.' || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == ':')) {
                return null;
            }
            int n5 = Character.digit(c, 16);
            if (n5 != -1) {
                n3 <<= 4;
                if ((n3 |= n5) > 65535) {
                    return null;
                }
            } else if (c == ':') {
                if (i == 0 || i == 1) {
                    n4 = 0;
                } else if (cArray2[i - 1] == ':') {
                    n4 = n2;
                } else {
                    cArray[n2++] = (char)(n3 & 0xFFFF);
                    n3 = 0;
                }
            } else if (c == '.') {
                int n6 = string.lastIndexOf(58);
                if (i < n6) {
                    return null;
                }
                String string2 = string.substring(n6 + 1);
                if (OraURIUtil.countcharnum(string2, '.') != 3) {
                    return null;
                }
                byte[] byArray2 = OraURIUtil.parseIPv4ToBytes(string2);
                if (byArray2 == null) {
                    return null;
                }
                if (n4 != -1) {
                    cArray = OraURIUtil.replacedotdot(cArray, 6, n4, n2);
                }
                byArray = OraURIUtil.chars2bytes(cArray);
                byArray = OraURIUtil.addIPv4ToIPv6(byArray, 12, byArray2);
                return byArray;
            }
            if (i != n - 1) continue;
            if (n4 == -1 && n2 != 7) {
                return null;
            }
            if (c != ':') {
                cArray[n2] = (char)(n3 & 0xFFFF);
                ++n2;
            }
            if (n4 == -1) continue;
            cArray = OraURIUtil.replacedotdot(cArray, 8, n4, n2);
        }
        byArray = OraURIUtil.chars2bytes(cArray);
        return byArray;
    }

    private static char[] replacedotdot(char[] cArray, int n, int n2, int n3) {
        int n4;
        char[] cArray2 = new char[n];
        int n5 = n - n3;
        for (n4 = 0; n4 < n2; ++n4) {
            cArray2[n4] = cArray[n4];
        }
        for (n4 = n2; n4 < n2 + n5; ++n4) {
            cArray2[n4] = '\u0000';
        }
        for (n4 = n2 + n5; n4 < n; ++n4) {
            cArray2[n4] = cArray[n4 - n5];
        }
        return cArray2;
    }

    private static byte[] chars2bytes(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byArray[i * 2] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[i * 2 + 1] = (byte)(cArray[i] & 0xFF);
        }
        return byArray;
    }

    private static int countcharnum(String string, char c) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        return n;
    }

    private static byte[] addIPv4ToIPv6(byte[] byArray, int n, byte[] byArray2) {
        int n2;
        int n3 = byArray2.length;
        byte[] byArray3 = new byte[n + n3];
        for (n2 = 0; n2 < n; ++n2) {
            byArray3[n2] = byArray[n2];
        }
        for (n2 = n; n2 < n + n3; ++n2) {
            byArray3[n2] = byArray2[n2 - n];
        }
        return byArray3;
    }
}

