/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.addons.flexdock.dockbar;

import de.javasoft.synthetica.addons.flexdock.dockbar.SimpleDockbarLayout;
import de.javasoft.synthetica.addons.flexdock.dockbar.SimpleDockbarLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.flexdock.dockbar.Dockbar;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.ViewPane;
import org.flexdock.dockbar.layout.DockbarLayoutManager;
import org.flexdock.util.RootWindow;

public class SimpleDockbarManager
extends DockbarManager {
    private static boolean leftBarInner = false;
    private static boolean rightBarInner = false;
    private static boolean bottomBarInner = true;

    static {
        DockbarLayoutManager.setManager((DockbarLayoutManager)new SimpleDockbarLayoutManager());
    }

    public SimpleDockbarManager(RootWindow rootWindow) {
        super(rootWindow);
        this.dockbarLayout = new SimpleDockbarLayout(this);
        this.leftBar = new Dockbar((DockbarManager)this, 2);
        this.rightBar = new Dockbar((DockbarManager)this, 4);
        this.bottomBar = new Dockbar((DockbarManager)this, 3);
        this.viewPane = new ViewPane((DockbarManager)this);
    }

    public static void setDockbarConstraint(int n, boolean bl) {
        if (n == 2) {
            leftBarInner = bl;
        } else if (n == 4) {
            rightBarInner = bl;
        } else if (n == 3) {
            bottomBarInner = bl;
        }
    }

    public void validate() {
        this.dockbarLayout.layout();
        this.viewPane.revalidate();
    }

    protected void install() {
        RootWindow rootWindow = this.getWindow();
        if (rootWindow == null) {
            return;
        }
        if (rootWindow.getRootContainer() instanceof JDialog && ((JDialog)rootWindow.getRootContainer()).isModal()) {
            return;
        }
        if (rootWindow.getContentPane().getLayout() instanceof BorderLayout) {
            rootWindow.getLayeredPane().add((Component)this.viewPane, DOCKBAR_LAYER);
            this.installDockbar(this.leftBar, "West", leftBarInner);
            this.installDockbar(this.bottomBar, "South", bottomBarInner);
            this.installDockbar(this.rightBar, "East", rightBarInner);
        }
    }

    private boolean installDockbar(Dockbar dockbar, String string, boolean bl) {
        Container container = this.getWindow().getContentPane();
        LayoutManager layoutManager = container.getLayout();
        if (!(layoutManager instanceof BorderLayout)) {
            throw new IllegalStateException("Only BorderLayout for ContentPane is supported!");
        }
        BorderLayout borderLayout = (BorderLayout)layoutManager;
        Component component = borderLayout.getLayoutComponent(string);
        if (component instanceof DockbarContainer) {
            return false;
        }
        if (component != null) {
            container.remove(component);
        }
        String string2 = string;
        if (string.equals("North") && bl) {
            string2 = "South";
        } else if (string.equals("South") && bl) {
            string2 = "North";
        } else if (string.equals("West") && bl) {
            string2 = "East";
        } else if (string.equals("East") && bl) {
            string2 = "West";
        }
        DockbarContainer dockbarContainer = new DockbarContainer();
        if (component != null) {
            dockbarContainer.add(component, "Center");
        }
        dockbarContainer.add((Component)dockbar, string2);
        container.add((Component)dockbarContainer, string);
        return true;
    }

    public JComponent getLayoutComponent(int n) {
        BorderLayout borderLayout = (BorderLayout)this.getDockbar(n).getParent().getLayout();
        return (JComponent)borderLayout.getLayoutComponent("Center");
    }

    private static class DockbarContainer
    extends Container {
        private static final long serialVersionUID = 2621037069903125435L;

        public DockbarContainer() {
            this.setLayout(new BorderLayout());
        }
    }
}

