/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTableCellRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private NumberFormat nf;

    public NumberTableCellRenderer(TableCellRenderer tableCellRenderer, Class<?> clazz, int n, int n2) {
        this.delegate = tableCellRenderer;
        this.nf = NumberFormat.getInstance();
        if (clazz == Float.class || clazz == Double.class) {
            this.nf.setMinimumFractionDigits(n);
            this.nf.setMaximumFractionDigits(n2);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object != null) {
            String string = this.nf.format(object);
            jLabel.setText(string);
            jLabel.setHorizontalAlignment(4);
        }
        return jLabel;
    }
}

