/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import de.javasoft.swing.table.FormattedTextFieldTableCellEditor;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTableCellEditor
extends FormattedTextFieldTableCellEditor {
    private Class<?> dataClass;
    private int minDigits;
    private int maxDigits;

    public NumberTableCellEditor(TableCellEditor tableCellEditor, Class<?> clazz, int n, int n2) {
        super(tableCellEditor);
        this.dataClass = clazz;
        this.minDigits = n;
        this.maxDigits = n2;
        ((JFormattedTextField)this.editorComponent).setFormatterFactory(new DefaultFormatterFactory(new Formatter()));
        ((JFormattedTextField)this.editorComponent).setHorizontalAlignment(4);
    }

    private class Formatter
    extends JFormattedTextField.AbstractFormatter {
        private Formatter() {
        }

        public Object stringToValue(String string) throws ParseException {
            Number number = null;
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                number = numberFormat.parse(string);
                if (NumberTableCellEditor.this.dataClass == Float.class) {
                    number = new Float("" + number);
                } else if (NumberTableCellEditor.this.dataClass == Double.class) {
                    number = new Double("" + number);
                } else if (NumberTableCellEditor.this.dataClass == Integer.class) {
                    number = new Integer("" + number);
                } else if (NumberTableCellEditor.this.dataClass == Long.class) {
                    number = new Long("" + number);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), -1);
            }
            return number;
        }

        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return null;
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (NumberTableCellEditor.this.dataClass == Float.class || NumberTableCellEditor.this.dataClass == Double.class) {
                numberFormat.setMinimumFractionDigits(NumberTableCellEditor.this.minDigits);
                numberFormat.setMaximumFractionDigits(NumberTableCellEditor.this.maxDigits);
            }
            return numberFormat.format(object);
        }
    }
}

