/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.PerspectiveManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RootWindow {
    private static Map<Component, RootWindow> rootWindows = new WeakHashMap<Component, RootWindow>();
    private HashMap<Object, Object> clientProperties;
    private Component root;
    private String perspectiveID = DockingManager.getPerspectiveManager().getCurrentPerspective().getID();

    protected RootWindow(Component component) {
        this.setRootComponent(component);
        this.clientProperties = new HashMap();
    }

    private static Component getRoot(Component component) {
        if (RootWindow.isValidRootContainer(component)) {
            return component;
        }
        Container container = component.getParent();
        while (container != null && !RootWindow.isValidRootContainer(container)) {
            container = container.getParent();
        }
        return container;
    }

    public static RootWindow getRootWindow(Component component) {
        Component component2 = RootWindow.getRoot(component);
        if (!RootWindow.isValidRootContainer(component2)) {
            return null;
        }
        RootWindow rootWindow = rootWindows.get(component2);
        if (rootWindow == null) {
            rootWindow = new RootWindow(component2);
            rootWindows.put(component2, rootWindow);
            if (component2 instanceof Window) {
                ((Window)component2).addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        RootWindow rootWindow = (RootWindow)rootWindows.get(RootWindow.getRoot(windowEvent.getComponent()));
                        if (rootWindow != null) {
                            DockbarManager.removeDockbarManager(rootWindow);
                            DockingPortTracker.remove(rootWindow);
                            rootWindows.remove(windowEvent.getComponent());
                            ((Window)rootWindow.root).removeWindowListener(this);
                            rootWindow.root = null;
                        }
                    }

                    public void windowActivated(WindowEvent windowEvent) {
                        String string = RootWindow.getRootWindow(windowEvent.getComponent()).getPerspectiveID();
                        boolean bl = PerspectiveManager.getInstance().perspectiveIsValid(string);
                        PerspectiveManager.setCurrentPerspectiveID(bl ? string : "PerspectiveManager.DefaultPerspective");
                    }
                });
            }
        }
        if (rootWindow.getRootComponent() != component2) {
            rootWindow.setRootComponent(component2);
        }
        return rootWindow;
    }

    public void setPerspectiveID(String string) {
        this.perspectiveID = string;
    }

    public String getPerspectiveID() {
        return this.perspectiveID;
    }

    public boolean isAlive() {
        return rootWindows.containsValue(this);
    }

    public static boolean isValidRootContainer(Component component) {
        return component != null && (component instanceof JFrame || component instanceof JApplet || component instanceof JWindow || component instanceof JDialog);
    }

    public static RootWindow[] getVisibleWindows() {
        Frame[] frameArray = Frame.getFrames();
        ArrayList<RootWindow> arrayList = new ArrayList<RootWindow>(frameArray.length);
        int n = 0;
        while (n < frameArray.length) {
            RootWindow.populateWindowList(new RootWindow(frameArray[n]), arrayList, true);
            ++n;
        }
        return arrayList.toArray(new RootWindow[0]);
    }

    private static void populateWindowList(RootWindow rootWindow, ArrayList<RootWindow> arrayList, boolean bl) {
        if (rootWindow == null || arrayList.contains(rootWindow)) {
            return;
        }
        if (bl && !rootWindow.getRootComponent().isVisible()) {
            return;
        }
        arrayList.add(rootWindow);
        Window[] windowArray = rootWindow.getOwnedWindows();
        int n = 0;
        while (n < windowArray.length) {
            RootWindow.populateWindowList(new RootWindow(windowArray[n]), arrayList, bl);
            ++n;
        }
    }

    public Container getContentPane() {
        Container container = null;
        if (this.root instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)this.root)).getContentPane();
        }
        return container;
    }

    public Component getGlassPane() {
        Component component = null;
        if (this.root instanceof RootPaneContainer) {
            component = ((RootPaneContainer)((Object)this.root)).getGlassPane();
        }
        return component;
    }

    public JLayeredPane getLayeredPane() {
        JLayeredPane jLayeredPane = null;
        if (this.root instanceof RootPaneContainer) {
            jLayeredPane = ((RootPaneContainer)((Object)this.root)).getLayeredPane();
        }
        return jLayeredPane;
    }

    protected void setRootComponent(Component component) {
        this.root = component;
    }

    public Component getRootComponent() {
        return this.root;
    }

    public JRootPane getRootPane() {
        JRootPane jRootPane = null;
        if (this.root instanceof RootPaneContainer) {
            jRootPane = ((RootPaneContainer)((Object)this.root)).getRootPane();
        }
        return jRootPane;
    }

    public void revalidateContentPane() {
        Container container = this.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).revalidate();
        }
    }

    public void setContentPane(Container container) {
        if (this.root instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.root)).setContentPane(container);
        }
    }

    public void setGlassPane(Component component) {
        if (this.root instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.root)).setGlassPane(component);
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (this.root instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.root)).setLayeredPane(jLayeredPane);
        }
    }

    public Window[] getOwnedWindows() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getOwnedWindows();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getOwnedWindows();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getOwnedWindows();
        }
        return new Window[0];
    }

    public void pack() {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).pack();
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).pack();
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).pack();
        }
    }

    public void toFront() {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).toFront();
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).toFront();
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).toFront();
        }
    }

    public boolean isActive() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).isActive();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).isActive();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).isActive();
        }
        return false;
    }

    public Window getOwner() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getOwner();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getOwner();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getOwner();
        }
        return null;
    }

    public void putClientProperty(Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (object2 == null) {
            this.clientProperties.remove(object);
        } else {
            this.clientProperties.put(object, object2);
        }
    }

    public Object getClientProperty(Object object) {
        return object == null ? null : this.clientProperties.get(object);
    }
}

