/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class ResizeListener
extends MouseAdapter
implements MouseMotionListener {
    private static final int MINIMUM_VIEW_SIZE = 60;
    private DockbarManager manager;
    private IDockable dockable;
    private JPanel dragGlassPane;
    private Component cachedGlassPane;
    private RootWindow rootWindow;
    private int xOffset;
    private int yOffset;

    public ResizeListener(DockbarManager dockbarManager) {
        this.manager = dockbarManager;
        this.dragGlassPane = new JPanel();
        this.dragGlassPane.setOpaque(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dockable = this.manager.getActiveDockable();
        this.rootWindow = this.manager.getWindow();
        this.cachedGlassPane = this.rootWindow.getGlassPane();
        this.rootWindow.setGlassPane(this.dragGlassPane);
        this.dragGlassPane.setCursor(this.manager.getResizeCursor());
        this.dragGlassPane.setVisible(true);
        this.manager.setDragging(true);
        int n = this.manager.getActivePlacement();
        Rectangle rectangle = this.manager.getSlidePanel().getBounds();
        Point point = new Point(rectangle.x, rectangle.y);
        if (n == 2) {
            point.x += rectangle.width;
        }
        SwingUtilities.convertPointToScreen(point, this.manager.getSlidePanel().getParent());
        Point point2 = new Point(mouseEvent.getPoint());
        SwingUtilities.convertPointToScreen(point2, mouseEvent.getComponent());
        this.xOffset = n == 3 ? 0 : point.x - point2.x;
        this.yOffset = n == 3 ? point.y - point2.y : 0;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dockable = null;
        this.dragGlassPane.setVisible(false);
        this.manager.setDragging(false);
        if (this.rootWindow != null && this.cachedGlassPane != null) {
            this.rootWindow.setGlassPane(this.cachedGlassPane);
            this.cachedGlassPane = null;
            this.rootWindow = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dockable != null) {
            this.handleResizeEvent(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void handleResizeEvent(MouseEvent mouseEvent) {
        Rectangle rectangle = this.manager.getDockbarLayout().getViewArea(this.manager, this.dockable);
        Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, this.manager.getSlidePanel().getRootPane().getLayeredPane());
        Point point2 = new Point(mouseEvent.getPoint());
        SwingUtilities.convertPointToScreen(point2, mouseEvent.getComponent());
        Point point3 = new Point(point2.x - point.x + this.xOffset, point2.y - point.y + this.yOffset);
        int n = this.manager.getActivePlacement();
        if (n == 4) {
            point3.x = rectangle.width - point3.x;
        } else if (n == 3) {
            point3.y = rectangle.height - point3.y;
        }
        point3.x = Math.max(point3.x, 0);
        point3.x = Math.min(point3.x, rectangle.width);
        point3.y = Math.max(point3.y, 0);
        point3.y = Math.min(point3.y, rectangle.height);
        float f = n == 3 ? point3.y : point3.x;
        float f2 = n == 3 ? rectangle.height : rectangle.width;
        float f3 = f / f2;
        float f4 = 60.0f / f2;
        f3 = Math.max(f3, f4);
        this.dockable.setPreviewSize(f3);
        this.manager.revalidate();
    }
}

