/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.ActiveDockableTracker;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPath;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.FloatingGroup;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockableFactory;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDockingStrategy;
import de.javasoft.swing.jydocking.ILayoutNode;
import de.javasoft.swing.jydocking.IPerspectiveModelListener;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveManager;
import de.javasoft.swing.jydocking.PerspectiveModelEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveModel
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5464430338438274555L;
    private HashMap<String, DockingState> dockingStates = new HashMap();
    private HashMap<String, FloatingGroup> floatingGroups = new HashMap();
    private ILayoutNode restorationLayout;
    private List<DockingState> dockableSequence = new ArrayList<DockingState>();
    private List<IPerspectiveModelListener> listeners = new ArrayList<IPerspectiveModelListener>();

    public PerspectiveModel() {
    }

    private PerspectiveModel(HashMap<String, DockingState> hashMap, HashMap<String, FloatingGroup> hashMap2, List<IPerspectiveModelListener> list, List<DockingState> list2) {
        this();
        this.dockingStates = hashMap;
        this.floatingGroups = hashMap2;
        this.listeners = list;
        this.dockableSequence = list2;
    }

    public void addModelListener(IPerspectiveModelListener iPerspectiveModelListener) {
        this.listeners.add(iPerspectiveModelListener);
    }

    public void removeModelListener(IPerspectiveModelListener iPerspectiveModelListener) {
        this.listeners.remove(iPerspectiveModelListener);
    }

    public IPerspectiveModelListener[] getModelListeners() {
        return this.listeners.toArray(new IPerspectiveModelListener[0]);
    }

    private void addState(IDockable iDockable) {
        this.addState(iDockable.getID());
    }

    private void addState(String string) {
        if (string == null) {
            throw new IllegalStateException("dockableID can't be null");
        }
        if (this.dockingStates.containsKey(string)) {
            return;
        }
        this.setDockingState(string, new DockingState(string));
        this.dispatchEvent(new PerspectiveModelEvent(this, string, 4));
    }

    public DockingState removeDockingState(String string) {
        DockingState dockingState = this.dockingStates.remove(string);
        if (dockingState != null) {
            this.dispatchEvent(new PerspectiveModelEvent(this, string, 5));
        }
        return dockingState;
    }

    public void setDockingState(String string, DockingState dockingState) {
        this.dockingStates.put(string, dockingState);
    }

    public FloatingGroup removeFloatingGroup(String string) {
        return this.floatingGroups.remove(string);
    }

    public boolean contains(IDockable iDockable) {
        return iDockable == null ? false : this.contains(iDockable.getID());
    }

    public boolean contains(String string) {
        return string == null ? false : this.dockingStates.containsKey(string);
    }

    public IDockable getDockable(String string) {
        if (this.dockingStates.containsKey(string)) {
            return DockingManager.getDockable(string);
        }
        return null;
    }

    public IDockable[] getDockables() {
        ArrayList<IDockable> arrayList = new ArrayList<IDockable>(this.dockingStates.size());
        for (String string : this.dockingStates.keySet()) {
            IDockable iDockable = PerspectiveModel.findDockable(string);
            if (iDockable == null) continue;
            arrayList.add(iDockable);
        }
        return arrayList.toArray(new IDockable[0]);
    }

    private static IDockable findDockable(String string) {
        IDockable iDockable = DockingManager.getDockable(string);
        IDockableFactory iDockableFactory = DockingManager.getDockableFactory();
        if (iDockable == null && iDockableFactory != null) {
            iDockable = iDockableFactory.getDockable(string);
            DockingManager.registerDockable(iDockable);
        }
        return iDockable;
    }

    public DockingState getDockingState(IDockable iDockable, boolean bl) {
        return this.getDockingState(iDockable.getID(), bl);
    }

    public DockingState getDockingState(String string, boolean bl) {
        Object object;
        if (string == null) {
            return null;
        }
        if (bl && (object = DockingManager.getDockable(string)) != null) {
            this.isMaintained((IDockable)object);
        }
        object = this.dockingStates.get(string);
        return (DockingState)object;
    }

    public void apply(IDockingPort iDockingPort, Perspective perspective) {
        JComponent jComponent = iDockingPort.getComponent();
        if (jComponent == null || !this.isInitialized()) {
            return;
        }
        PerspectiveManager.clear(iDockingPort);
        DockingPath dockingPath = this.getDockingState(this.getDockables()[0], false).getPath();
        if (dockingPath != null) {
            iDockingPort.setID(dockingPath.getRootPortId());
        }
        boolean bl = PerspectiveManager.isDockingStateListening();
        PerspectiveManager.setDockingStateListening(false);
        iDockingPort.importLayout(this.restorationLayout);
        PerspectiveManager.setDockingStateListening(bl);
        IDockable[] iDockableArray = this.getDockables();
        ArrayList<IDockable> arrayList = new ArrayList<IDockable>();
        boolean bl2 = DockingUtility.getActiveWindow() == null;
        boolean bl3 = PerspectiveManager.isRestoreFloatingOnLoad();
        IDockable iDockable = null;
        ArrayList<IDockable> arrayList2 = new ArrayList<IDockable>();
        Object object = iDockableArray;
        int n = iDockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockable iDockable2 = object[n2];
            DockingState dockingState = this.getDockingState(iDockable2, false);
            if (dockingState.isMinimized()) {
                if (bl2) {
                    arrayList.add(iDockable2);
                } else {
                    DockingManager.setMinimized(iDockable2, perspective, true, dockingState.getPlacement());
                }
            } else if (bl3 && dockingState.isFloating()) {
                if (!DockingManager.isFloating(iDockable2)) {
                    DockingManager.setFloating(iDockable2, perspective, true, null);
                    ILayoutNode iLayoutNode = this.getFloatingGroup(dockingState.getFloatingGroupID()).getRestorationLayout();
                    if (iLayoutNode != null && iLayoutNode.getChildCount() == 1) {
                        DockingManager.getRootDockingPort(iDockable2.getComponent()).importLayout(iLayoutNode);
                    }
                }
            } else if (dockingState.isMaximized()) {
                DockingManager.setMaximized(iDockable2, perspective, true);
            }
            if (dockingState.isSelected()) {
                arrayList2.add(iDockable2);
            }
            if (dockingState.isActive()) {
                iDockable = iDockable2;
            }
            ++n2;
        }
        this.restoreDeferredMinimizedDockables(arrayList);
        for (IDockable iDockable2 : arrayList2) {
            JComponent jComponent2 = iDockable2.getComponent();
            object = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, jComponent2);
            if (object == null) continue;
            try {
                ((JTabbedPane)object).setSelectedComponent(jComponent2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (iDockable != null) {
            ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), true);
        }
        this.dispatchEvent(new PerspectiveModelEvent(this, null, 0));
    }

    private void restoreMinimizedDockables(ArrayList<IDockable> arrayList) {
        if (DockingUtility.getActiveWindow() == null) {
            this.restoreDeferredMinimizedDockables(arrayList);
            return;
        }
        Perspective perspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        for (IDockable iDockable : arrayList) {
            DockingManager.setMinimized(iDockable, perspective, true, this.getDockingState(iDockable, false).getPlacement());
        }
    }

    private void restoreDeferredMinimizedDockables(final ArrayList<IDockable> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PerspectiveModel.this.restoreMinimizedDockables(arrayList);
            }
        });
    }

    private boolean isMaintained(IDockable iDockable) {
        if (!this.contains(iDockable)) {
            this.addState(iDockable);
        }
        return true;
    }

    public void hide(IDockable iDockable) {
        if (!this.isMaintained(iDockable)) {
            return;
        }
        boolean bl = false;
        if (DockingManager.isDocked(iDockable)) {
            bl = DockingManager.undock(iDockable);
        } else if (DockingManager.isMinimized(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective())) {
            bl = DockingManager.getMinimizeManager().close(iDockable);
        }
        if (bl) {
            this.dispatchEvent(new PerspectiveModelEvent(this, iDockable.getID(), 2));
        }
    }

    public void show(IDockable iDockable, IDockingPort iDockingPort) {
        if (!this.isMaintained(iDockable) || DockingManager.isDocked(iDockable)) {
            return;
        }
    }

    public FloatingGroup getGroup(String string) {
        return string == null ? null : this.floatingGroups.get(string);
    }

    public String[] getFloatingGroupIDs() {
        return this.floatingGroups.keySet().toArray(new String[0]);
    }

    public FloatingGroup getFloatingGroup(String string) {
        return this.floatingGroups.get(string);
    }

    public void addFloatingGroup(FloatingGroup floatingGroup) {
        if (floatingGroup == null) {
            return;
        }
        this.floatingGroups.put(floatingGroup.getID(), floatingGroup);
    }

    public boolean isInitialized() {
        return this.restorationLayout != null;
    }

    public ILayoutNode getRestorationLayout() {
        return this.restorationLayout;
    }

    public void setRestorationLayout(ILayoutNode iLayoutNode) {
        this.restorationLayout = iLayoutNode;
    }

    void updateDockingStates() {
        for (DockingState dockingState : this.getDockableSequenceClone()) {
            this.dockingStates.put(dockingState.getDockableID(), dockingState);
        }
    }

    public Object clone() {
        Object object;
        Object object2;
        ArrayList arrayList = (ArrayList)((ArrayList)this.listeners).clone();
        HashMap hashMap = (HashMap)this.dockingStates.clone();
        for (String object32 : this.dockingStates.keySet()) {
            object2 = this.getDockingState(object32, false);
            hashMap.put(object32, (DockingState)((DockingState)object2).clone());
        }
        HashMap hashMap2 = (HashMap)this.floatingGroups.clone();
        object2 = this.floatingGroups.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            FloatingGroup floatingGroup = this.floatingGroups.get(object);
            hashMap2.put(object, (FloatingGroup)floatingGroup.clone());
        }
        object = new PerspectiveModel(hashMap, hashMap2, arrayList, this.getDockableSequenceClone());
        ((PerspectiveModel)object).restorationLayout = object2 = this.restorationLayout == null ? null : (ILayoutNode)this.restorationLayout.clone();
        return object;
    }

    List<DockingState> getDockableSequence() {
        return this.getDockableSequenceClone();
    }

    void setDockableSequence(List<DockingState> list) {
        this.dockableSequence = list;
    }

    public void add(IDockable iDockable) {
        this.add(iDockable.getID());
    }

    void add(String string) {
        this.add(string, null);
    }

    void add(String string, String string2) {
        this.add(string, string2, "CENTER", -1.0f);
    }

    public void add(IDockable iDockable, IDockable iDockable2, String string, float f) {
        String string2 = iDockable == null ? null : iDockable.getID();
        String string3 = iDockable2 == null ? null : iDockable2.getID();
        this.add(string2, string3, string, f);
    }

    void add(String string, String string2, String string3, float f) {
        if (string2 == null && this.dockableSequence.size() > 0) {
            throw new IllegalStateException("All calls to add() after the first dockable has been added MUST specify a relative dockable parent.");
        }
        DockingState dockingState = new DockingState(string);
        dockingState.setRelativeParentID(string2);
        dockingState.setRegion(string3);
        dockingState.setSplitRatio(f);
        this.dockableSequence.add(dockingState);
    }

    public void remove(String string) {
        this.removeDockingState(string);
        for (DockingState dockingState : this.dockableSequence) {
            if (!dockingState.getDockableID().equals(string)) continue;
            this.dockableSequence.remove(dockingState);
            break;
        }
    }

    private List<DockingState> getDockableSequenceClone() {
        ArrayList<DockingState> arrayList = new ArrayList<DockingState>(this.dockableSequence.size());
        for (DockingState dockingState : this.dockableSequence) {
            arrayList.add((DockingState)dockingState.clone());
        }
        return arrayList;
    }

    public void dispatchEvent(PerspectiveModelEvent perspectiveModelEvent) {
        for (IPerspectiveModelListener iPerspectiveModelListener : this.listeners) {
            switch (perspectiveModelEvent.getEventType()) {
                case 2: {
                    iPerspectiveModelListener.dockableHidden(perspectiveModelEvent);
                    break;
                }
                case 3: {
                    iPerspectiveModelListener.dockableDisplayed(perspectiveModelEvent);
                    break;
                }
                case 0: {
                    iPerspectiveModelListener.modelApplied(perspectiveModelEvent);
                    break;
                }
                case 1: {
                    iPerspectiveModelListener.modelEmptied(perspectiveModelEvent);
                    break;
                }
                case 4: {
                    iPerspectiveModelListener.stateAdded(perspectiveModelEvent);
                    break;
                }
                case 5: {
                    iPerspectiveModelListener.stateRemoved(perspectiveModelEvent);
                }
            }
        }
    }

    static class DockableNode
    extends DockingNode {
        private static final long serialVersionUID = 3725121216737471819L;
        private String dockableID;

        public DockableNode() {
        }

        private DockableNode(String string) {
            this.dockableID = string;
        }

        public String getDockableID() {
            return this.dockableID;
        }

        public void setDockableID(String string) {
            this.dockableID = string;
        }

        public IDockable getDockable() {
            return PerspectiveModel.findDockable(this.dockableID);
        }

        public void add(MutableTreeNode mutableTreeNode) {
        }

        public Object getDockingObject() {
            return this.getDockable();
        }

        protected DockingNode shallowClone() {
            return new DockableNode(this.dockableID);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("DockableNode[");
            stringBuffer.append("id=").append(this.getDockableID()).append("; ");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    static abstract class DockingNode
    extends DefaultMutableTreeNode
    implements ILayoutNode,
    IDockingConstants {
        private static final long serialVersionUID = -7294513608480374203L;

        DockingNode() {
        }

        public Object getUserObject() {
            Object object = super.getUserObject();
            if (object == null) {
                object = this.getDockingObject();
                this.setUserObject(object);
            }
            return object;
        }

        public abstract Object getDockingObject();

        protected abstract DockingNode shallowClone();

        public Object clone() {
            return this.deepClone();
        }

        public DockingNode deepClone() {
            DockingNode dockingNode = this.shallowClone();
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                DockingNode dockingNode2 = (DockingNode)enumeration.nextElement();
                dockingNode.add(dockingNode2.deepClone());
            }
            return dockingNode;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class DockingPortNode
    extends DockingNode {
        private static final long serialVersionUID = -3421808775600227426L;

        DockingPortNode() {
        }

        public Object getDockingObject() {
            TreeNode treeNode = this.getParent();
            if (!(treeNode instanceof SplitNode)) {
                return null;
            }
            TreeNode treeNode2 = treeNode.getParent();
            if (!(treeNode2 instanceof DockingPortNode)) {
                return null;
            }
            IDockingPort iDockingPort = (IDockingPort)((DockingPortNode)treeNode2).getUserObject();
            IDockingStrategy iDockingStrategy = iDockingPort.getDockingStrategy();
            return iDockingStrategy.createDockingPort(iDockingPort);
        }

        public IDockingPort getDockingPort() {
            return (IDockingPort)this.getUserObject();
        }

        public boolean isSplit() {
            int n = this.getChildCount();
            if (n != 1) {
                return false;
            }
            return this.getChildAt(0) instanceof SplitNode;
        }

        protected DockingNode shallowClone() {
            return new DockingPortNode();
        }
    }

    static class SplitNode
    extends DockingNode {
        private static final long serialVersionUID = -2640096750924868595L;
        private int orientation;
        private int region;
        private float splitRatio;
        private String siblingId;
        private String dockingRegion;

        public SplitNode(int n, int n2, float f, String string) {
            this.orientation = n;
            this.region = n2;
            this.splitRatio = f;
            this.siblingId = string;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int n) {
            this.orientation = n;
        }

        public float getSplitRatio() {
            return this.splitRatio;
        }

        public void setSplitRatio(float f) {
            this.splitRatio = f;
        }

        public int getRegion() {
            return this.region;
        }

        public void setRegion(int n) {
            this.region = n;
        }

        public String getSiblingId() {
            return this.siblingId;
        }

        public void setSiblingId(String string) {
            this.siblingId = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("SplitNode[");
            stringBuffer.append("orient=").append(this.getOrientationDesc()).append("; ");
            stringBuffer.append("region=").append(this.getRegionDesc()).append("; ");
            stringBuffer.append("percent=").append(this.splitRatio).append("%;");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public String getRegionDesc() {
            switch (this.region) {
                case 1: {
                    return "top";
                }
                case 3: {
                    return "bottom";
                }
                case 4: {
                    return "right";
                }
            }
            return "left";
        }

        public String getOrientationDesc() {
            return this.orientation == 0 ? "vertical" : "horizontal";
        }

        public Object clone() {
            return new SplitNode(this.orientation, this.region, this.splitRatio, this.siblingId);
        }

        public String getDockingRegion() {
            return this.dockingRegion;
        }

        public void setDockingRegion(String string) {
            this.dockingRegion = string;
        }

        public Object getDockingObject() {
            if (this.dockingRegion == null) {
                return null;
            }
            if (!(this.getParent() instanceof DockingPortNode)) {
                return null;
            }
            DockingPortNode dockingPortNode = (DockingPortNode)this.getParent();
            Object object = dockingPortNode.getUserObject();
            if (!(object instanceof IDockingPort)) {
                return null;
            }
            IDockingPort iDockingPort = (IDockingPort)object;
            IDockingStrategy iDockingStrategy = iDockingPort.getDockingStrategy();
            return iDockingStrategy.createSplitPane(iDockingPort, this.dockingRegion);
        }

        public JSplitPane getSplitPane() {
            return (JSplitPane)this.getUserObject();
        }

        public Component getLeftComponent() {
            return this.getChildComponent(0);
        }

        public Component getRightComponent() {
            return this.getChildComponent(1);
        }

        private Component getChildComponent(int n) {
            ILayoutNode iLayoutNode = this.getChild(n);
            Component component = iLayoutNode == null ? null : (Component)iLayoutNode.getUserObject();
            return component;
        }

        private ILayoutNode getChild(int n) {
            if (n >= this.getChildCount()) {
                return null;
            }
            return (ILayoutNode)this.getChildAt(n);
        }

        protected DockingNode shallowClone() {
            SplitNode splitNode = new SplitNode(this.orientation, this.region, this.splitRatio, this.siblingId);
            splitNode.dockingRegion = this.dockingRegion;
            return splitNode;
        }
    }
}

