/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.XMenuSeparator;
import de.javasoft.util.OS;
import java.awt.Point;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class XSubmenu
extends JMenu {
    public XSubmenu() {
        this.init();
    }

    public XSubmenu(String string) {
        super(string);
        this.init();
    }

    public XSubmenu(Action action) {
        super(action);
        this.init();
    }

    private void init() {
        this.setName("XSubmenu");
        this.putClientProperty("Synthetica.menu.toplevel", true);
    }

    protected Point getPopupMenuOrigin() {
        Point point = super.getPopupMenuOrigin();
        JPopupMenu jPopupMenu = this.getPopupMenu();
        point.x += this.getPopupXOffset(jPopupMenu, point);
        point.y += this.getPopupYOffset(jPopupMenu, point);
        return point;
    }

    protected int getPopupXOffset(JPopupMenu jPopupMenu, Point point) {
        int n = SyntheticaLookAndFeel.getInt("XSubmenu.popupOffsetX", this, 0);
        if (!this.getComponentOrientation().isLeftToRight()) {
            n = -n;
        }
        if (SyntheticaLookAndFeel.getBoolean("XSubmenu.centerPopup", this)) {
            n += -jPopupMenu.getPreferredSize().width / 2 + this.getSize().width / 2 - point.x;
        }
        return n;
    }

    protected int getPopupYOffset(JPopupMenu jPopupMenu, Point point) {
        int n = 0;
        return n + SyntheticaLookAndFeel.getInt("XSubmenu.popupOffsetY", this, 0);
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = super.getPopupMenu();
        if (!"XMenuPopup".equals(jPopupMenu.getName())) {
            jPopupMenu.setName("XMenuPopup");
            if (SyntheticaLookAndFeel.getBoolean("XMenuPopup.useHorizontalLayout", jPopupMenu)) {
                jPopupMenu.setLayout(new BoxLayout(jPopupMenu, 2));
            }
            if (OS.getCurrentOS() != OS.Mac && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-out.enabled", jPopupMenu)) {
                jPopupMenu.setOpaque(SyntheticaLookAndFeel.getBoolean("XMenuPopup.opaque", jPopupMenu, true));
            }
        }
        return jPopupMenu;
    }

    public boolean isTopLevelMenu() {
        return false;
    }

    public void addSeparator() {
        if (SyntheticaLookAndFeel.getBoolean("XSubmenu.useJMenuSeparator", this, true)) {
            super.addSeparator();
        } else {
            this.add(new XMenuSeparator(SyntheticaLookAndFeel.getBoolean("XMenuPopup.useHorizontalLayout", this.getPopupMenu()) ? 1 : 0));
        }
    }
}

