/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SizeRequirements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlapBoxLayout<T extends Component>
implements LayoutManager2 {
    private Container container;
    private Axis axis;
    private Class<T> childClass;
    private ComponentFilter filter;
    private int overlapSize;
    private boolean spaceForInvisibleComponentsRetained;
    private ArrayList<T> components;
    private int hAlign;
    private int vAlign;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;

    public OverlapBoxLayout(Container container, Axis axis, Class<T> clazz) {
        this(container, axis, clazz, new ComponentFilter());
    }

    public OverlapBoxLayout(Container container, Axis axis, Class<T> clazz, ComponentFilter componentFilter) {
        this.container = container;
        this.childClass = clazz;
        this.axis = axis;
        this.filter = componentFilter;
        this.components = new ArrayList();
        this.hAlign = 2;
        this.vAlign = 1;
    }

    public final Container getContainer() {
        return this.container;
    }

    public List<T> getComponents() {
        return this.components;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    public void setOverlapSize(int n) {
        this.overlapSize = n;
    }

    public int getOverlapSize() {
        return this.overlapSize;
    }

    public void setSpaceForInvisibleComponentsRetained(boolean bl) {
        this.spaceForInvisibleComponentsRetained = bl;
    }

    public boolean isSpaceForInvisibleComponentsRetained() {
        return this.spaceForInvisibleComponentsRetained;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (this.filter.accept(component, this.childClass, null)) {
            this.components.add(component);
        }
        this.invalidateLayout(component.getParent());
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.components.remove(component);
        this.invalidateLayout(component.getParent());
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (this.filter.accept(component, this.childClass, object)) {
            if (object instanceof Integer) {
                this.components.add((Integer)object, component);
            } else {
                this.components.add(component);
            }
        }
        this.invalidateLayout(component.getParent());
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        this.checkContainer(container);
        this.checkRequests();
        int n4 = this.components.size();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        Axis axis = this.resolveAxis(this.axis, componentOrientation.isHorizontal());
        boolean bl = axis == Axis.X;
        boolean bl2 = !bl || bl && componentOrientation.isLeftToRight();
        boolean bl3 = bl2 = axis != this.axis ? bl2 : true;
        if (bl) {
            SizeRequirements.calculateTiledPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2, bl2);
            SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        } else {
            SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2, bl2);
            SizeRequirements.calculateTiledPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        }
        int n5 = !bl || this.hAlign == 2 ? 0 : (n3 = (dimension.width - this.xTotal.preferred) / (this.hAlign == 0 ? 2 : 1));
        int n6 = bl || this.vAlign == 1 ? 0 : (n2 = (dimension.height - this.yTotal.preferred) / (this.vAlign == 0 ? 2 : 1));
        if (!bl2) {
            n3 *= -1;
        }
        int n7 = 0;
        while (n7 < n4) {
            Component component = (Component)this.components.get(n7);
            n = this.getOverlap(n4, n7, bl2);
            int n8 = bl ? n : 0;
            int n9 = bl ? 0 : n;
            this.setComponentBounds(component, (int)Math.min((long)insets.left + (long)nArray[n7] + (long)n8 + (long)n3, Integer.MAX_VALUE), (int)Math.min((long)insets.top + (long)nArray3[n7] + (long)n9 + (long)n2, Integer.MAX_VALUE), nArray2[n7] - n8, nArray4[n7] - n9);
            ++n7;
        }
        Component[] componentArray = container.getComponents();
        n = componentArray.length;
        int n10 = 0;
        while (n10 < n) {
            Component component = componentArray[n10];
            if (!this.components.contains(component)) {
                component.setBounds(new Rectangle());
            }
            ++n10;
        }
    }

    protected void setComponentBounds(T t, int n, int n2, int n3, int n4) {
        ((Component)t).setBounds(n, n2, n3, n4);
    }

    void checkContainer(Container container) {
        if (this.container != container) {
            throw new AWTError("OverlapBoxLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            ComponentOrientation componentOrientation = this.container.getComponentOrientation();
            Axis axis = this.resolveAxis(this.axis, componentOrientation.isHorizontal());
            boolean bl = axis == Axis.X;
            boolean bl2 = !bl || bl && componentOrientation.isLeftToRight();
            bl2 = axis != this.axis ? bl2 : true;
            int n = this.components.size();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            int n2 = 0;
            while (n2 < n) {
                Component component = (Component)this.components.get(n2);
                if (!component.isVisible() && !this.spaceForInvisibleComponentsRetained) {
                    this.xChildren[n2] = new SizeRequirements(0, 0, 0, component.getAlignmentX());
                    this.yChildren[n2] = new SizeRequirements(0, 0, 0, component.getAlignmentY());
                } else {
                    Dimension dimension = component.getMinimumSize();
                    Dimension dimension2 = component.getPreferredSize();
                    Dimension dimension3 = component.getMaximumSize();
                    int n3 = this.getOverlap(n, n2, bl2);
                    int n4 = bl ? n3 : 0;
                    int n5 = bl ? 0 : n3;
                    this.xChildren[n2] = new SizeRequirements(dimension.width + n4, dimension2.width + n4, dimension3.width + n4, component.getAlignmentX());
                    this.yChildren[n2] = new SizeRequirements(dimension.height + n5, dimension2.height + n5, dimension3.height + n5, component.getAlignmentY());
                }
                ++n2;
            }
            if (bl) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    private int getOverlap(int n, int n2, boolean bl) {
        if (bl) {
            int n3 = 0;
            if (!this.isSpaceForInvisibleComponentsRetained()) {
                int n4 = 0;
                while (n4 < n) {
                    Component component = (Component)this.components.get(n4);
                    if (component.isVisible()) {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
            }
            return n2 > n3 ? this.overlapSize : 0;
        }
        return n2 < n - 1 ? this.overlapSize : 0;
    }

    private Axis resolveAxis(Axis axis, boolean bl) {
        Axis axis2 = axis == Axis.LINE ? (bl ? Axis.X : Axis.Y) : (axis == Axis.PAGE ? (bl ? Axis.Y : Axis.X) : axis);
        return axis2;
    }

    public void setHorizontalAlignment(int n) {
        this.hAlign = n;
    }

    public int getHorizontalAlignment() {
        return this.hAlign;
    }

    public void setVerticalAlignment(int n) {
        this.vAlign = n;
    }

    public int getVerticalAlignment() {
        return this.vAlign;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X,
        Y,
        PAGE,
        LINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentFilter {
        public boolean accept(Component component, Class<?> clazz, Object object) {
            return clazz.isInstance(component);
        }
    }
}

