/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.UIValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicMenuItemUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYPopupMenu
extends JPopupMenu
implements IUIPropertySupport,
PropertyChangeListener {
    private static final long serialVersionUID = -7295789498551615230L;
    private JScrollPane scroller;
    private MenuElementPanel menuElementPanel = new MenuElementPanel();
    private UIValue<Integer> visibleElements;
    private int scrollBarGap;
    private KeyHandler keyHandler;

    public JYPopupMenu() {
        this.scroller = new JScrollPane(this.menuElementPanel){
            private static final long serialVersionUID = -3035272695393060772L;

            public Dimension getPreferredSize() {
                int n = JYPopupMenu.this.getVisibleElements();
                int n2 = JYPopupMenu.this.menuElementPanel.getComponentCount();
                int n3 = 0;
                int n4 = Math.min(n2, n);
                while (n4 > 0) {
                    n3 += ((JYPopupMenu)JYPopupMenu.this).menuElementPanel.getComponent((int)(n4 - 1)).getPreferredSize().height;
                    --n4;
                }
                n4 = n2 > n ? ((JYPopupMenu)JYPopupMenu.this).scroller.getVerticalScrollBar().getPreferredSize().width : 0;
                return new Dimension(((JYPopupMenu)JYPopupMenu.this).menuElementPanel.getPreferredSize().width + n4, n3);
            }
        };
        this.scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scroller.getViewport().setOpaque(false);
        this.scroller.setOpaque(false);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setVerticalScrollBarPolicy(20);
        this.add(this.scroller);
        this.keyHandler = new KeyHandler();
        this.addPropertyChangeListener(this);
    }

    @Override
    public JMenuItem add(JMenuItem jMenuItem) {
        this.add((Component)jMenuItem);
        return jMenuItem;
    }

    @Override
    public Component add(Component component) {
        if (component instanceof MenuElement || component instanceof JSeparator) {
            return this.menuElementPanel.add(component);
        }
        return super.add(component);
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
        super.menuSelectionChanged(bl);
    }

    @Override
    public void show(Component component, int n, int n2) {
        super.show(component, n, n2);
    }

    @Override
    public void updateUI() {
        this.updateUIDefaults();
        super.updateUI();
    }

    private void updateUIDefaults() {
        if (this.visibleElementsIsUIResource()) {
            this.setVisibleElements(SyntheticaLookAndFeel.getInt("JYPopupMenu.visibleElements", this, 20), true);
        }
        this.scrollBarGap = SyntheticaLookAndFeel.getInt("JYPopupMenu.scrollBarGap", this, 2);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            MenuSelectionManager.defaultManager().addChangeListener(this.keyHandler);
        } else {
            MenuSelectionManager.defaultManager().removeChangeListener(this.keyHandler);
            this.keyHandler.uninstall();
        }
        Component component = this.getInvoker();
        if (bl && component != null) {
            MenuElement[] menuElementArray = new MenuElement[]{this, this.menuElementPanel};
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
        }
    }

    public JPanel getMenuElementPanel() {
        return this.menuElementPanel;
    }

    @Override
    public void removeAll() {
        this.menuElementPanel.removeAll();
    }

    public void removeAllFromPopup() {
        super.removeAll();
    }

    public void setVisibleElements(Integer n) {
        this.setVisibleElements(n, false);
    }

    public void setVisibleElements(Integer n, boolean bl) {
        WidgetUtils.setUIProperty(this, "visibleElements", this.visibleElements, this.getVisibleElements(), n, bl, false, false);
    }

    public boolean visibleElementsIsUIResource() {
        return this.getVisibleElementsUIValue().isUIResource();
    }

    public Integer getVisibleElements() {
        return this.getVisibleElementsUIValue().get();
    }

    private UIValue<Integer> getVisibleElementsUIValue() {
        if (this.visibleElements == null) {
            this.visibleElements = new UIValue();
        }
        return this.visibleElements;
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateUIDefaults();
        }
    }

    private class KeyHandler
    extends KeyAdapter
    implements ChangeListener {
        private MenuElement[] lastPath = new MenuElement[0];
        private JRootPane rootPane;
        private boolean focusTraversalKeysEnabled;

        private KeyHandler() {
        }

        public void uninstall() {
            if (this.rootPane != null) {
                this.rootPane.removeKeyListener(this);
                this.rootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.rootPane = null;
            }
            this.lastPath = new MenuElement[0];
        }

        private JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            int n = menuElementArray.length - 1;
            while (n >= 0) {
                MenuElement menuElement = menuElementArray[n];
                if (menuElement instanceof JPopupMenu) {
                    return (JPopupMenu)menuElement;
                }
                --n;
            }
            return null;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu == null || !jPopupMenu.isFocusable()) {
                return;
            }
            if (this.lastPath.length == 0 && menuElementArray.length > 0 && menuElementArray[0] == JYPopupMenu.this) {
                this.rootPane = SwingUtilities.getRootPane(JYPopupMenu.this.getInvoker());
                if (this.rootPane != null) {
                    this.rootPane.requestFocus(true);
                    this.rootPane.addKeyListener(this);
                    this.focusTraversalKeysEnabled = this.rootPane.getFocusTraversalKeysEnabled();
                    this.rootPane.setFocusTraversalKeysEnabled(false);
                }
            }
            this.lastPath = menuElementArray;
        }

        public void keyPressed(KeyEvent keyEvent) {
            JPanel jPanel = JYPopupMenu.this.getMenuElementPanel();
            int n = jPanel.getComponentCount();
            if (n == 0) {
                return;
            }
            AbstractButton abstractButton = null;
            int n2 = n - 1;
            while (n2 >= 0) {
                if (jPanel.getComponent(n2) instanceof JMenuItem) {
                    abstractButton = (JMenuItem)jPanel.getComponent(n2);
                    break;
                }
                --n2;
            }
            if (abstractButton == null) {
                return;
            }
            if (MenuSelectionManager.defaultManager().getSelectedPath().length == 2) {
                MenuSelectionManager.defaultManager().setSelectedPath(((BasicMenuItemUI)abstractButton.getUI()).getPath());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MenuSelectionManager.defaultManager().getSelectedPath().length == 3) {
                        JMenuItem jMenuItem = (JMenuItem)MenuSelectionManager.defaultManager().getSelectedPath()[2].getComponent();
                        Rectangle rectangle = jMenuItem.getBounds();
                        JViewport jViewport = JYPopupMenu.this.scroller.getViewport();
                        int n = jViewport.getViewPosition().y;
                        int n2 = n + jViewport.getVisibleRect().height;
                        if (rectangle.y < n) {
                            jViewport.setViewPosition(new Point(0, rectangle.y));
                        } else if (rectangle.y >= n2) {
                            jViewport.setViewPosition(new Point(0, n + rectangle.y - n2 + rectangle.height));
                        }
                    }
                }
            });
        }
    }

    private class MenuElementPanel
    extends JPanel
    implements MenuElement,
    Scrollable {
        private static final long serialVersionUID = -555457288677345702L;

        public MenuElementPanel() {
            this.setName("JYPopupMenu.MenuElementPanel");
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(new AbstractBorder(){
                private static final long serialVersionUID = 7553579405198284896L;

                public Insets getBorderInsets(Component component) {
                    Insets insets = new Insets(0, 0, 0, 0);
                    if (JYPopupMenu.this.scroller != null && ((Container)component).getComponentCount() > JYPopupMenu.this.getVisibleElements()) {
                        if (MenuElementPanel.this.getComponentOrientation().isLeftToRight()) {
                            insets.right = JYPopupMenu.this.scrollBarGap;
                        } else {
                            insets.left = JYPopupMenu.this.scrollBarGap;
                        }
                    }
                    return insets;
                }
            });
        }

        public Component getComponent() {
            return this;
        }

        public MenuElement[] getSubElements() {
            ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>();
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof MenuElement) {
                    arrayList.add((MenuElement)((Object)component));
                }
                ++n2;
            }
            return arrayList.toArray(new MenuElement[0]);
        }

        public void menuSelectionChanged(boolean bl) {
        }

        public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }

        public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
            if ((mouseEvent.getModifiers() & 0x1F9) > 0) {
                JYPopupMenu.this.setVisible(false);
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.getScrollableUnitIncrement(rectangle, n, n2);
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.getComponentCount()) {
                Rectangle rectangle2 = this.getComponent(n4).getBounds();
                if (n2 < 0 && rectangle2.y + rectangle2.height <= rectangle.y || n2 > 0 && rectangle2.y >= rectangle.y + rectangle.height) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            return n3 < 0 ? 16 : this.getComponent(n3).getHeight();
        }
    }
}

