/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ViewportStyle
extends StyleWrapper {
    private static ViewportStyle instance = new ViewportStyle();

    private ViewportStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        ViewportStyle viewportStyle = new ViewportStyle();
        viewportStyle.setStyle(synthStyle);
        return viewportStyle;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        if (colorType == ColorType.BACKGROUND) {
            JViewport jViewport = (JViewport)synthContext.getComponent();
            Component component = jViewport.getView();
            if (component != null && component.getClass().getName().endsWith("JHEditorPane") && SyntheticaLookAndFeel.get("Synthetica.javaHelpEditorViewport.background", jViewport) != null) {
                return SyntheticaLookAndFeel.getColor("Synthetica.javaHelpEditorViewport.background", jViewport);
            }
            boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.viewport.dynamicBackgroundColorEnabled", jViewport);
            if (component != null && component instanceof JComponent && ((JComponent)component).isOpaque() && bl) {
                return component.getBackground();
            }
        }
        return super.getColor(synthContext, colorType);
    }
}

