/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.IterConvertProfile;
import sqlj.runtime.profile.ref.JDBCProfile;
import sqlj.runtime.profile.ref.ParamRegProfile;
import sqlj.runtime.profile.ref.PositionedProfile;
import sqlj.runtime.profile.ref.ProfileDataImpl;
import sqlj.runtime.profile.ref.ProfileWrapper;
import sqlj.runtime.profile.ref.TransactionControlProfile;
import sqlj.runtime.profile.ref.UntypedSelectProfile;

public class ProfileImpl
extends Profile {
    private String m_profileName;
    private String m_contextName;
    private long m_timestamp;
    private Vector m_customizations = new Vector();
    private ProfileData m_profileData;
    static final long serialVersionUID = -2161640844900440703L;

    public ProfileImpl(String string, String string2, EntryInfo[] entryInfoArray, Loader loader, String string3) {
        super(loader);
        this.m_profileName = string;
        this.m_contextName = string2;
        this.m_timestamp = System.currentTimeMillis();
        this.m_profileData = new ProfileDataImpl(entryInfoArray, this, string3);
    }

    public ProfileImpl(String string, String string2, EntryInfo[] entryInfoArray, Loader loader, String string3, long l7) {
        super(loader);
        this.m_profileName = string;
        this.m_contextName = string2;
        this.m_timestamp = l7;
        this.m_profileData = new ProfileDataImpl(entryInfoArray, this, string3);
    }

    @Override
    public String getProfileName() {
        return this.m_profileName;
    }

    @Override
    public String getContextName() {
        return this.m_contextName;
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public ProfileData getProfileData() {
        return this.m_profileData;
    }

    @Override
    public ConnectedProfile getConnectedProfile(Connection connection) throws SQLException {
        Enumeration enumeration = this.getCustomizations();
        while (enumeration.hasMoreElements()) {
            Customization customization = (Customization)enumeration.nextElement();
            if (!customization.acceptsConnection(connection)) continue;
            return customization.getProfile(connection, this);
        }
        return ProfileImpl.getDefaultProfile(connection, this.getProfileData());
    }

    public static ConnectedProfile getDefaultProfile(Connection connection, ProfileData profileData) {
        DynamicProfile dynamicProfile = new JDBCProfile(connection, profileData);
        dynamicProfile = new IterConvertProfile(dynamicProfile);
        dynamicProfile = new UntypedSelectProfile(dynamicProfile);
        dynamicProfile = new ParamRegProfile(dynamicProfile);
        ProfileWrapper profileWrapper = new PositionedProfile(dynamicProfile);
        profileWrapper = new TransactionControlProfile(profileWrapper);
        return profileWrapper;
    }

    @Override
    public void registerCustomization(Customization customization) {
        if (customization == null) {
            throw new NullPointerException();
        }
        this.m_customizations.addElement(customization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCustomization(Customization customization, Customization customization2) {
        if (customization == null) {
            throw new NullPointerException();
        }
        Vector vector = this.m_customizations;
        synchronized (vector) {
            int n2 = this.m_customizations.indexOf(customization2);
            if (n2 == -1) {
                throw new IllegalArgumentException(customization2 + "");
            }
            this.m_customizations.insertElementAt(customization, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceCustomization(Customization customization, Customization customization2) {
        if (customization == null) {
            throw new NullPointerException();
        }
        Vector vector = this.m_customizations;
        synchronized (vector) {
            int n2 = this.m_customizations.indexOf(customization2);
            if (n2 == -1) {
                throw new IllegalArgumentException(customization2 + "");
            }
            this.m_customizations.setElementAt(customization, n2);
        }
    }

    @Override
    public void deregisterCustomization(Customization customization) {
        if (!this.m_customizations.removeElement(customization)) {
            throw new IllegalArgumentException(customization + "");
        }
    }

    @Override
    public Enumeration getCustomizations() {
        return this.m_customizations.elements();
    }
}

